/*
 * Decompiled with CFR 0.152.
 */
package benchmark.generator;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;

public class DateGenerator {
    public static long oneDayInMillis = 86400000L;
    private long from;
    private long to;
    private Random ranGen;

    public DateGenerator(GregorianCalendar from, GregorianCalendar to, Long seed) {
        this.from = from.getTimeInMillis();
        this.to = to.getTimeInMillis();
        this.ranGen = new Random(seed);
    }

    public DateGenerator(GregorianCalendar from, Integer toSpanInDays, Long seed) {
        this.from = from.getTimeInMillis();
        this.to = this.from + oneDayInMillis * (long)toSpanInDays.intValue();
        this.ranGen = new Random(seed);
    }

    public DateGenerator(Integer fromSpanInDays, GregorianCalendar to, Long seed) {
        this.to = to.getTimeInMillis();
        this.from = this.to - oneDayInMillis * (long)fromSpanInDays.intValue();
        this.ranGen = new Random(seed);
    }

    public DateGenerator(Long seed) {
        this.from = 0L;
        this.to = 0L;
        this.ranGen = new Random(seed);
    }

    public GregorianCalendar randomDate() {
        long date = (long)(this.ranGen.nextDouble() * (double)(this.to - this.from) + (double)this.from);
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date(date));
        return gc;
    }

    public Long randomDateInMillis() {
        long date = (long)(this.ranGen.nextDouble() * (double)(this.to - this.from) + (double)this.from);
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date(date));
        return gc.getTimeInMillis();
    }

    public static String formatDate(GregorianCalendar c) {
        int day = c.get(5);
        int month = c.get(2) + 1;
        int year = c.get(1);
        String prefixDay = "";
        String prefixMonth = "";
        if (day < 10) {
            prefixDay = "0";
        }
        if (month < 10) {
            prefixMonth = "0";
        }
        return year + "-" + prefixMonth + month + "-" + prefixDay + day;
    }

    public static String formatDate(Long date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(date);
        return DateGenerator.formatDate(c);
    }

    public static String formatDateTime(Long date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(date);
        String dateString = DateGenerator.formatDate(c);
        return dateString + "T00:00:00";
    }

    public static String formatDateTime(GregorianCalendar date) {
        String dateString = DateGenerator.formatDate(date);
        return dateString + "T00:00:00";
    }

    public Long randomDateInMillis(Long from, Long to) {
        long date = (long)(this.ranGen.nextDouble() * (double)(to - from) + (double)from.longValue());
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date(date));
        return gc.getTimeInMillis();
    }
}

