/*
 * Decompiled with CFR 0.152.
 */
package benchmark.generator;

import benchmark.generator.DateGenerator;
import benchmark.generator.NormalDistGenerator;
import benchmark.generator.NormalDistRangeGenerator;
import benchmark.generator.RandomBucket;
import benchmark.generator.TextGenerator;
import benchmark.generator.ValueGenerator;
import benchmark.model.BSBMResource;
import benchmark.model.Offer;
import benchmark.model.Person;
import benchmark.model.Producer;
import benchmark.model.Product;
import benchmark.model.ProductFeature;
import benchmark.model.ProductType;
import benchmark.model.RatingSite;
import benchmark.model.Review;
import benchmark.model.Vendor;
import benchmark.serializer.MonetDBSerializer;
import benchmark.serializer.NTriples;
import benchmark.serializer.ObjectBundle;
import benchmark.serializer.SQLSerializer;
import benchmark.serializer.Serializer;
import benchmark.serializer.TriG;
import benchmark.serializer.Turtle;
import benchmark.serializer.VirtSerializer;
import benchmark.serializer.XMLSerializer;
import benchmark.vocabulary.BSBM;
import benchmark.vocabulary.ISO3166;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class Generator {
    private static int productCount = 100;
    private static boolean forwardChaining = false;
    private static String outputDirectory = "td_data";
    private static String outputFileName = "dataset";
    private static String serializerType = "nt";
    private static int nrOfOutputFiles = 1;
    private static boolean generateUpdateDataset = false;
    private static String updateDatasetFileName = "dataset_update";
    private static String updateDatasetTransactionSeparator = "\n#__SEP__\n";
    private static int nrOfTransactionsInUpdateDataset = 1000;
    private static int nrOfProductsPerTransaction = 1;
    private static int nrOfMinProductNrForUpdate = Integer.MAX_VALUE;
    private static Serializer updateDatasetSerializer = null;
    private static List<List<BSBMResource>> updateResourceData = null;
    static final int productsVendorsRatio = 100;
    static final int avgReviewsPerProduct = 10;
    static final int avgReviewsPerPerson = 20;
    static final int avgReviewsPerRatingSite = 10000;
    static final int avgProductsPerProducer = 50;
    static final int avgOffersPerProduct = 20;
    static final int avgOffersPerVendor = 2000;
    static final String dictionary1File = "titlewords.txt";
    static final String dictionary2File = "titlewords.txt";
    static final String dictionary3File = "givennames.txt";
    static final Random seedGenerator = new Random(53223436L);
    static TextGenerator dictionary1;
    static TextGenerator dictionary2;
    static TextGenerator dictionary3;
    static GregorianCalendar today;
    static int offerCount;
    static int reviewCount;
    static int productTypeCount;
    static List<Integer> maxProductTypeNrPerLevel;
    static boolean namedGraph;
    private static ArrayList<ProductType> productTypeLeaves;
    private static ArrayList<ProductType> productTypeNodes;
    public static ArrayList<Integer> producerOfProduct;
    public static ArrayList<Integer> vendorOfOffer;
    public static ArrayList<Integer> ratingsiteOfReview;
    private static HashMap<String, Integer> wordList;
    private static Serializer serializer;
    private static File outputDir;

    public static void init() {
        if (generateUpdateDataset) {
            if (nrOfProductsPerTransaction * nrOfTransactionsInUpdateDataset > productCount) {
                System.err.println("Product count not high enough to generate an update dataset of " + nrOfProductsPerTransaction * nrOfTransactionsInUpdateDataset + " products");
                System.exit(-1);
            }
            nrOfMinProductNrForUpdate = productCount - nrOfProductsPerTransaction * nrOfTransactionsInUpdateDataset + 1;
            updateDatasetSerializer = new NTriples(updateDatasetFileName, forwardChaining);
            updateResourceData = new ArrayList<List<BSBMResource>>();
            for (int i = 0; i < nrOfProductsPerTransaction * nrOfTransactionsInUpdateDataset; ++i) {
                updateResourceData.add(new ArrayList());
            }
        }
        offerCount = productCount * 20;
        reviewCount = 10 * productCount;
        producerOfProduct = new ArrayList();
        producerOfProduct.add(0);
        vendorOfOffer = new ArrayList();
        vendorOfOffer.add(0);
        ratingsiteOfReview = new ArrayList();
        ratingsiteOfReview.add(0);
        serializer = Generator.getSerializer(serializerType);
        if (serializer == null) {
            System.err.println("Invalid Serializer chosen.");
            System.exit(-1);
        }
        namedGraph = Generator.isNamedGraphSerializer();
        outputDir = new File(outputDirectory);
        outputDir.mkdirs();
        wordList = new HashMap();
        dictionary1 = new TextGenerator("titlewords.txt", seedGenerator.nextLong());
        dictionary2 = new TextGenerator("titlewords.txt", seedGenerator.nextLong());
        dictionary3 = new TextGenerator(dictionary3File, seedGenerator.nextLong());
        System.out.println("");
    }

    private static boolean isNamedGraphSerializer() {
        return serializer instanceof TriG;
    }

    private static Serializer getSerializer(String type) {
        String t = type.toLowerCase();
        if (t.equals("nt")) {
            return new NTriples(outputFileName, forwardChaining, nrOfOutputFiles);
        }
        if (t.equals("trig")) {
            return new TriG(outputFileName + ".trig", forwardChaining);
        }
        if (t.equals("ttl")) {
            return new Turtle(outputFileName, forwardChaining, nrOfOutputFiles);
        }
        if (t.equals("xml")) {
            return new XMLSerializer(outputFileName + ".xml", forwardChaining);
        }
        if (t.equals("sql")) {
            return new SQLSerializer(outputFileName, forwardChaining, "benchmark");
        }
        if (t.equals("virt")) {
            return new VirtSerializer(outputFileName, forwardChaining);
        }
        if (t.equals("monetdb")) {
            return new MonetDBSerializer(outputFileName, forwardChaining, "benchmark");
        }
        return null;
    }

    public static void writeTestDriverData() {
        File pth = new File(outputDir, "pth.dat");
        try {
            pth.createNewFile();
            ObjectOutputStream productTypeOutput = new ObjectOutputStream(new FileOutputStream(pth, false));
            productTypeOutput.writeObject(productTypeLeaves.toArray(new ProductType[0]));
            productTypeOutput.writeInt(productTypeCount);
            productTypeOutput.writeObject(maxProductTypeNrPerLevel);
        }
        catch (IOException e) {
            System.err.println("Could not open or create file " + pth.getAbsolutePath());
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        File pp = new File(outputDir, "pp.dat");
        try {
            pp.createNewFile();
            ObjectOutputStream productProducerOutput = new ObjectOutputStream(new FileOutputStream(pp, false));
            productProducerOutput.writeObject(producerOfProduct.toArray(new Integer[0]));
        }
        catch (IOException e) {
            System.err.println("Could not open or create file " + pp.getAbsolutePath());
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        File vo = new File(outputDir, "vo.dat");
        try {
            vo.createNewFile();
            ObjectOutputStream offerVendorOutput = new ObjectOutputStream(new FileOutputStream(vo, false));
            offerVendorOutput.writeObject(vendorOfOffer.toArray(new Integer[0]));
        }
        catch (IOException e) {
            System.err.println("Could not open or create file " + vo.getAbsolutePath());
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        File rr = new File(outputDir, "rr.dat");
        try {
            rr.createNewFile();
            ObjectOutputStream reviewRatingsiteOutput = new ObjectOutputStream(new FileOutputStream(rr, false));
            reviewRatingsiteOutput.writeObject(ratingsiteOfReview.toArray(new Integer[0]));
        }
        catch (IOException e) {
            System.err.println("Could not open or create file " + rr.getAbsolutePath());
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        File cdlw = new File(outputDir, "cdlw.dat");
        try {
            cdlw.createNewFile();
            ObjectOutputStream currentDateAndLabelWordsOutput = new ObjectOutputStream(new FileOutputStream(cdlw, false));
            currentDateAndLabelWordsOutput.writeInt(productCount);
            currentDateAndLabelWordsOutput.writeInt(reviewCount);
            currentDateAndLabelWordsOutput.writeInt(offerCount);
            currentDateAndLabelWordsOutput.writeObject(today);
            currentDateAndLabelWordsOutput.writeObject(wordList);
        }
        catch (IOException e) {
            System.err.println("Could not open or create file " + cdlw.getAbsolutePath());
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    private static int[] calcBranchingFactors(long scalefactor) {
        float logSF = (float)Math.log10(scalefactor);
        int depth = Math.round(logSF / 2.0f) + 1;
        int[] branchingFactors = new int[depth];
        branchingFactors[0] = 2 * Math.round(logSF);
        int[] temp = new int[]{2, 4, 8};
        for (int i = 1; i < depth; ++i) {
            int value;
            branchingFactors[i] = i + 1 < depth ? 8 : (value = temp[Math.round(logSF * 3.0f / 2.0f + 1.0f) % 3]);
        }
        return branchingFactors;
    }

    public static Long[] generateSeedsProductType() {
        Long[] seeds = new Long[2];
        for (int i = 0; i < seeds.length; ++i) {
            seeds[i] = seedGenerator.nextLong();
        }
        return seeds;
    }

    public static void createProductTypeHierarchy(Long[] seeds) {
        String publisher;
        System.out.println("Generating Product Type Hierarchy...");
        DateGenerator publishDateGen = new DateGenerator(new GregorianCalendar(2000, 5, 20), new GregorianCalendar(2000, 6, 23), seeds[0]);
        ValueGenerator valueGen = new ValueGenerator(seeds[1]);
        ObjectBundle bundle = new ObjectBundle(serializer);
        int[] branchFt = productCount >= 10 ? Generator.calcBranchingFactors(productCount) : Generator.calcBranchingFactors(10L);
        productTypeLeaves = new ArrayList();
        productTypeNodes = new ArrayList();
        maxProductTypeNrPerLevel = new ArrayList<Integer>();
        LinkedList<ProductType> typeQueue = new LinkedList<ProductType>();
        ProductType root = new ProductType(1, "Thing", "The Product Type of all Products", null);
        if (!namedGraph) {
            root.setPublisher(1);
            root.setPublishDate(publishDateGen.randomDateInMillis());
            publisher = BSBM.getStandardizationInstitution(1);
            bundle.setPublisher(publisher);
            bundle.setPublisherNum(1);
        } else {
            publisher = BSBM.getStandardizationInstitution(1);
            bundle.setPublisher("<" + publisher + ">");
            bundle.setPublishDate(publishDateGen.randomDateInMillis());
            bundle.setGraphName("<" + publisher + "/Graph-" + DateGenerator.formatDate(bundle.getPublishDate()) + ">");
        }
        productTypeNodes.add(root);
        typeQueue.offer(root);
        bundle.add(root);
        int oldDepth = -1;
        int nr = 1;
        while (!typeQueue.isEmpty()) {
            ProductType ptype = (ProductType)typeQueue.poll();
            int depth = ptype.getDepth();
            if (oldDepth != depth) {
                oldDepth = depth;
                maxProductTypeNrPerLevel.add(nr);
            }
            for (int i = 0; i < branchFt[ptype.getDepth()]; ++i) {
                int labelNrWords = valueGen.randomInt(1, 3);
                String label = dictionary1.getRandomSentence(labelNrWords);
                int commentNrWords = valueGen.randomInt(20, 50);
                String comment = dictionary2.getRandomSentence(commentNrWords);
                ProductType newType = new ProductType(++nr, label, comment, ptype);
                if (!namedGraph) {
                    newType.setPublisher(1);
                    newType.setPublishDate(publishDateGen.randomDateInMillis());
                }
                bundle.add(newType);
                if (depth == branchFt.length - 1) {
                    productTypeLeaves.add(newType);
                    continue;
                }
                productTypeNodes.add(newType);
                typeQueue.offer(newType);
            }
        }
        if (nr != maxProductTypeNrPerLevel.get(maxProductTypeNrPerLevel.size() - 1)) {
            maxProductTypeNrPerLevel.add(nr);
        }
        bundle.commitToSerializer();
        System.out.println("Product Type Hierarchy of depth " + branchFt.length + " with " + nr + " Product Types generated.\n");
        productTypeCount = nr;
    }

    public static Long[] generateSeedsProductFeature() {
        Long[] seeds = new Long[2];
        for (int i = 0; i < seeds.length; ++i) {
            seeds[i] = seedGenerator.nextLong();
        }
        return seeds;
    }

    public static void createProductFeatures(Long[] seeds) {
        ProductFeature pf;
        String comment;
        int commentNrWords;
        String label;
        int labelNrWords;
        int i;
        Vector<Integer> features;
        int count;
        int to;
        int from;
        String publisher;
        System.out.println("Generating Product Features...");
        ObjectBundle bundle = new ObjectBundle(serializer);
        ValueGenerator valueGen = new ValueGenerator(seeds[0]);
        DateGenerator publishDateGen = new DateGenerator(new GregorianCalendar(2000, 5, 20), new GregorianCalendar(2000, 6, 23), seeds[1]);
        int depth = productTypeLeaves.get(0).getDepth();
        int[] featureFrom = new int[depth];
        int[] featureTo = new int[depth];
        featureFrom[0] = 5;
        featureTo[0] = 5;
        int depthSum = depth * (depth + 1) / 2 - 1;
        for (int i2 = 2; i2 <= depth; ++i2) {
            featureFrom[i2 - 1] = 35 * i2 / depthSum;
            featureTo[i2 - 1] = 75 * i2 / depthSum;
        }
        int productFeatureNr = 1;
        Iterator<ProductType> it = productTypeNodes.iterator();
        it.next();
        if (namedGraph) {
            publisher = BSBM.getStandardizationInstitution(2);
            bundle.setPublisher("<" + publisher + ">");
            bundle.setPublishDate(publishDateGen.randomDateInMillis());
            bundle.setGraphName("<" + publisher + "/Graph-" + DateGenerator.formatDate(bundle.getPublishDate()) + ">");
        } else {
            publisher = BSBM.getStandardizationInstitution(2);
            bundle.setPublisher(publisher);
            bundle.setPublisherNum(2);
        }
        while (it.hasNext()) {
            ProductType pt = it.next();
            from = featureFrom[pt.getDepth()];
            to = featureTo[pt.getDepth()];
            count = valueGen.randomInt(from, to);
            features = new Vector<Integer>(count);
            for (i = 0; i < count; ++i) {
                labelNrWords = valueGen.randomInt(1, 3);
                label = dictionary1.getRandomSentence(labelNrWords);
                commentNrWords = valueGen.randomInt(20, 50);
                comment = dictionary2.getRandomSentence(commentNrWords);
                pf = new ProductFeature(productFeatureNr, label, comment);
                if (!namedGraph) {
                    pf.setPublisher(1);
                    pf.setPublishDate(publishDateGen.randomDateInMillis());
                }
                features.add(productFeatureNr);
                bundle.add(pf);
                ++productFeatureNr;
            }
            pt.setFeatures(features);
        }
        for (ProductType pt : productTypeLeaves) {
            from = featureFrom[pt.getDepth() - 1];
            to = featureTo[pt.getDepth() - 1];
            count = valueGen.randomInt(from, to);
            features = new Vector(count);
            for (i = 0; i < count; ++i) {
                labelNrWords = valueGen.randomInt(1, 3);
                label = dictionary1.getRandomSentence(labelNrWords);
                commentNrWords = valueGen.randomInt(20, 50);
                comment = dictionary2.getRandomSentence(commentNrWords);
                pf = new ProductFeature(productFeatureNr, label, comment);
                if (!namedGraph) {
                    pf.setPublisher(1);
                    pf.setPublishDate(publishDateGen.randomDateInMillis());
                }
                features.add(productFeatureNr);
                bundle.add(pf);
                ++productFeatureNr;
            }
            pt.setFeatures(features);
        }
        bundle.commitToSerializer();
        System.out.println(productFeatureNr - 1 + " Product Features generated.\n");
    }

    public static Long[] generateSeedsProducer() {
        Long[] seeds = new Long[5];
        for (int i = 0; i < 5; ++i) {
            seeds[i] = seedGenerator.nextLong();
        }
        return seeds;
    }

    public static void generateProducerDistribution(Long[] seeds) {
        NormalDistGenerator productCountGen = new NormalDistGenerator(3.0, 1.0, 50, seeds[3]);
        Integer productNr = 1;
        while (productNr <= productCount) {
            int hasNrProducts = productCountGen.getValue();
            if (productNr + hasNrProducts - 1 > productCount) {
                hasNrProducts = productCount - productNr + 1;
            }
            productNr = productNr + hasNrProducts;
            producerOfProduct.add(productNr - 1);
        }
    }

    public static void createProducerData(Long[] seeds) {
        int producerNr;
        System.out.println("Generating Producers and Products...");
        DateGenerator publishDateGen = new DateGenerator(new GregorianCalendar(2000, 7, 20), new GregorianCalendar(2005, 6, 23), seeds[0]);
        ValueGenerator valueGen = new ValueGenerator(seeds[1]);
        RandomBucket countryGen = Generator.createCountryGenerator(seeds[2]);
        Random productSeedGen = new Random(seeds[4]);
        ObjectBundle bundle = new ObjectBundle(serializer);
        int productNr = 1;
        for (producerNr = 1; producerNr < producerOfProduct.size(); ++producerNr) {
            int labelNrWords = valueGen.randomInt(1, 3);
            String label = dictionary1.getRandomSentence(labelNrWords);
            int commentNrWords = valueGen.randomInt(20, 50);
            String comment = dictionary2.getRandomSentence(commentNrWords);
            String homepage = TextGenerator.getProducerWebpage(producerNr);
            String country = (String)countryGen.getRandom();
            Producer p = new Producer(producerNr, label, comment, homepage, country);
            if (!namedGraph) {
                p.setPublisher(producerNr);
                p.setPublishDate(publishDateGen.randomDateInMillis());
                bundle.setPublisher(p.toString());
                bundle.setPublisherNum(p.getNr());
            } else {
                bundle.setPublisher(p.toString());
                bundle.setPublishDate(publishDateGen.randomDateInMillis());
                bundle.setGraphName("<" + Producer.getProducerNS(p.getNr()) + "Graph-" + DateGenerator.formatDate(bundle.getPublishDate()) + ">");
                bundle.setPublisherNum(p.getNr());
            }
            bundle.add(p);
            int hasNrProducts = producerOfProduct.get(producerNr) - producerOfProduct.get(producerNr - 1);
            Generator.createProductsOfProducer(bundle, producerNr, productNr, hasNrProducts, productSeedGen);
            bundle.commitToSerializer();
            productNr += hasNrProducts;
        }
        System.out.println(producerNr - 1 + " Producers and " + (productNr - 1) + " Products have been generated.\n");
    }

    private static void createProductsOfProducer(ObjectBundle bundle, Integer producer, Integer productNr, Integer hasNrProducts, Random productSeedGen) {
        DateGenerator publishDateGen = new DateGenerator(new GregorianCalendar(2000, 9, 20), new GregorianCalendar(2007, 0, 23), (Long)productSeedGen.nextLong());
        dictionary1.activateLogging(wordList);
        ValueGenerator valueGen = new ValueGenerator(productSeedGen.nextLong());
        NormalDistRangeGenerator productTypeBroker = new NormalDistRangeGenerator(0.0, 1.0, productTypeLeaves.size(), 2.0, productSeedGen.nextLong());
        NormalDistRangeGenerator numPropertyGen = new NormalDistRangeGenerator(0.0, 1.0, 2000, 2.0, productSeedGen.nextLong());
        RandomBucket productPropertyTypeGen = new RandomBucket(3, productSeedGen.nextLong());
        productPropertyTypeGen.add(40.0, 1);
        productPropertyTypeGen.add(20.0, 2);
        productPropertyTypeGen.add(40.0, 3);
        RandomBucket true25 = new RandomBucket(2, productSeedGen.nextLong());
        true25.add(75.0, false);
        true25.add(25.0, true);
        RandomBucket true50 = new RandomBucket(2, productSeedGen.nextLong());
        true50.add(50.0, false);
        true50.add(50.0, true);
        for (int nr = productNr.intValue(); nr < productNr + hasNrProducts; ++nr) {
            int labelNrWords = valueGen.randomInt(1, 3);
            String label = dictionary1.getRandomSentence(labelNrWords);
            int commentNrWords = valueGen.randomInt(50, 150);
            String comment = dictionary2.getRandomSentence(commentNrWords);
            ProductType productType = productTypeLeaves.get(productTypeBroker.getValue() - 1);
            int productPropertyType = (Integer)productPropertyTypeGen.getRandom();
            Integer[] numProperties = new Integer[6];
            String[] textProperties = new String[6];
            for (int i = 0; i < 3; ++i) {
                numProperties[i] = numPropertyGen.getValue();
                int nrWords = valueGen.randomInt(3, 15);
                textProperties[i] = dictionary2.getRandomSentence(nrWords);
            }
            numProperties[3] = null;
            textProperties[3] = null;
            boolean hasNum = false;
            boolean hasText = false;
            if (productPropertyType == 1) {
                hasText = true;
                hasNum = true;
            }
            if (productPropertyType == 2) {
                hasNum = (Boolean)true50.getRandom();
                hasText = (Boolean)true50.getRandom();
            }
            if (hasNum) {
                numProperties[3] = numPropertyGen.getValue();
            }
            if (hasText) {
                textProperties[3] = dictionary2.getRandomSentence(valueGen.randomInt(3, 15));
            }
            numProperties[4] = null;
            textProperties[4] = null;
            hasNum = false;
            hasText = false;
            if (productPropertyType == 1) {
                hasText = true;
                hasNum = true;
            }
            if (productPropertyType == 2 || productPropertyType == 3) {
                hasNum = (Boolean)true25.getRandom();
                hasText = (Boolean)true25.getRandom();
            }
            if (hasNum) {
                numProperties[4] = numPropertyGen.getValue();
            }
            if (hasText) {
                textProperties[4] = dictionary2.getRandomSentence(valueGen.randomInt(3, 15));
            }
            numProperties[5] = null;
            textProperties[5] = null;
            if (productPropertyType == 3) {
                if (((Boolean)true50.getRandom()).booleanValue()) {
                    numProperties[5] = numPropertyGen.getValue();
                }
                if (((Boolean)true50.getRandom()).booleanValue()) {
                    int nrWords = valueGen.randomInt(3, 15);
                    textProperties[5] = dictionary2.getRandomSentence(nrWords);
                }
            }
            Vector<Integer> features = new Vector<Integer>();
            ProductType tempPT = productType;
            while (tempPT.getParent() != null) {
                for (Integer feature : tempPT.getFeatures()) {
                    if (!((Boolean)true25.getRandom()).booleanValue()) continue;
                    features.add(feature);
                }
                tempPT = tempPT.getParent();
            }
            Product p = new Product(nr, label, comment, productType, producer);
            p.setProductPropertyNumeric(numProperties);
            p.setProductPropertyTextual(textProperties);
            p.setFeatures(features);
            if (!namedGraph) {
                p.setPublisher(producer);
                p.setPublishDate(publishDateGen.randomDateInMillis());
            }
            if (generateUpdateDataset && nr >= nrOfMinProductNrForUpdate) {
                updateResourceData.get(nr - nrOfMinProductNrForUpdate).add(p);
                continue;
            }
            bundle.add(p);
        }
        dictionary1.deactivateLogging();
    }

    public static Integer getProducerOfProduct(Integer productNr) {
        Integer producerNr = Collections.binarySearch(producerOfProduct, productNr);
        if (producerNr < 0) {
            producerNr = -producerNr.intValue() - 1;
        }
        return producerNr;
    }

    public static RandomBucket createCountryGenerator(Long seed) {
        RandomBucket countryGen = new RandomBucket(10, seed);
        countryGen.add(40.0, "US");
        countryGen.add(10.0, "GB");
        countryGen.add(10.0, "JP");
        countryGen.add(10.0, "CN");
        countryGen.add(5.0, "DE");
        countryGen.add(5.0, "FR");
        countryGen.add(5.0, "ES");
        countryGen.add(5.0, "RU");
        countryGen.add(5.0, "KR");
        countryGen.add(5.0, "AT");
        return countryGen;
    }

    public static Long[] generateSeedsVendor() {
        Long[] seeds = new Long[5];
        for (int i = 0; i < 5; ++i) {
            seeds[i] = seedGenerator.nextLong();
        }
        return seeds;
    }

    public static void generateVendorDistribution(Long[] seeds) {
        NormalDistGenerator offerCountGenerator = new NormalDistGenerator(3.0, 1.0, 2000, seeds[3]);
        Integer offerNr = 1;
        while (offerNr <= offerCount) {
            Integer offerCountVendor = offerCountGenerator.getValue();
            if (offerNr + offerCountVendor - 1 > offerCount) {
                offerCountVendor = offerCount - offerNr + 1;
            }
            offerNr = offerNr + offerCountVendor;
            vendorOfOffer.add(offerNr - 1);
        }
    }

    public static void createVendorData(Long[] seeds) {
        System.out.println("Generating Vendors and their Offers...");
        DateGenerator publishDateGen = new DateGenerator(new GregorianCalendar(2000, 9, 20), new GregorianCalendar(2007, 0, 23), seeds[0]);
        ValueGenerator valueGen = new ValueGenerator(seeds[1]);
        RandomBucket countryGen = Generator.createCountryGenerator(seeds[2]);
        Random offerSeedGen = new Random(seeds[4]);
        ObjectBundle bundle = new ObjectBundle(serializer);
        Integer offerNr = 1;
        Integer vendorNr = 1;
        while (offerNr <= offerCount) {
            int labelNrWords = valueGen.randomInt(1, 3);
            String label = dictionary1.getRandomSentence(labelNrWords);
            int commentNrWords = valueGen.randomInt(20, 50);
            String comment = dictionary2.getRandomSentence(commentNrWords);
            String homepage = TextGenerator.getVendorWebpage(vendorNr);
            String country = (String)countryGen.getRandom();
            Vendor v = new Vendor(vendorNr, label, comment, homepage, country);
            if (!namedGraph) {
                v.setPublisher(vendorNr);
                v.setPublishDate(publishDateGen.randomDateInMillis(today.getTimeInMillis() - 97L * DateGenerator.oneDayInMillis, today.getTimeInMillis()));
                bundle.setPublisher(v.toString());
                bundle.setPublisherNum(v.getNr());
            } else {
                bundle.setPublisher(v.toString());
                bundle.setPublishDate(publishDateGen.randomDateInMillis());
                bundle.setGraphName("<" + Vendor.getVendorNS(v.getNr()) + "Graph-" + DateGenerator.formatDate(bundle.getPublishDate()) + ">");
                bundle.setPublisherNum(v.getNr());
            }
            bundle.add(v);
            Integer offerCountVendor = vendorOfOffer.get(vendorNr) - vendorOfOffer.get(vendorNr - 1);
            Generator.createOffersOfVendor(bundle, vendorNr, offerNr, offerCountVendor, valueGen, offerSeedGen);
            bundle.commitToSerializer();
            offerNr = offerNr + offerCountVendor;
            Integer n = vendorNr;
            Integer n2 = vendorNr = Integer.valueOf(vendorNr + 1);
        }
        System.out.println(vendorNr - 1 + " Vendors and " + (offerNr - 1) + " Offers have been generated.\n");
    }

    public static void createOffersOfVendor(ObjectBundle bundle, Integer vendor, Integer offerNr, Integer hasNrOffers, ValueGenerator valueGen, Random offerSeedGen) {
        NormalDistRangeGenerator deliveryDaysGen = new NormalDistRangeGenerator(2.0, 1.0, 21, 14.2, offerSeedGen.nextLong());
        NormalDistRangeGenerator productNrGen = new NormalDistRangeGenerator(2.0, 1.0, productCount, 4.0, offerSeedGen.nextLong());
        DateGenerator dateGen = new DateGenerator(offerSeedGen.nextLong());
        for (int nr = offerNr.intValue(); nr < offerNr + hasNrOffers; ++nr) {
            int product = productNrGen.getValue();
            double price = valueGen.randomDouble(5.0, 10000.0);
            Long publishDate = namedGraph ? Long.valueOf(bundle.getPublishDate()) : dateGen.randomDateInMillis(today.getTimeInMillis() - 97L * DateGenerator.oneDayInMillis, today.getTimeInMillis());
            Long validFrom = publishDate - (long)valueGen.randomInt(0, 90) * DateGenerator.oneDayInMillis;
            Long validTo = publishDate + (long)valueGen.randomInt(7, 90) * DateGenerator.oneDayInMillis;
            int deliveryDays = deliveryDaysGen.getValue();
            String webpage = Vendor.getVendorNS(vendor) + "Offer" + nr + "/";
            Offer offer = new Offer(nr, product, vendor, price, validFrom, validTo, deliveryDays, webpage);
            if (!namedGraph) {
                offer.setPublishDate(publishDate);
                offer.setPublisher(vendor);
            }
            if (generateUpdateDataset && product >= nrOfMinProductNrForUpdate) {
                updateResourceData.get(product - nrOfMinProductNrForUpdate).add(offer);
                continue;
            }
            bundle.add(offer);
        }
    }

    public static Long[] generateSeedsRatingSite() {
        Long[] seeds = new Long[8];
        for (int i = 0; i < 8; ++i) {
            seeds[i] = seedGenerator.nextLong();
        }
        return seeds;
    }

    public static void generateRatingSiteDistribution(Long[] seeds) {
        NormalDistGenerator reviewCountPRSGen = new NormalDistGenerator(3.0, 1.0, 10000, seeds[6]);
        NormalDistGenerator reviewCountPPGen = new NormalDistGenerator(3.0, 1.0, 20, seeds[7]);
        Integer reviewNr = 1;
        Integer personNr = 1;
        Integer ratingSiteNr = 1;
        while (reviewNr <= reviewCount) {
            Integer n;
            Integer reviewCountRatingSite = reviewCountPRSGen.getValue();
            if (reviewNr + reviewCountRatingSite > reviewCount) {
                reviewCountRatingSite = reviewCount - reviewNr + 1;
            }
            Integer maxReviewForRatingSite = reviewNr + reviewCountRatingSite;
            while (reviewNr < maxReviewForRatingSite) {
                Integer reviewCountPerson = reviewCountPPGen.getValue0();
                if (reviewNr + reviewCountPerson > maxReviewForRatingSite) {
                    reviewCountPerson = maxReviewForRatingSite - reviewNr;
                }
                n = personNr;
                Integer n2 = personNr = Integer.valueOf(personNr + 1);
                reviewNr = reviewNr + reviewCountPerson;
            }
            ratingsiteOfReview.add(reviewNr - 1);
            Integer n3 = ratingSiteNr;
            n = ratingSiteNr = Integer.valueOf(ratingSiteNr + 1);
        }
    }

    public static void createRatingSiteData(Long[] seeds) {
        System.out.println("Generating RatingSite Data: Reviewers and Reviews... ");
        DateGenerator publishDateGen = new DateGenerator(new GregorianCalendar(2008, 5, 20), new GregorianCalendar(2008, 8, 23), seeds[0]);
        ValueGenerator valueGen = new ValueGenerator(seeds[1]);
        RandomBucket countryGen = Generator.createCountryGenerator(seeds[2]);
        DateGenerator reviewDateGen = new DateGenerator(182, today, seeds[3]);
        RandomBucket true70 = new RandomBucket(2, seeds[4]);
        NormalDistRangeGenerator productNrGen = new NormalDistRangeGenerator(2.0, 1.0, productCount, 4.0, seeds[5]);
        true70.add(70.0, true);
        true70.add(30.0, false);
        NormalDistGenerator reviewCountPRSGen = new NormalDistGenerator(3.0, 1.0, 10000, seeds[6]);
        NormalDistGenerator reviewCountPPGen = new NormalDistGenerator(3.0, 1.0, 20, seeds[7]);
        Integer reviewNr = 1;
        Integer personNr = 1;
        Integer ratingSiteNr = 1;
        ObjectBundle bundle = new ObjectBundle(serializer);
        while (reviewNr <= reviewCount) {
            Integer reviewCountRatingSite = reviewCountPRSGen.getValue();
            if (reviewNr + reviewCountRatingSite > reviewCount) {
                reviewCountRatingSite = reviewCount - reviewNr + 1;
            }
            if (namedGraph) {
                bundle.setPublisher(RatingSite.getURIref(ratingSiteNr));
                bundle.setPublishDate(publishDateGen.randomDateInMillis());
                bundle.setGraphName("<" + RatingSite.getRatingSiteNS(ratingSiteNr) + "Graph-" + DateGenerator.formatDate(bundle.getPublishDate()) + ">");
                bundle.setPublisherNum(ratingSiteNr);
            } else {
                bundle.setPublisher(RatingSite.getURIref(ratingSiteNr));
                bundle.setPublisherNum(ratingSiteNr);
            }
            Integer maxReviewForRatingSite = reviewNr + reviewCountRatingSite;
            while (reviewNr < maxReviewForRatingSite) {
                String name = dictionary3.getRandomSentence(1);
                String country = (String)countryGen.getRandom();
                String mbox_sha1 = valueGen.randomSHA1();
                Person p = new Person(personNr, name, country, mbox_sha1);
                if (!namedGraph) {
                    p.setPublishDate(publishDateGen.randomDateInMillis());
                }
                p.setPublisher(ratingSiteNr);
                bundle.add(p);
                Integer reviewCountPerson = reviewCountPPGen.getValue0();
                if (reviewNr + reviewCountPerson > maxReviewForRatingSite) {
                    reviewCountPerson = maxReviewForRatingSite - reviewNr;
                }
                Generator.createReviewsOfPerson(bundle, p, reviewNr, reviewCountPerson, valueGen, reviewDateGen, productNrGen, publishDateGen, true70);
                Integer n = personNr;
                Integer n2 = personNr = Integer.valueOf(personNr + 1);
                reviewNr = reviewNr + reviewCountPerson;
            }
            bundle.commitToSerializer();
            Integer n = ratingSiteNr;
            Integer n3 = ratingSiteNr = Integer.valueOf(ratingSiteNr + 1);
        }
        System.out.println(ratingSiteNr - 1 + " Rating Sites with " + (personNr - 1) + " Persons and " + (reviewNr - 1) + " Reviews have been generated.\n");
    }

    private static void createReviewsOfPerson(ObjectBundle bundle, Person person, Integer reviewNr, Integer count, ValueGenerator valueGen, DateGenerator dateGen, NormalDistRangeGenerator prodNrGen, DateGenerator publishDateGen, RandomBucket true70) {
        for (int i = 0; i < count; ++i) {
            int product = prodNrGen.getValue();
            int producerOfProduct = Generator.getProducerOfProduct(product);
            int personNr = person.getNr();
            Long reviewDate = dateGen.randomDateInMillis(today.getTimeInMillis() - DateGenerator.oneDayInMillis * 365L, today.getTimeInMillis());
            int titleCount = valueGen.randomInt(4, 15);
            String title = dictionary2.getRandomSentence(titleCount);
            int textCount = valueGen.randomInt(50, 200);
            String text = dictionary2.getRandomSentence(textCount);
            byte language = ISO3166.countryCodes.get(person.getCountryCode());
            Integer[] ratings = new Integer[4];
            for (int j = 0; j < 4; ++j) {
                ratings[j] = (Boolean)true70.getRandom() != false ? Integer.valueOf(valueGen.randomInt(1, 10)) : null;
            }
            Review review = new Review(reviewNr, product, personNr, reviewDate, title, text, ratings, language, producerOfProduct);
            if (!namedGraph) {
                review.setPublishDate(publishDateGen.randomDateInMillis(reviewDate, today.getTimeInMillis()));
            }
            review.setPublisher(person.getPublisher());
            if (generateUpdateDataset && product >= nrOfMinProductNrForUpdate) {
                updateResourceData.get(product - nrOfMinProductNrForUpdate).add(review);
            } else {
                bundle.add(review);
            }
            Integer n = reviewNr;
            Integer n2 = reviewNr = Integer.valueOf(reviewNr + 1);
        }
    }

    protected static void createUpdateDataset() {
        int productsInTransaction = 0;
        ObjectBundle bundle = new ObjectBundle(updateDatasetSerializer);
        for (List<BSBMResource> productData : updateResourceData) {
            for (BSBMResource res : productData) {
                bundle.add(res);
            }
            bundle.commitToSerializer();
            if ((productsInTransaction = (productsInTransaction + 1) % nrOfProductsPerTransaction) != 0) continue;
            bundle.writeStringToSerializer(updateDatasetTransactionSeparator);
        }
        updateDatasetSerializer.serialize();
    }

    private static void processProgramParameters(String[] args) {
        int i = 0;
        while (i < args.length) {
            try {
                if (args[i].equals("-s")) {
                    serializerType = args[i++ + 1];
                } else if (args[i].equals("-pc")) {
                    productCount = Integer.parseInt(args[i++ + 1]);
                } else if (args[i].equals("-fc")) {
                    forwardChaining = true;
                } else if (args[i].equals("-dir")) {
                    outputDirectory = args[i++ + 1];
                } else if (args[i].equals("-fn")) {
                    outputFileName = args[i++ + 1];
                } else if (args[i].equals("-ufn")) {
                    updateDatasetFileName = args[i++ + 1];
                } else if (args[i].equals("-nof")) {
                    nrOfOutputFiles = Integer.parseInt(args[i++ + 1]);
                } else if (args[i].equals("-ud")) {
                    generateUpdateDataset = true;
                } else if (args[i].equals("-tc")) {
                    nrOfTransactionsInUpdateDataset = Integer.parseInt(args[i++ + 1]);
                } else if (args[i].equals("-ppt")) {
                    nrOfProductsPerTransaction = Integer.parseInt(args[i++ + 1]);
                } else if (args[i].equals("-sep")) {
                    updateDatasetTransactionSeparator = String.valueOf(args[i++ + 1]);
                } else {
                    Generator.printUsageInfos();
                    System.exit(-1);
                }
                ++i;
            }
            catch (Exception e) {
                System.err.println("Invalid arguments\n");
                Generator.printUsageInfos();
                System.exit(-1);
            }
        }
    }

    public static void printUsageInfos() {
        String output = "Usage:\n\nPossible options are:\n\t-s <output format>\n\t\twhere <output format>: nt (N-Triples), trig (TriG), ttl (Turtle), sql (MySQL dump),\n\t\t\tvirt (Virtuoso SQL dump), monetdb (SQL), xml (XML dump)\n\t\tdefault: nt\n\t\tNote:\tBy chosing a named graph output format like TriG,\n\t\t\ta named graph model gets generated.\n\t-pc <product count>\n\t\tdefault: 100\n\t-fc\tSwitch on forward chaining which is by default off\n\t-dir <output directory>\n\t\tThe output directory for the Test Driver data\n\t\tdefault: td_data\n\t-fn <dataset file name>\n\t\tThe file name without the output format suffix\n\t\tdefault: dataset\n\t-ufn <update dataset file name>\n\t\tThe file name without the output format suffix\n\t\tdefault: dataset_update\n\t-nof <number of output files>\n\t\tThe number of output files. Only for -s nt or ttl\n\t\tdefault: 1\n\t-ud Switch on generation of update dataset\n\t-tc <number of update transactions>\n\t\tShould be used in combination with -ud.\n\t\tdefault: 1000\n\t-ppt <number of products per update transactions>\n\t\tShould be used in combination with -ud.\n\t\tdefault: 1\n";
        System.out.print(output);
    }

    public static void main(String[] args) {
        Generator.processProgramParameters(args);
        Generator.init();
        Long[] ptSeeds = Generator.generateSeedsProductType();
        Long[] pfSeeds = Generator.generateSeedsProductFeature();
        Long[] producerSeeds = Generator.generateSeedsProducer();
        Long[] vendorSeeds = Generator.generateSeedsVendor();
        Long[] rtSeeds = Generator.generateSeedsRatingSite();
        Generator.generateProducerDistribution(producerSeeds);
        Generator.generateVendorDistribution(vendorSeeds);
        Generator.generateRatingSiteDistribution(rtSeeds);
        Generator.createProductTypeHierarchy(ptSeeds);
        Generator.createProductFeatures(pfSeeds);
        Generator.createProducerData(producerSeeds);
        Generator.createVendorData(vendorSeeds);
        Generator.createRatingSiteData(rtSeeds);
        serializer.serialize();
        Generator.writeTestDriverData();
        if (generateUpdateDataset) {
            Generator.createUpdateDataset();
        }
        System.out.println(serializer.triplesGenerated() + " triples generated.");
        if (generateUpdateDataset) {
            System.out.println(updateDatasetSerializer.triplesGenerated() + " triples generated for update dataset.");
        }
    }

    static {
        today = new GregorianCalendar(2008, 5, 20);
    }
}

