/*
 * Decompiled with CFR 0.152.
 */
package benchmark.generator;

import java.util.Random;
import umontreal.iro.lecuyer.probdist.NormalDistQuick;

public class NormalDistRangeGenerator {
    private NormalDistQuick normal;
    private int max;
    private double normalLimit;
    private Random ranGen;

    public NormalDistRangeGenerator(double mu, double sigma, int maxValue, double normalLimit, long seed) {
        this.normal = new NormalDistQuick(mu, sigma);
        this.max = maxValue;
        this.normalLimit = normalLimit;
        this.ranGen = new Random(seed);
    }

    public int getValue() {
        double randVal = this.normal.inverseF(this.ranGen.nextDouble());
        while (randVal > this.normalLimit || randVal < 0.0) {
            randVal = this.normal.inverseF(this.ranGen.nextDouble());
        }
        return (int)(randVal / this.normalLimit * (double)this.max + 1.0);
    }
}

