/*
 * Decompiled with CFR 0.152.
 */
package benchmark.generator;

import java.util.Random;

public class RandomBucket {
    private double[] cumulativePercentage;
    private Object[] objects;
    private int index;
    private double totalPercentage;
    private Random ranGen;

    public RandomBucket(int size) {
        this.cumulativePercentage = new double[size];
        this.objects = new Object[size];
        this.index = 0;
        this.totalPercentage = 0.0;
        this.ranGen = new Random();
    }

    public RandomBucket(int size, long seed) {
        this.cumulativePercentage = new double[size];
        this.objects = new Object[size];
        this.index = 0;
        this.totalPercentage = 0.0;
        this.ranGen = new Random(seed);
    }

    public void add(double percentage, Object obj) {
        if (this.index == this.objects.length) {
            System.err.println("No more objects can be added into Bucket!");
            return;
        }
        this.objects[this.index] = obj;
        this.cumulativePercentage[this.index] = percentage;
        this.totalPercentage += percentage;
        ++this.index;
        if (this.index == this.objects.length) {
            double cumul = 0.0;
            for (int i = 0; i < this.objects.length; ++i) {
                this.cumulativePercentage[i] = cumul += this.cumulativePercentage[i] / this.totalPercentage;
            }
        }
    }

    public Object getRandom() {
        double randIndex = this.ranGen.nextDouble();
        for (int i = 0; i < this.objects.length; ++i) {
            if (!(randIndex <= this.cumulativePercentage[i])) continue;
            return this.objects[i];
        }
        return this.objects[this.objects.length - 1];
    }
}

