/*
 * Decompiled with CFR 0.152.
 */
package benchmark.generator;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;

public class TextGenerator {
    RandomAccessFile dictionary;
    private Random ranGen;
    private HashMap<String, Integer> logList;
    private Vector<String> words;
    private static final int FINDSTART = 1;
    private static final int READWORD = 2;
    private static final int FINISHED = 3;
    private static final int EOF = 4;

    public TextGenerator(String file) {
        this.ranGen = new Random();
        this.init(file);
    }

    public TextGenerator(String file, long seed) {
        this.ranGen = new Random(seed);
        this.init(file);
    }

    private void init(String file) {
        try {
            this.dictionary = new RandomAccessFile(file, "r");
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        System.out.print("Reading in " + file + ": ");
        this.logList = null;
        this.createWordList();
        try {
            this.dictionary.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    private void createWordList() {
        this.words = new Vector();
        while (true) {
            StringBuffer word = new StringBuffer();
            try {
                int state = 1;
                char c = ' ';
                while (state != 3) {
                    try {
                        c = (char)this.dictionary.readByte();
                    }
                    catch (EOFException eof) {
                        state = 4;
                        break;
                    }
                    switch (state) {
                        case 1: {
                            if (this.isLetter(c)) {
                                state = 2;
                            }
                        }
                        case 2: {
                            if (this.isLetter(c)) {
                                word.append(c);
                                break;
                            }
                            state = 3;
                        }
                    }
                }
                if (word.length() > 0) {
                    String wordString = word.toString();
                    this.words.add(wordString);
                }
                if (state != 4) continue;
            }
            catch (IOException e) {
                System.err.println("Couldn't get word.\n" + e.getMessage());
                continue;
            }
            break;
        }
        System.out.println(this.words.size() + " words read in.");
    }

    private String getRandomWord() {
        int index = this.ranGen.nextInt(this.words.size());
        String word = this.words.elementAt(index);
        if (this.logList != null) {
            this.addWordToWordlist(word);
        }
        return word;
    }

    private void addWordToWordlist(String word) {
        Integer count = 1;
        if (this.logList.containsKey(word)) {
            Integer n = count = this.logList.get(word);
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        this.logList.put(word, count);
    }

    public String getRandomSentence(int numberWords) {
        StringBuffer sentence = new StringBuffer();
        if (numberWords > 0) {
            sentence.append(this.getRandomWord());
        }
        for (int i = 1; i < numberWords; ++i) {
            sentence.append(" ");
            sentence.append(this.getRandomWord());
        }
        return sentence.toString();
    }

    private boolean isLetter(char c) {
        return Character.isLetter(c) || c == '-';
    }

    public static String getProducerWebpage(int producerNr) {
        StringBuffer s = new StringBuffer();
        s.append("http://www.Producer");
        s.append(producerNr);
        s.append(".com/");
        return s.toString();
    }

    public static String getVendorWebpage(int vendorNr) {
        StringBuffer s = new StringBuffer();
        s.append("http://www.vendor");
        s.append(vendorNr);
        s.append(".com/");
        return s.toString();
    }

    public HashMap<String, Integer> getWordList() {
        return this.logList;
    }

    public void activateLogging(HashMap<String, Integer> logList) {
        this.logList = logList;
    }

    public void deactivateLogging() {
        this.logList = null;
    }
}

