/*
 * Decompiled with CFR 0.152.
 */
package benchmark.generator;

import benchmark.generator.TextGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class ValueGenerator {
    private Random ranGen;

    public ValueGenerator(long seed) {
        this.ranGen = new Random(seed);
    }

    public int randomInt(int from, int to) {
        return this.ranGen.nextInt(to - from + 1) + from;
    }

    public double randomDouble(double from, double to) {
        return this.ranGen.nextDouble() * (to - from) + from;
    }

    public long randomLong(long from, long to) {
        return (long)this.ranGen.nextDouble() * (to - from + 1L) + from;
    }

    public String randomTextString(int length) {
        char[] temp = new char[length];
        for (int i = 0; i < length; ++i) {
            temp[i] = (char)(this.ranGen.nextDouble() * 26.0 + 97.0);
        }
        return new String(temp);
    }

    public String randomSHA1() {
        byte[] b = new byte[4];
        int i = this.ranGen.nextInt();
        for (int j = 0; j < 4; ++j) {
            b[j] = (byte)(i % 256);
            i >>= 8;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        byte[] chksum = md.digest(b);
        StringBuffer result = new StringBuffer();
        for (int j = 0; j < chksum.length; ++j) {
            result.append(Integer.toHexString(0xFF & chksum[j]));
        }
        return result.toString();
    }

    public static void main(String[] argv) {
        TextGenerator textGen = new TextGenerator("familynames.txt", 5235332L);
        System.out.println(textGen.getRandomSentence(20));
    }
}

