/*
 * Decompiled with CFR 0.152.
 */
package benchmark.model;

import benchmark.model.BSBMResource;
import benchmark.model.Vendor;
import java.util.Locale;

public class Offer
extends BSBMResource {
    private int nr;
    private Integer product;
    private int vendor;
    private double price;
    private long validFrom;
    private long validTo;
    private Integer deliveryDays;
    private String offerWebpage;

    public Offer(int nr, Integer product, int vendor, double price, long validFrom, long validTo, int deliveryDays, String offerWebpage) {
        this.nr = nr;
        this.product = product;
        this.vendor = vendor;
        this.price = price;
        this.validFrom = validFrom;
        this.validTo = validTo;
        this.deliveryDays = deliveryDays;
        this.offerWebpage = offerWebpage;
    }

    public int getNr() {
        return this.nr;
    }

    public void setNr(int nr) {
        this.nr = nr;
    }

    public Integer getProduct() {
        return this.product;
    }

    public void setProduct(Integer product) {
        this.product = product;
    }

    public int getVendor() {
        return this.vendor;
    }

    public void setVendor(int vendor) {
        this.vendor = vendor;
    }

    public double getPrice() {
        return this.price;
    }

    public String getPriceString() {
        return String.format(Locale.ENGLISH, "%.2f", this.price);
    }

    public void setPrice(float price) {
        this.price = price;
    }

    public long getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(long validFrom) {
        this.validFrom = validFrom;
    }

    public long getValidTo() {
        return this.validTo;
    }

    public void setValidTo(long validTo) {
        this.validTo = validTo;
    }

    public Integer getDeliveryDays() {
        return this.deliveryDays;
    }

    public void setDeliveryDays(Integer deliveryDays) {
        this.deliveryDays = deliveryDays;
    }

    public String getOfferWebpage() {
        return this.offerWebpage;
    }

    public void setOfferWebpage(String offerWebpage) {
        this.offerWebpage = offerWebpage;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("<");
        s.append(Vendor.getVendorNS(this.vendor));
        s.append("Offer");
        s.append(this.nr);
        s.append(">");
        return s.toString();
    }

    public String getPrefixed() {
        StringBuffer s = new StringBuffer();
        s.append(Vendor.getVendorNSprefixed(this.vendor));
        s.append("Offer");
        s.append(this.nr);
        return s.toString();
    }

    public static String getURIref(int offerNr, int vendorNr) {
        StringBuffer s = new StringBuffer();
        s.append("<");
        s.append(Vendor.getVendorNS(vendorNr));
        s.append("Offer");
        s.append(offerNr);
        s.append(">");
        return s.toString();
    }
}

