/*
 * Decompiled with CFR 0.152.
 */
package benchmark.model;

import benchmark.model.BSBMResource;
import benchmark.model.RatingSite;

public class Review
extends BSBMResource {
    private int nr;
    private Integer product;
    private Integer producerOfProduct;
    private int person;
    private long reviewDate;
    private String title;
    private String text;
    private Integer[] ratings;
    private int language;

    public Review(int nr, Integer forProductNr, int byPersonNr, long reviewDate, String title, String text, Integer[] ratings, int languageCode, Integer producerOfProduct) {
        this.nr = nr;
        this.product = forProductNr;
        this.person = byPersonNr;
        this.reviewDate = reviewDate;
        this.title = title;
        this.text = text;
        this.ratings = ratings;
        this.language = languageCode;
        this.producerOfProduct = producerOfProduct;
    }

    public int getNr() {
        return this.nr;
    }

    public Integer getProduct() {
        return this.product;
    }

    public int getPerson() {
        return this.person;
    }

    public long getReviewDate() {
        return this.reviewDate;
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public Integer[] getRatings() {
        return this.ratings;
    }

    public String toString() {
        return Review.getURIref(this.nr, this.publisher);
    }

    public static String getURIref(int reviewNr, int ratingSiteNr) {
        StringBuffer s = new StringBuffer();
        s.append("<");
        s.append(RatingSite.getRatingSiteNS(ratingSiteNr));
        s.append("Review");
        s.append(reviewNr);
        s.append(">");
        return s.toString();
    }

    public static String getPrefixed(int reviewNr, int ratingSiteNr) {
        StringBuffer s = new StringBuffer();
        s.append(RatingSite.getRatingSiteNSprefixed(ratingSiteNr));
        s.append("Review");
        s.append(reviewNr);
        return s.toString();
    }

    public int getLanguage() {
        return this.language;
    }

    public Integer getProducerOfProduct() {
        return this.producerOfProduct;
    }

    public void setProducerOfProduct(Integer producerOfProduct) {
        this.producerOfProduct = producerOfProduct;
    }
}

