/*
 * Decompiled with CFR 0.152.
 */
package benchmark.qualification;

import benchmark.qualification.QueryResult;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class Qualification {
    private ObjectInputStream examineStream;
    private ObjectInputStream correctStream;
    private int[] totalQueryCount;
    private int[] correctQueryCount;
    private boolean resultsCountOnly = false;
    private String qualificationLog = "qual.log";

    public Qualification(String correctFile, String testFile, String[] args) {
        try {
            this.examineStream = new ObjectInputStream(new FileInputStream(testFile));
            this.correctStream = new ObjectInputStream(new FileInputStream(correctFile));
            int maxQuery = Math.max(this.examineStream.readInt(), this.correctStream.readInt());
            this.totalQueryCount = new int[maxQuery];
            this.correctQueryCount = new int[maxQuery];
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        this.processProgramParameters(args);
    }

    public static void main(String[] argv) {
        if (argv.length < 2) {
            Qualification.printUsageInfo();
            System.exit(-1);
        }
        int arglength = argv.length;
        Qualification validator = new Qualification(argv[arglength - 2], argv[arglength - 1], Arrays.copyOf(argv, arglength - 2));
        validator.test();
    }

    private void processProgramParameters(String[] args) {
        int i = 0;
        while (i < args.length) {
            try {
                if (args[i].equals("-ql")) {
                    this.qualificationLog = args[i++ + 1];
                } else if (args[i].equals("-rc")) {
                    this.resultsCountOnly = true;
                } else {
                    System.err.println("Unknown parameter: " + args[i]);
                    Qualification.printUsageInfo();
                    System.exit(-1);
                }
                ++i;
            }
            catch (Exception e) {
                System.err.println("Invalid arguments\n");
                Qualification.printUsageInfo();
                System.exit(-1);
            }
        }
    }

    private void test() {
        try {
            int i;
            FileWriter resultWriter = new FileWriter(this.qualificationLog);
            System.out.println("Starting validation...\n");
            if (this.examineStream.readLong() != this.correctStream.readLong()) {
                System.err.println("Error: Trying to compare runs with different random number generator seeds!");
                System.exit(-1);
            }
            if (this.examineStream.readInt() != this.correctStream.readInt()) {
                System.err.println("Error: Trying to compare runs with different scale factors!");
                System.exit(-1);
            }
            if (this.examineStream.readInt() != this.correctStream.readInt()) {
                System.err.println("Error: Trying to compare runs with different query mix counts!");
                System.exit(-1);
            }
            Integer[] correctQuerymix = (Integer[])this.correctStream.readObject();
            Integer[] examineQuerymix = (Integer[])this.examineStream.readObject();
            boolean[] correctIgnoreQueries = (boolean[])this.correctStream.readObject();
            boolean[] examineIgnoreQueries = (boolean[])this.examineStream.readObject();
            for (i = 0; i < correctIgnoreQueries.length && i < examineIgnoreQueries.length; ++i) {
                if (correctIgnoreQueries[i] == examineIgnoreQueries[i]) continue;
                System.err.println("Error: Not the same run setup! Ignored queries (Query " + (i + 1) + ") for only one run found.");
                System.exit(-1);
            }
            for (i = 0; i < correctQuerymix.length; ++i) {
                int b;
                int a = correctQuerymix[i];
                if (a == (b = examineQuerymix[i].intValue())) continue;
                System.err.println("Error: Not the same run setup! Querymixes differ from each other at number " + (i + 1) + ".");
                System.exit(-1);
            }
            String error = null;
            QueryResult examine = null;
            QueryResult correct = null;
            resultWriter.append("Qualification results: Single Queries (the qualification overview is at the end of this file)\n\n");
            try {
                while (true) {
                    String text;
                    examine = (QueryResult)this.examineStream.readObject();
                    correct = (QueryResult)this.correctStream.readObject();
                    error = null;
                    if (examine.getQueryNr() != correct.getQueryNr()) {
                        System.err.println("Error: Query order is different in both runs!");
                        System.exit(-1);
                    }
                    int n = examine.getQueryNr() - 1;
                    this.totalQueryCount[n] = this.totalQueryCount[n] + 1;
                    if (!this.resultsCountOnly) {
                        ArrayList<String> headExamine = examine.getHeadList();
                        ArrayList<String> headCorrect = examine.getHeadList();
                        if (headExamine.size() != headCorrect.size()) {
                            error = this.addError(error, "Different count of result variables.\n");
                        } else {
                            for (int i2 = 0; i2 < headExamine.size(); ++i2) {
                                if (headExamine.get(i2).equals(headCorrect.get(i2))) continue;
                                error = this.addError(error, "Head differs");
                            }
                        }
                    }
                    if (examine.isSorted() != correct.isSorted()) {
                        error = this.addError(error, "Trying to compare sorted results to unsorted ones.\n");
                    } else if (examine.getNrResults() != correct.getNrResults()) {
                        text = "Number of results expected: " + correct.getNrResults() + "\n";
                        text = text + "Number of results returned: " + examine.getNrResults() + "\n";
                        error = this.addError(error, text);
                    } else if (!this.resultsCountOnly && (text = examine.compareQueryResults(correct)) != null) {
                        error = this.addError(error, text);
                    }
                    if (error == null) {
                        int n2 = examine.getQueryNr() - 1;
                        this.correctQueryCount[n2] = this.correctQueryCount[n2] + 1;
                        continue;
                    }
                    resultWriter.append("\nResult for Query " + examine.getQueryNr() + " of run " + examine.getRun() + " differs:\n");
                    resultWriter.append(error);
                }
            }
            catch (EOFException e) {
                resultWriter.append("\n______________________________________________\n\nQualification overview:\n\n");
                for (int i3 = 0; i3 < this.totalQueryCount.length; ++i3) {
                    resultWriter.append("Query " + (i3 + 1) + ":");
                    if (this.totalQueryCount[i3] > 0) {
                        resultWriter.append(" correct/total executions: " + this.correctQueryCount[i3] + "/" + this.totalQueryCount[i3] + "\n");
                        resultWriter.append(" correct/total ratio:" + 100 * this.correctQueryCount[i3] / this.totalQueryCount[i3] + "%\n\n");
                        continue;
                    }
                    resultWriter.append("Query was not executed or ignored.\n\n");
                }
                resultWriter.flush();
                resultWriter.close();
                System.out.println("Qualification finished. Results written to " + this.qualificationLog + ".");
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private String addError(String errorString, String error) {
        errorString = errorString == null ? error : errorString + error;
        return errorString;
    }

    private static void printUsageInfo() {
        String output = "Usage: java benchmark.qualification.Qualification <options> Correct.qual Test.qual\n\nCorrect.qual: file of a correct run\n\nTest.qual: file of a run to test against Correct.qual\n\nPossible options are:\n\t-rc\n\t\tOnly check the number of results, not the result content.\n\t\tdefault: false\n\t-ql <qualification log file>\n\t\tWhere to write the qualification log data into.\n\t\tdefault: qual.log\n";
        System.out.print(output);
    }
}

