/*
 * Decompiled with CFR 0.152.
 */
package benchmark.qualification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class QueryResult
implements Serializable {
    static final long serialVersionUID = 1L;
    private int run;
    private int queryNr;
    private String queryText;
    private int nrResults;
    private boolean sorted;
    private HashMap<String, Integer> resultHash;
    private ArrayList<String> resultList;
    private ArrayList<String> headList;

    public int getRun() {
        return this.run;
    }

    public void setRun(int run) {
        this.run = run;
    }

    public QueryResult(int queryNum, String queryText, int nrResults, boolean sorted, ArrayList<String> heads) {
        this.queryNr = queryNum;
        this.queryText = queryText;
        this.nrResults = nrResults;
        this.sorted = sorted;
        this.headList = heads;
        if (sorted) {
            this.resultList = new ArrayList();
        } else {
            this.resultHash = new HashMap();
        }
    }

    public int getQueryNr() {
        return this.queryNr;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public int getNrResults() {
        return this.nrResults;
    }

    public void addResult(String result) {
        if (this.sorted) {
            this.resultList.add(result);
        } else {
            Integer count = 1;
            if (this.resultHash.containsKey(result)) {
                Integer n = count = this.resultHash.get(result);
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            this.resultHash.put(result, count);
        }
    }

    public String compareQueryResults(QueryResult other) {
        String error = null;
        error = this.sorted ? this.checkArrayList(other.resultList) : this.checkHashMap(other);
        return error;
    }

    private String checkArrayList(ArrayList<String> otherList) {
        String error = null;
        for (int i = 0; i < otherList.size(); ++i) {
            if (otherList.get(i).equals(this.resultList.get(i))) continue;
            error = this.addError(error, "Wrong results and/or wrong ordering in row " + (i + 1) + ".\n");
            error = this.addError(error, "\tCorrect: " + otherList.get(i));
            error = this.addError(error, "\n\tFound: " + this.resultList.get(i) + "\n");
            break;
        }
        return error;
    }

    private String checkHashMap(QueryResult other) {
        HashMap<String, Integer> otherMap = other.resultHash;
        String error = null;
        int missing = 0;
        int tooMany = 0;
        Set<Map.Entry<String, Integer>> keys = otherMap.entrySet();
        Iterator<Map.Entry<String, Integer>> it = keys.iterator();
        while (it.hasNext()) {
            String key = it.next().getKey();
            Integer countO = otherMap.get(key);
            if (this.resultHash.containsKey(key)) {
                int count = this.resultHash.get(key);
                if (count < countO) {
                    missing += countO - count;
                } else if (count > countO) {
                    tooMany += count - countO;
                }
                this.resultHash.remove(key);
            } else {
                missing += countO.intValue();
            }
            tooMany += this.nrResults - tooMany - other.nrResults + missing;
        }
        if (missing > 0) {
            error = this.addError(error, missing + " results are missing. ");
        }
        if (tooMany > 0) {
            error = this.addError(error, tooMany + " results are incorrect.\n");
        }
        return error;
    }

    private String addError(String errorString, String error) {
        errorString = errorString == null ? error : errorString + error;
        return errorString;
    }

    public ArrayList<String> getHeadList() {
        return this.headList;
    }

    public boolean isSorted() {
        return this.sorted;
    }
}

