/*
 * Decompiled with CFR 0.152.
 */
package benchmark.serializer;

import benchmark.generator.DateGenerator;
import benchmark.generator.Generator;
import benchmark.model.BSBMResource;
import benchmark.model.Offer;
import benchmark.model.Person;
import benchmark.model.Producer;
import benchmark.model.Product;
import benchmark.model.ProductFeature;
import benchmark.model.ProductType;
import benchmark.model.Review;
import benchmark.model.Vendor;
import benchmark.serializer.ObjectBundle;
import benchmark.serializer.Serializer;
import benchmark.vocabulary.ISO3166;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Iterator;

public class MonetDBSerializer
implements Serializer {
    private File outputDir;
    private boolean forwardChaining;
    private long nrTriples;
    private SQLTables tables;
    private String database;
    private static final int insertNumber = 200;

    public MonetDBSerializer(String directory, boolean forwardChaining, String database) {
        this.outputDir = new File(directory);
        this.outputDir.mkdirs();
        this.forwardChaining = forwardChaining;
        this.nrTriples = 0L;
        this.database = database;
        this.initTables();
    }

    @Override
    public void gatherData(ObjectBundle bundle) {
        Iterator<BSBMResource> it = bundle.iterator();
        try {
            while (it.hasNext()) {
                BSBMResource obj = it.next();
                if (obj instanceof ProductType) {
                    this.convertProductType((ProductType)obj);
                    continue;
                }
                if (obj instanceof Offer) {
                    this.convertOffer((Offer)obj);
                    continue;
                }
                if (obj instanceof Product) {
                    this.convertProduct((Product)obj);
                    continue;
                }
                if (obj instanceof Person) {
                    this.convertPerson((Person)obj);
                    continue;
                }
                if (obj instanceof Producer) {
                    this.convertProducer((Producer)obj);
                    continue;
                }
                if (obj instanceof ProductFeature) {
                    this.convertProductFeature((ProductFeature)obj);
                    continue;
                }
                if (obj instanceof Vendor) {
                    this.convertVendor((Vendor)obj);
                    continue;
                }
                if (!(obj instanceof Review)) continue;
                this.convertReview((Review)obj);
            }
        }
        catch (IOException e) {
            System.err.println("Could not write into File!");
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    private void convertProductType(ProductType pType) throws IOException {
        StringBuffer values = this.getBuffer(this.tables.productTypeInsertCounter++, "producttype");
        values.append("(");
        values.append(pType.getNr());
        values.append(",");
        values.append("'");
        values.append(pType.getLabel());
        values.append("',");
        values.append("'");
        values.append(pType.getComment());
        values.append("',");
        if (pType.getParent() != null) {
            values.append(pType.getParent().getNr());
            values.append(",");
        } else {
            values.append("null,");
        }
        values.append(pType.getPublisher());
        values.append(",");
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(pType.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        values.append("'");
        values.append(dateString);
        values.append("')");
        if (this.tables.productTypeInsertCounter >= 200) {
            this.tables.productTypeInsertCounter = 0;
            values.append(";\n");
        }
        this.tables.productTypeDump.append(values);
    }

    private void convertOffer(Offer offer) throws IOException {
        StringBuffer values = this.getBuffer(this.tables.offerInsertCounter++, "offer");
        values.append("(");
        values.append(offer.getNr());
        values.append(",");
        values.append(offer.getProduct());
        values.append(",");
        values.append(Generator.getProducerOfProduct(offer.getProduct()));
        values.append(",");
        values.append(offer.getVendor());
        values.append(",");
        values.append(offer.getPriceString());
        values.append(",");
        GregorianCalendar validFrom = new GregorianCalendar();
        validFrom.setTimeInMillis(offer.getValidFrom());
        String validFromString = DateGenerator.formatDate(validFrom);
        values.append("'" + validFromString + "',");
        GregorianCalendar validTo = new GregorianCalendar();
        validTo.setTimeInMillis(offer.getValidTo());
        String validToString = DateGenerator.formatDate(validTo);
        values.append("'" + validToString + "',");
        values.append(offer.getDeliveryDays());
        values.append(",");
        values.append("'" + offer.getOfferWebpage() + "',");
        values.append(offer.getPublisher());
        values.append(",");
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(offer.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        values.append("'");
        values.append(dateString);
        values.append("')");
        if (this.tables.offerInsertCounter >= 200) {
            this.tables.offerInsertCounter = 0;
            values.append(";\n");
        }
        this.tables.offerDump.append(values);
    }

    private void convertProduct(Product product) throws IOException {
        Object value;
        StringBuffer values = this.getBuffer(this.tables.productInsertCounter++, "product");
        values.append("(");
        values.append(product.getNr());
        values.append(",");
        values.append("'");
        values.append(product.getLabel());
        values.append("',");
        values.append("'");
        values.append(product.getComment());
        values.append("',");
        values.append(product.getProducer());
        values.append(",");
        if (this.forwardChaining) {
            for (ProductType pt = product.getProductType(); pt != null; pt = pt.getParent()) {
                StringBuffer valuesPTP = this.getBuffer(this.tables.productTypeProductInsertCounter++, "producttypeproduct");
                valuesPTP.append("(" + product.getNr() + ",");
                valuesPTP.append(Integer.valueOf(pt.getNr()).toString());
                valuesPTP.append(")");
                if (this.tables.productTypeProductInsertCounter >= 200) {
                    this.tables.productTypeProductInsertCounter = 0;
                    valuesPTP.append(";\n");
                }
                this.tables.productTypeProductDump.append(valuesPTP);
            }
        } else {
            StringBuffer valuesPTP = this.getBuffer(this.tables.productTypeProductInsertCounter++, "producttypeproduct");
            valuesPTP.append("(" + product.getNr() + ",");
            valuesPTP.append(Integer.valueOf(product.getProductType().getNr()).toString());
            valuesPTP.append(")");
            if (this.tables.productTypeProductInsertCounter >= 200) {
                this.tables.productTypeProductInsertCounter = 0;
                valuesPTP.append(";\n");
            }
            this.tables.productTypeProductDump.append(valuesPTP);
        }
        Integer[] ppn = product.getProductPropertyNumeric();
        Integer i = 0;
        Integer j = 1;
        while (i < ppn.length) {
            Integer value2 = ppn[i];
            if (value2 != null) {
                values.append(value2.toString() + ",");
            } else {
                values.append("null,");
            }
            value2 = i;
            Integer n = i = Integer.valueOf(i + 1);
            value2 = j;
            n = j = Integer.valueOf(j + 1);
        }
        String[] ppt = product.getProductPropertyTextual();
        Integer i2 = 0;
        Integer j2 = 1;
        while (i2 < ppt.length) {
            value = ppt[i2];
            if (value != null) {
                values.append("'" + (String)value + "',");
            } else {
                values.append("null,");
            }
            value = i2;
            Integer n = i2 = Integer.valueOf(i2 + 1);
            value = j2;
            n = j2 = Integer.valueOf(j2 + 1);
        }
        Iterator<Integer> pf = product.getFeatures().iterator();
        while (pf.hasNext()) {
            StringBuffer valuesPFP = this.getBuffer(this.tables.productFeatureProductInsertCounter++, "productfeatureproduct");
            valuesPFP.append("(");
            value = pf.next();
            valuesPFP.append(product.getNr());
            valuesPFP.append("," + value);
            valuesPFP.append(")");
            if (this.tables.productFeatureProductInsertCounter >= 200) {
                this.tables.productFeatureProductInsertCounter = 0;
                valuesPFP.append(";\n");
            }
            this.tables.productFeatureProductDump.append(valuesPFP);
        }
        values.append(Integer.valueOf(product.getProducer()).toString());
        values.append(",");
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(product.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        values.append("'" + dateString + "')");
        if (this.tables.productInsertCounter >= 200) {
            this.tables.productInsertCounter = 0;
            values.append(";\n");
        }
        this.tables.productDump.append(values);
    }

    private void convertPerson(Person person) throws IOException {
        StringBuffer values = this.getBuffer(this.tables.personInsertCounter++, "person");
        values.append("(");
        values.append(person.getNr());
        values.append(",");
        values.append("'");
        values.append(person.getName());
        values.append("',");
        values.append("'");
        values.append(person.getMbox_sha1sum());
        values.append("',");
        values.append("'");
        values.append(person.getCountryCode());
        values.append("',");
        values.append(person.getPublisher());
        values.append(",");
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(person.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        values.append("'" + dateString + "')");
        if (this.tables.personInsertCounter >= 200) {
            this.tables.personInsertCounter = 0;
            values.append(";\n");
        }
        this.tables.personDump.append(values);
    }

    private void convertProducer(Producer producer) throws IOException {
        StringBuffer values = this.getBuffer(this.tables.producerInsertCounter++, "producer");
        values.append("(");
        values.append(producer.getNr());
        values.append(",");
        values.append("'");
        values.append(producer.getLabel());
        values.append("',");
        values.append("'");
        values.append(producer.getComment());
        values.append("',");
        values.append("'");
        values.append(producer.getHomepage());
        values.append("',");
        values.append("'");
        values.append(producer.getCountryCode());
        values.append("',");
        values.append(producer.getPublisher());
        values.append(",");
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(producer.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        values.append("'" + dateString + "')");
        if (this.tables.producerInsertCounter >= 200) {
            this.tables.producerInsertCounter = 0;
            values.append(";\n");
        }
        this.tables.producerDump.append(values);
    }

    private void convertProductFeature(ProductFeature pf) throws IOException {
        StringBuffer values = this.getBuffer(this.tables.productFeatureInsertCounter++, "productfeature");
        values.append("(");
        values.append(pf.getNr());
        values.append(",");
        values.append("'");
        values.append(pf.getLabel());
        values.append("',");
        values.append("'");
        values.append(pf.getComment());
        values.append("',");
        values.append(pf.getPublisher());
        values.append(",");
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(pf.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        values.append("'");
        values.append(dateString);
        values.append("')");
        if (this.tables.productFeatureInsertCounter >= 200) {
            this.tables.productFeatureInsertCounter = 0;
            values.append(";\n");
        }
        this.tables.productFeatureDump.append(values);
    }

    private void convertVendor(Vendor vendor) throws IOException {
        StringBuffer values = this.getBuffer(this.tables.vendorInsertCounter++, "vendor");
        values.append("(");
        values.append(vendor.getNr());
        values.append(",");
        values.append("'");
        values.append(vendor.getLabel());
        values.append("',");
        values.append("'");
        values.append(vendor.getComment());
        values.append("',");
        values.append("'");
        values.append(vendor.getHomepage());
        values.append("',");
        values.append("'");
        values.append(vendor.getCountryCode());
        values.append("',");
        values.append(vendor.getPublisher());
        values.append(",");
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(vendor.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        values.append("'" + dateString + "')");
        if (this.tables.vendorInsertCounter >= 200) {
            this.tables.vendorInsertCounter = 0;
            values.append(";\n");
        }
        this.tables.vendorDump.append(values);
    }

    private void convertReview(Review review) throws IOException {
        StringBuffer values = this.getBuffer(this.tables.reviewInsertCounter++, "review");
        values.append("(");
        values.append(review.getNr());
        values.append(",");
        values.append(review.getProduct());
        values.append(",");
        values.append(review.getProducerOfProduct());
        values.append(",");
        values.append(review.getPerson());
        values.append(",");
        GregorianCalendar reviewDate = new GregorianCalendar();
        reviewDate.setTimeInMillis(review.getReviewDate());
        String reviewDateString = DateGenerator.formatDate(reviewDate);
        values.append("'" + reviewDateString + "',");
        values.append("'");
        values.append(review.getTitle());
        values.append("',");
        values.append("'");
        values.append(review.getText());
        values.append("',");
        values.append("'");
        values.append(ISO3166.language[review.getLanguage()]);
        values.append("',");
        Integer[] ratings = review.getRatings();
        for (int i = 0; i < ratings.length; ++i) {
            Integer value = ratings[i];
            values.append(value);
            values.append(",");
        }
        values.append(review.getPublisher());
        values.append(",");
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(review.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        values.append("'" + dateString + "')");
        if (this.tables.reviewInsertCounter >= 200) {
            this.tables.reviewInsertCounter = 0;
            values.append(";\n");
        }
        this.tables.reviewDump.append(values);
    }

    @Override
    public void serialize() {
        try {
            this.tables.productTypeDump.append(this.tables.endTable(this.tables.productTypeInsertCounter, "producttype"));
            this.tables.productTypeDump.flush();
            this.tables.productTypeDump.close();
            this.tables.productFeatureDump.append(this.tables.endTable(this.tables.productFeatureInsertCounter, "productfeature"));
            this.tables.productFeatureDump.flush();
            this.tables.productFeatureDump.close();
            this.tables.producerDump.append(this.tables.endTable(this.tables.producerInsertCounter, "producer"));
            this.tables.producerDump.flush();
            this.tables.producerDump.close();
            this.tables.productDump.append(this.tables.endTable(this.tables.productInsertCounter, "product"));
            this.tables.productDump.flush();
            this.tables.productDump.close();
            this.tables.productTypeProductDump.append(this.tables.endTable(this.tables.productTypeProductInsertCounter, "producttypeproduct"));
            this.tables.productTypeProductDump.flush();
            this.tables.productTypeProductDump.close();
            this.tables.productFeatureProductDump.append(this.tables.endTable(this.tables.productFeatureProductInsertCounter, "productfeatureproduct"));
            this.tables.productFeatureProductDump.flush();
            this.tables.productFeatureProductDump.close();
            this.tables.vendorDump.append(this.tables.endTable(this.tables.vendorInsertCounter, "vendor"));
            this.tables.vendorDump.flush();
            this.tables.vendorDump.close();
            this.tables.offerDump.append(this.tables.endTable(this.tables.offerInsertCounter, "offer"));
            this.tables.offerDump.flush();
            this.tables.offerDump.close();
            this.tables.personDump.append(this.tables.endTable(this.tables.personInsertCounter, "person"));
            this.tables.personDump.flush();
            this.tables.personDump.close();
            this.tables.reviewDump.append(this.tables.endTable(this.tables.reviewInsertCounter, "review"));
            this.tables.reviewDump.flush();
            this.tables.reviewDump.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    @Override
    public Long triplesGenerated() {
        return this.nrTriples;
    }

    private void initTables() {
        this.tables = new SQLTables();
        this.tables.offerInsertCounter = 0;
        this.tables.vendorInsertCounter = 0;
        this.tables.productFeatureInsertCounter = 0;
        this.tables.productInsertCounter = 0;
        this.tables.producerInsertCounter = 0;
        this.tables.productTypeProductInsertCounter = 0;
        this.tables.personInsertCounter = 0;
        this.tables.productTypeInsertCounter = 0;
        this.tables.reviewInsertCounter = 0;
        this.tables.productFeatureProductInsertCounter = 0;
        try {
            this.tables.offerDump = new FileWriter(new File(this.outputDir, "08Offer.sql"));
            this.tables.vendorDump = new FileWriter(new File(this.outputDir, "07Vendor.sql"));
            this.tables.productFeatureDump = new FileWriter(new File(this.outputDir, "01ProductFeature.sql"));
            this.tables.productDump = new FileWriter(new File(this.outputDir, "04Product.sql"));
            this.tables.producerDump = new FileWriter(new File(this.outputDir, "03Producer.sql"));
            this.tables.productTypeProductDump = new FileWriter(new File(this.outputDir, "05ProductTypeProduct.sql"));
            this.tables.personDump = new FileWriter(new File(this.outputDir, "09Person.sql"));
            this.tables.productTypeDump = new FileWriter(new File(this.outputDir, "02ProductType.sql"));
            this.tables.reviewDump = new FileWriter(new File(this.outputDir, "10Review.sql"));
            this.tables.productFeatureProductDump = new FileWriter(new File(this.outputDir, "06ProductFeatureProduct.sql"));
            this.tables.productTypeDump.append(this.tables.initProductType());
            this.tables.productFeatureDump.append(this.tables.initProductFeature());
            this.tables.producerDump.append(this.tables.initProducer());
            this.tables.productDump.append(this.tables.initProduct());
            this.tables.productTypeProductDump.append(this.tables.initProductTypeProduct());
            this.tables.productFeatureProductDump.append(this.tables.initProductFeatureProduct());
            this.tables.vendorDump.append(this.tables.initVendor());
            this.tables.offerDump.append(this.tables.initOffer());
            this.tables.personDump.append(this.tables.initPerson());
            this.tables.reviewDump.append(this.tables.initReview());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private StringBuffer getBuffer(int counter, String tableName) {
        StringBuffer sb = new StringBuffer();
        if (counter == 0) {
            sb.append("INSERT INTO \"" + tableName + "\" VALUES ");
        } else {
            sb.append(",");
        }
        return sb;
    }

    private class SQLTables {
        FileWriter offerDump;
        FileWriter vendorDump;
        FileWriter productFeatureDump;
        FileWriter productDump;
        FileWriter producerDump;
        FileWriter productTypeProductDump;
        FileWriter personDump;
        FileWriter productTypeDump;
        FileWriter reviewDump;
        FileWriter productFeatureProductDump;
        int offerInsertCounter;
        int vendorInsertCounter;
        int productFeatureInsertCounter;
        int productInsertCounter;
        int producerInsertCounter;
        int productTypeProductInsertCounter;
        int personInsertCounter;
        int productTypeInsertCounter;
        int reviewInsertCounter;
        int productFeatureProductInsertCounter;

        SQLTables() {
        }

        public String createTable(String database, String tableName, String tableDefinition) {
            StringBuffer sb = new StringBuffer(100);
            sb.append("CREATE TABLE \"" + tableName + "\" (\n");
            sb.append(tableDefinition);
            sb.append(");\n\n");
            return sb.toString();
        }

        private String endTable(int counter, String tableName) {
            String s = "";
            if (counter > 0) {
                s = ";";
            }
            return s;
        }

        private String initProductType() {
            String tableDefinition = "  \"nr\" int primary key,\n  \"label\" varchar(100) default NULL,\n  \"comment\" varchar(2000) default NULL,\n  \"parent\" int,\n  \"publisher\" int,\n  \"publishDate\" date\n";
            return this.createTable(MonetDBSerializer.this.database, "producttype", tableDefinition);
        }

        private String initProductFeature() {
            String tableDefinition = "  \"nr\" int primary key,\n  \"label\" varchar(100) default NULL,\n  \"comment\" varchar(2000) default NULL,\n  \"publisher\" int,\n  \"publishDate\" date\n";
            return this.createTable(MonetDBSerializer.this.database, "productfeature", tableDefinition);
        }

        private String initProducer() {
            String tableDefinition = "  \"nr\" int primary key,\n  \"label\" varchar(100) default NULL,\n  \"comment\" varchar(2000) default NULL,\n  \"homepage\" varchar(100) default NULL,\n  \"country\" char(2) ,\n  \"publisher\" int,\n  \"publishDate\" date\n";
            return this.createTable(MonetDBSerializer.this.database, "producer", tableDefinition);
        }

        private String initProduct() {
            String tableDefinition = "  \"nr\" int primary key,\n  \"label\" varchar(100) default NULL,\n  \"comment\" varchar(2000) default NULL,\n  \"producer\" int default NULL,\n  \"propertyNum1\" int default NULL,\n  \"propertyNum2\" int default NULL,\n  \"propertyNum3\" int default NULL,\n  \"propertyNum4\" int default NULL,\n  \"propertyNum5\" int default NULL,\n  \"propertyNum6\" int default NULL,\n  \"propertyTex1\" varchar(250) default NULL,\n  \"propertyTex2\" varchar(250) default NULL,\n  \"propertyTex3\" varchar(250) default NULL,\n  \"propertyTex4\" varchar(250) default NULL,\n  \"propertyTex5\" varchar(250) default NULL,\n  \"propertyTex6\" varchar(250) default NULL,\n  \"publisher\" int default NULL,\n  \"publishDate\" date default NULL\n";
            return this.createTable(MonetDBSerializer.this.database, "product", tableDefinition);
        }

        private String initProductTypeProduct() {
            String tableDefinition = "  \"product\" int not null,\n  \"productType\" int not null,\n  PRIMARY KEY (\"product\", \"productType\")\n";
            return this.createTable(MonetDBSerializer.this.database, "producttypeproduct", tableDefinition);
        }

        private String initProductFeatureProduct() {
            String tableDefinition = "  \"product\" int not null,\n  \"productFeature\" int not null,\n  PRIMARY KEY (\"product\", \"productFeature\")\n";
            return this.createTable(MonetDBSerializer.this.database, "productfeatureproduct", tableDefinition);
        }

        private String initVendor() {
            String tableDefinition = "  \"nr\" int primary key,\n  \"label\" varchar(100) default NULL,\n  \"comment\" varchar(2000) default NULL,\n  \"homepage\" varchar(100) default NULL,\n  \"country\" char(2) ,\n  \"publisher\" int,\n  \"publishDate\" date\n";
            return this.createTable(MonetDBSerializer.this.database, "vendor", tableDefinition);
        }

        private String initOffer() {
            String tableDefinition = "  \"nr\" int primary key,\n  \"product\" int,\n  \"producer\" int,\n  \"vendor\" int,\n  \"price\" double default null,\n  \"validFrom\" date default null,\n  \"validTo\" date default null,\n  \"deliveryDays\" int default null,\n  \"offerWebpage\" varchar(100) ,\n  \"publisher\" int,\n  \"publishDate\" date\n";
            return this.createTable(MonetDBSerializer.this.database, "offer", tableDefinition);
        }

        private String initPerson() {
            String tableDefinition = "  \"nr\" int primary key,\n  \"name\" varchar(30) default NULL,\n  \"mbox_sha1sum\" char(40) ,\n  \"country\" char(2) ,\n  \"publisher\" int,\n  \"publishDate\" date\n";
            return this.createTable(MonetDBSerializer.this.database, "person", tableDefinition);
        }

        private String initReview() {
            String tableDefinition = "  \"nr\" int primary key,\n  \"product\" int,\n  \"producer\" int,\n  \"person\" int,\n  \"reviewDate\" date default NULL,\n  \"title\" varchar(200) default NULL,\n  \"text\" text ,\n  \"language\" char(2) ,\n  \"rating1\" int default NULL,\n  \"rating2\" int default NULL,\n  \"rating3\" int default NULL,\n  \"rating4\" int default NULL,\n  \"publisher\" int,\n  \"publishDate\" date\n";
            return this.createTable(MonetDBSerializer.this.database, "review", tableDefinition);
        }
    }
}

