/*
 * Decompiled with CFR 0.152.
 */
package benchmark.serializer;

import benchmark.generator.DateGenerator;
import benchmark.generator.Generator;
import benchmark.model.BSBMResource;
import benchmark.model.Offer;
import benchmark.model.Person;
import benchmark.model.Producer;
import benchmark.model.Product;
import benchmark.model.ProductFeature;
import benchmark.model.ProductType;
import benchmark.model.RatingSite;
import benchmark.model.Review;
import benchmark.model.Vendor;
import benchmark.serializer.ObjectBundle;
import benchmark.serializer.Serializer;
import benchmark.vocabulary.BSBM;
import benchmark.vocabulary.ISO3166;
import java.io.FileWriter;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Iterator;

public class NTriples
implements Serializer {
    private FileWriter[] fileWriter;
    private boolean forwardChaining;
    private long nrTriples;
    private int currentWriter = 0;

    public NTriples(String file, boolean forwardChaining) {
        this(file, forwardChaining, 1);
    }

    public NTriples(String file, boolean forwardChaining, int nrOfOutputFiles) {
        int nrOfDigits = (int)Math.log10(nrOfOutputFiles) + 1;
        String formatString = "%0" + nrOfDigits + "d";
        try {
            this.fileWriter = new FileWriter[nrOfOutputFiles];
            if (nrOfOutputFiles == 1) {
                this.fileWriter[0] = new FileWriter(file + ".nt");
            } else {
                for (int i = 1; i <= nrOfOutputFiles; ++i) {
                    this.fileWriter[i - 1] = new FileWriter(file + String.format(formatString, i) + ".nt");
                }
            }
        }
        catch (IOException e) {
            System.err.println("Could not open File");
            System.exit(-1);
        }
        this.forwardChaining = forwardChaining;
        this.nrTriples = 0L;
    }

    @Override
    public void gatherData(ObjectBundle bundle) {
        Iterator<BSBMResource> it = bundle.iterator();
        while (it.hasNext()) {
            BSBMResource obj = it.next();
            try {
                if (obj instanceof ProductType) {
                    this.fileWriter[this.currentWriter].append(this.convertProductType((ProductType)obj));
                } else if (obj instanceof Offer) {
                    this.fileWriter[this.currentWriter].append(this.convertOffer((Offer)obj));
                } else if (obj instanceof Product) {
                    this.fileWriter[this.currentWriter].append(this.convertProduct((Product)obj));
                } else if (obj instanceof Person) {
                    this.fileWriter[this.currentWriter].append(this.convertPerson((Person)obj));
                } else if (obj instanceof Producer) {
                    this.fileWriter[this.currentWriter].append(this.convertProducer((Producer)obj));
                } else if (obj instanceof ProductFeature) {
                    this.fileWriter[this.currentWriter].append(this.convertProductFeature((ProductFeature)obj));
                } else if (obj instanceof Vendor) {
                    this.fileWriter[this.currentWriter].append(this.convertVendor((Vendor)obj));
                } else if (obj instanceof Review) {
                    this.fileWriter[this.currentWriter].append(this.convertReview((Review)obj));
                }
            }
            catch (IOException e) {
                System.err.println("Could not write into File!");
                System.err.println(e.getMessage());
                System.exit(-1);
            }
            this.currentWriter = (this.currentWriter + 1) % this.fileWriter.length;
        }
    }

    private String convertProductType(ProductType pType) {
        StringBuffer result = new StringBuffer();
        String subjectURIREF = pType.toString();
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), this.createURIref(BSBM.ProductType)));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/2000/01/rdf-schema#label"), this.createLiteral(pType.getLabel())));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/2000/01/rdf-schema#comment"), this.createLiteral(pType.getComment())));
        if (pType.getParent() != null) {
            String parentURIREF = this.createURIref(BSBM.INST_NS, "ProductType" + pType.getParent().getNr());
            result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/2000/01/rdf-schema#subClassOf"), parentURIREF));
        }
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/publisher"), this.createURIref(BSBM.getStandardizationInstitution(1))));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(pType.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/date"), this.createDataTypeLiteral(dateString, this.createURIref("http://www.w3.org/2001/XMLSchema#date"))));
        return result.toString();
    }

    private String convertOffer(Offer offer) {
        StringBuffer result = new StringBuffer();
        String subjectURIREF = offer.toString();
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), this.createURIref(BSBM.Offer)));
        int productNr = offer.getProduct();
        int producerNr = Generator.getProducerOfProduct(productNr);
        result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.product), Product.getURIref(productNr, producerNr)));
        result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.vendor), Vendor.getURIref(offer.getVendor())));
        result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.price), this.createDataTypeLiteral(offer.getPriceString(), this.createURIref(BSBM.USD))));
        GregorianCalendar validFrom = new GregorianCalendar();
        validFrom.setTimeInMillis(offer.getValidFrom());
        String validFromString = DateGenerator.formatDateTime(validFrom);
        result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.validFrom), this.createDataTypeLiteral(validFromString, this.createURIref("http://www.w3.org/2001/XMLSchema#dateTime"))));
        GregorianCalendar validTo = new GregorianCalendar();
        validTo.setTimeInMillis(offer.getValidTo());
        String validToString = DateGenerator.formatDateTime(validTo);
        result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.validTo), this.createDataTypeLiteral(validToString, this.createURIref("http://www.w3.org/2001/XMLSchema#dateTime"))));
        result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.deliveryDays), this.createDataTypeLiteral(offer.getDeliveryDays().toString(), this.createURIref("http://www.w3.org/2001/XMLSchema#integer"))));
        result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.offerWebpage), this.createURIref(offer.getOfferWebpage())));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/publisher"), Vendor.getURIref(offer.getVendor())));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(offer.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/date"), this.createDataTypeLiteral(dateString, this.createURIref("http://www.w3.org/2001/XMLSchema#date"))));
        return result.toString();
    }

    private String convertProduct(Product product) {
        StringBuffer result = new StringBuffer();
        String subjectURIREF = product.toString();
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), this.createURIref(BSBM.Product)));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/2000/01/rdf-schema#label"), this.createLiteral(product.getLabel())));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/2000/01/rdf-schema#comment"), this.createLiteral(product.getComment())));
        if (this.forwardChaining) {
            for (ProductType pt = product.getProductType(); pt != null; pt = pt.getParent()) {
                result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), pt.toString()));
            }
        } else {
            result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), product.getProductType().toString()));
        }
        result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.producer), Producer.getURIref(product.getProducer())));
        Integer[] ppn = product.getProductPropertyNumeric();
        int i = 0;
        int j = 1;
        while (i < ppn.length) {
            Integer value = ppn[i];
            if (value != null) {
                result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.getProductPropertyNumeric(j)), this.createDataTypeLiteral(value.toString(), this.createURIref("http://www.w3.org/2001/XMLSchema#integer"))));
            }
            ++i;
            ++j;
        }
        String[] ppt = product.getProductPropertyTextual();
        int i2 = 0;
        int j2 = 1;
        while (i2 < ppt.length) {
            String value = ppt[i2];
            if (value != null) {
                result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.getProductPropertyTextual(j2)), this.createDataTypeLiteral(value, this.createURIref("http://www.w3.org/2001/XMLSchema#string"))));
            }
            ++i2;
            ++j2;
        }
        for (Integer value : product.getFeatures()) {
            result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.productFeature), ProductFeature.getURIref(value)));
        }
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/publisher"), Producer.getURIref(product.getProducer())));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(product.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/date"), this.createDataTypeLiteral(dateString, this.createURIref("http://www.w3.org/2001/XMLSchema#date"))));
        return result.toString();
    }

    private String convertPerson(Person person) {
        StringBuffer result = new StringBuffer();
        String subjectURIREF = person.toString();
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), this.createURIref("http://xmlns.com/foaf/0.1/Person")));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://xmlns.com/foaf/0.1/name"), this.createLiteral(person.getName())));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://xmlns.com/foaf/0.1/mbox_sha1sum"), this.createLiteral(person.getMbox_sha1sum())));
        result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.country), this.createURIref(ISO3166.find(person.getCountryCode()))));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/publisher"), RatingSite.getURIref(person.getPublisher())));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(person.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/date"), this.createDataTypeLiteral(dateString, this.createURIref("http://www.w3.org/2001/XMLSchema#date"))));
        return result.toString();
    }

    private String convertProducer(Producer producer) {
        StringBuffer result = new StringBuffer();
        String subjectURIREF = producer.toString();
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), this.createURIref(BSBM.Producer)));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/2000/01/rdf-schema#label"), this.createLiteral(producer.getLabel())));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/2000/01/rdf-schema#comment"), this.createLiteral(producer.getComment())));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://xmlns.com/foaf/0.1/homepage"), this.createURIref(producer.getHomepage())));
        result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.country), this.createURIref(ISO3166.find(producer.getCountryCode()))));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/publisher"), producer.toString()));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(producer.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/date"), this.createDataTypeLiteral(dateString, this.createURIref("http://www.w3.org/2001/XMLSchema#date"))));
        return result.toString();
    }

    private String convertProductFeature(ProductFeature pf) {
        StringBuffer result = new StringBuffer();
        String subjectURIREF = this.createURIref(BSBM.INST_NS, "ProductFeature" + pf.getNr());
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), this.createURIref(BSBM.ProductFeature)));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/2000/01/rdf-schema#label"), this.createLiteral(pf.getLabel())));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/2000/01/rdf-schema#comment"), this.createLiteral(pf.getComment())));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/publisher"), this.createURIref(BSBM.getStandardizationInstitution(pf.getPublisher()))));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(pf.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/date"), this.createDataTypeLiteral(dateString, this.createURIref("http://www.w3.org/2001/XMLSchema#date"))));
        return result.toString();
    }

    private String convertVendor(Vendor vendor) {
        StringBuffer result = new StringBuffer();
        String subjectURIREF = vendor.toString();
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), this.createURIref(BSBM.Vendor)));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/2000/01/rdf-schema#label"), this.createLiteral(vendor.getLabel())));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/2000/01/rdf-schema#comment"), this.createLiteral(vendor.getComment())));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://xmlns.com/foaf/0.1/homepage"), this.createURIref(vendor.getHomepage())));
        result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.country), this.createURIref(ISO3166.find(vendor.getCountryCode()))));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/publisher"), vendor.toString()));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(vendor.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/date"), this.createDataTypeLiteral(dateString, this.createURIref("http://www.w3.org/2001/XMLSchema#date"))));
        return result.toString();
    }

    private String convertReview(Review review) {
        StringBuffer result = new StringBuffer();
        String subjectURIREF = review.toString();
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), this.createURIref("http://purl.org/stuff/rev#Review")));
        result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.reviewFor), Product.getURIref(review.getProduct(), review.getProducerOfProduct())));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/stuff/rev#reviewer"), Person.getURIref(review.getPerson(), review.getPublisher())));
        GregorianCalendar reviewDate = new GregorianCalendar();
        reviewDate.setTimeInMillis(review.getReviewDate());
        String reviewDateString = DateGenerator.formatDateTime(reviewDate);
        result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.reviewDate), this.createDataTypeLiteral(reviewDateString, this.createURIref("http://www.w3.org/2001/XMLSchema#dateTime"))));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/title"), this.createLiteral(review.getTitle())));
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/stuff/rev#text"), this.createLanguageLiteral(review.getText(), ISO3166.language[review.getLanguage()])));
        Integer[] ratings = review.getRatings();
        int i = 0;
        int j = 1;
        while (i < ratings.length) {
            Integer value = ratings[i];
            if (value != null) {
                result.append(this.createTriple(subjectURIREF, this.createURIref(BSBM.getRating(j)), this.createDataTypeLiteral(value.toString(), this.createURIref("http://www.w3.org/2001/XMLSchema#integer"))));
            }
            ++i;
            ++j;
        }
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/publisher"), RatingSite.getURIref(review.getPublisher())));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(review.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.createTriple(subjectURIREF, this.createURIref("http://purl.org/dc/elements/1.1/date"), this.createDataTypeLiteral(dateString, this.createURIref("http://www.w3.org/2001/XMLSchema#date"))));
        return result.toString();
    }

    private String createLiteral(String value) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(value);
        result.append("\"");
        return result.toString();
    }

    private String createDataTypeLiteral(String value, String datatypeURI) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(value);
        result.append("\"^^");
        result.append(datatypeURI);
        return result.toString();
    }

    private String createLanguageLiteral(String text, String languageCode) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(text);
        result.append("\"@");
        result.append(languageCode);
        return result.toString();
    }

    private String createTriple(String subject, String predicate, String object) {
        StringBuffer result = new StringBuffer();
        result.append(subject);
        result.append(" ");
        result.append(predicate);
        result.append(" ");
        result.append(object);
        result.append(" .\n");
        ++this.nrTriples;
        return result.toString();
    }

    private String createURIref(String namespace, String element) {
        StringBuffer result = new StringBuffer();
        result.append("<");
        result.append(namespace);
        result.append(element);
        result.append(">");
        return result.toString();
    }

    private String createURIref(String uri) {
        StringBuffer result = new StringBuffer();
        result.append("<");
        result.append(uri);
        result.append(">");
        return result.toString();
    }

    @Override
    public void serialize() {
        try {
            for (int i = 0; i < this.fileWriter.length; ++i) {
                this.fileWriter[i].flush();
                this.fileWriter[i].close();
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    public void writeString(String s) {
        try {
            this.fileWriter[this.currentWriter].append(s);
        }
        catch (IOException e) {
            System.err.println("Could not write output.\n" + e.getMessage());
            System.exit(-1);
        }
    }

    @Override
    public Long triplesGenerated() {
        return this.nrTriples;
    }
}

