/*
 * Decompiled with CFR 0.152.
 */
package benchmark.serializer;

import benchmark.model.BSBMResource;
import benchmark.serializer.NTriples;
import benchmark.serializer.Serializer;
import java.util.Iterator;
import java.util.Vector;

public class ObjectBundle {
    private String graphName;
    private int publisherNum;
    private String publisher;
    private long publishDate;
    private Vector<BSBMResource> objects;
    private Serializer serializer;
    private int maxSize;
    private int size;
    private boolean finish;

    public boolean isFinish() {
        return this.finish;
    }

    public void setFinish(boolean finish) {
        this.finish = finish;
    }

    public ObjectBundle(Serializer serializer) {
        this.objects = new Vector();
        this.maxSize = 0;
        this.size = 0;
        this.serializer = serializer;
        this.finish = false;
    }

    public ObjectBundle(Serializer serializer, int maxsize) {
        this.objects = new Vector(maxsize);
        this.maxSize = maxsize;
        this.size = 0;
        this.serializer = serializer;
        this.finish = false;
    }

    public void add(BSBMResource res) {
        this.objects.add(res);
        if (this.maxSize > 0) {
            ++this.size;
            if (this.size == this.maxSize) {
                this.commitToSerializer();
            }
        }
    }

    public int size() {
        return this.objects.size();
    }

    public String getGraphName() {
        return this.graphName;
    }

    public boolean commitToSerializer() {
        if (this.serializer != null) {
            this.serializer.gatherData(this);
            this.size = 0;
            this.objects = new Vector(this.maxSize);
            return true;
        }
        return false;
    }

    public void setGraphName(String namedGraph) {
        this.graphName = namedGraph;
    }

    public Iterator<BSBMResource> iterator() {
        return this.objects.iterator();
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public long getPublishDate() {
        return this.publishDate;
    }

    public void setPublishDate(long publishDate) {
        this.publishDate = publishDate;
    }

    public int getPublisherNum() {
        return this.publisherNum;
    }

    public void setPublisherNum(int publisherNum) {
        this.publisherNum = publisherNum;
    }

    public boolean writeStringToSerializer(String s) {
        if (this.serializer instanceof NTriples) {
            ((NTriples)this.serializer).writeString(s);
            return true;
        }
        return false;
    }
}

