/*
 * Decompiled with CFR 0.152.
 */
package benchmark.serializer;

import benchmark.generator.DateGenerator;
import benchmark.generator.Generator;
import benchmark.model.BSBMResource;
import benchmark.model.Offer;
import benchmark.model.Person;
import benchmark.model.Producer;
import benchmark.model.Product;
import benchmark.model.ProductFeature;
import benchmark.model.ProductType;
import benchmark.model.RatingSite;
import benchmark.model.Review;
import benchmark.model.Vendor;
import benchmark.serializer.ObjectBundle;
import benchmark.serializer.Serializer;
import benchmark.vocabulary.BSBM;
import benchmark.vocabulary.DC;
import benchmark.vocabulary.FOAF;
import benchmark.vocabulary.ISO3166;
import benchmark.vocabulary.RDF;
import benchmark.vocabulary.RDFS;
import benchmark.vocabulary.REV;
import benchmark.vocabulary.XSD;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Iterator;

public class TriG
implements Serializer {
    private FileWriter dataFileWriter;
    private FileWriter provenanceGraphWriter;
    private boolean forwardChaining;
    private long nrTriples;
    private File provenanceFile;
    private File dataFile;
    private FileWriter prefixFileWriter;

    public TriG(String file, boolean forwardChaining) {
        try {
            this.provenanceFile = File.createTempFile("BSBM", ".prov");
            this.provenanceFile.deleteOnExit();
            this.provenanceGraphWriter = new FileWriter(this.provenanceFile);
            this.prefixFileWriter = new FileWriter(file);
            this.dataFile = File.createTempFile("BSBM", ".data");
            this.dataFile.deleteOnExit();
            this.dataFileWriter = new FileWriter(this.dataFile);
        }
        catch (IOException e) {
            System.err.println("Could not open File for writing.");
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        try {
            this.prefixFileWriter.append(this.getNamespaces());
            this.provenanceGraphWriter.append("<localhost:provenanceData>\n{\n");
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        this.forwardChaining = forwardChaining;
        this.nrTriples = 0L;
    }

    private String getNamespaces() {
        StringBuffer result = new StringBuffer();
        result.append(this.createPrefixLine("rdf:", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
        result.append(this.createPrefixLine("rdfs:", "http://www.w3.org/2000/01/rdf-schema#"));
        result.append(this.createPrefixLine("foaf:", "http://xmlns.com/foaf/0.1/"));
        result.append(this.createPrefixLine("dc:", "http://purl.org/dc/elements/1.1/"));
        result.append(this.createPrefixLine("xsd:", "http://www.w3.org/2001/XMLSchema#"));
        result.append(this.createPrefixLine("rev:", "http://purl.org/stuff/rev#"));
        result.append(this.createPrefixLine(BSBM.PREFIX, BSBM.NS));
        result.append(this.createPrefixLine(BSBM.INST_PREFIX, BSBM.INST_NS));
        return result.toString();
    }

    private String createPrefixLine(String prefix, String namespace) {
        StringBuffer result = new StringBuffer();
        result.append("@prefix ");
        result.append(prefix);
        result.append(" ");
        result.append(this.createURIref(namespace));
        result.append(" .\n");
        return result.toString();
    }

    @Override
    public void gatherData(ObjectBundle bundle) {
        Iterator<BSBMResource> it = bundle.iterator();
        try {
            String prefix = this.getPrefixDefinition(bundle);
            if (prefix != null) {
                this.prefixFileWriter.append(prefix);
            }
            this.dataFileWriter.append(bundle.getGraphName() + "\n{\n");
            while (it.hasNext()) {
                BSBMResource obj = it.next();
                if (obj instanceof ProductType) {
                    this.dataFileWriter.append(this.convertProductType((ProductType)obj));
                    continue;
                }
                if (obj instanceof Offer) {
                    this.dataFileWriter.append(this.convertOffer((Offer)obj));
                    continue;
                }
                if (obj instanceof Product) {
                    this.dataFileWriter.append(this.convertProduct((Product)obj));
                    continue;
                }
                if (obj instanceof Person) {
                    this.dataFileWriter.append(this.convertPerson((Person)obj, bundle));
                    continue;
                }
                if (obj instanceof Producer) {
                    this.dataFileWriter.append(this.convertProducer((Producer)obj));
                    continue;
                }
                if (obj instanceof ProductFeature) {
                    this.dataFileWriter.append(this.convertProductFeature((ProductFeature)obj));
                    continue;
                }
                if (obj instanceof Vendor) {
                    this.dataFileWriter.append(this.convertVendor((Vendor)obj));
                    continue;
                }
                if (!(obj instanceof Review)) continue;
                this.dataFileWriter.append(this.convertReview((Review)obj, bundle));
            }
            this.dataFileWriter.append("}\n\n");
            this.provenanceGraphWriter.append(this.convertProvenanceData(bundle));
            this.provenanceGraphWriter.append("\n");
        }
        catch (IOException e) {
            System.err.println("Could not write into File!");
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    private String getPrefixDefinition(ObjectBundle bundle) {
        StringBuffer prefix = new StringBuffer();
        String publisher = bundle.getPublisher().toLowerCase();
        Integer publisherNum = bundle.getPublisherNum();
        if (publisher.contains("datafromvendor")) {
            prefix.append(this.createPrefixLine(Vendor.getVendorNSprefixed(publisherNum), Vendor.getVendorNS(publisherNum)));
        } else if (publisher.contains("datafromratingsite")) {
            prefix.append(this.createPrefixLine(RatingSite.getRatingSiteNSprefixed(publisherNum), RatingSite.getRatingSiteNS(publisherNum)));
        } else if (publisher.contains("datafromproducer")) {
            prefix.append(this.createPrefixLine(Producer.getProducerNSprefixed(publisherNum), Producer.getProducerNS(publisherNum)));
        } else {
            return null;
        }
        return prefix.toString();
    }

    private String convertProvenanceData(ObjectBundle bundle) {
        StringBuffer result = new StringBuffer();
        String publishDate = DateGenerator.formatDate(bundle.getPublishDate());
        String publisher = bundle.getPublisher();
        String graph = bundle.getGraphName();
        result.append("  ");
        result.append(this.createTriple(graph, DC.prefixed("publisher"), publisher));
        result.append("  ");
        result.append(this.createTriple(graph, DC.prefixed("date"), this.createDataTypeLiteral(publishDate, XSD.prefixed("dateTime"))));
        return result.toString();
    }

    private String convertProductType(ProductType pType) {
        StringBuffer result = new StringBuffer();
        result.append("  ");
        result.append(pType.getPrefixed());
        result.append("\n");
        result.append(this.createTriplePO(RDF.prefixed("type"), BSBM.prefixed("ProductType")));
        result.append(this.createTriplePO(RDFS.prefixed("label"), this.createLiteral(pType.getLabel())));
        if (pType.getParent() != null) {
            String parentURIREF = BSBM.INST_PREFIX + "ProductType" + pType.getParent().getNr();
            result.append(this.createTriplePO(RDFS.prefixed("subClassOf"), parentURIREF));
        }
        result.append(this.createTriplePOEnd(RDFS.prefixed("comment"), this.createLiteral(pType.getComment())));
        return result.toString();
    }

    private String convertOffer(Offer offer) {
        StringBuffer result = new StringBuffer();
        result.append("  ");
        result.append(offer.getPrefixed());
        result.append("\n");
        result.append(this.createTriplePO(RDF.prefixed("type"), BSBM.prefixed("Offer")));
        int productNr = offer.getProduct();
        int producerNr = Generator.getProducerOfProduct(productNr);
        result.append(this.createTriplePO(BSBM.prefixed("product"), Product.getPrefixed(productNr, producerNr)));
        result.append(this.createTriplePO(BSBM.prefixed("vendor"), Vendor.getPrefixed(offer.getVendor())));
        result.append(this.createTriplePO(BSBM.prefixed("price"), this.createDataTypeLiteral(offer.getPriceString(), BSBM.prefixed("USD"))));
        GregorianCalendar validFrom = new GregorianCalendar();
        validFrom.setTimeInMillis(offer.getValidFrom());
        String validFromString = DateGenerator.formatDateTime(validFrom);
        result.append(this.createTriplePO(BSBM.prefixed("validFrom"), this.createDataTypeLiteral(validFromString, XSD.prefixed("dateTime"))));
        GregorianCalendar validTo = new GregorianCalendar();
        validTo.setTimeInMillis(offer.getValidTo());
        String validToString = DateGenerator.formatDateTime(validTo);
        result.append(this.createTriplePO(BSBM.prefixed("validTo"), this.createDataTypeLiteral(validToString, XSD.prefixed("dateTime"))));
        result.append(this.createTriplePO(BSBM.prefixed("deliveryDays"), this.createDataTypeLiteral(offer.getDeliveryDays().toString(), XSD.prefixed("integer"))));
        result.append(this.createTriplePOEnd(BSBM.prefixed("offerWebpage"), this.createURIref(offer.getOfferWebpage())));
        return result.toString();
    }

    private String convertProduct(Product product) {
        StringBuffer result = new StringBuffer();
        result.append("  ");
        result.append(Product.getPrefixed(product.getNr(), product.getProducer()));
        result.append("\n");
        result.append(this.createTriplePO(RDF.prefixed("type"), BSBM.prefixed("Product")));
        result.append(this.createTriplePO(RDFS.prefixed("label"), this.createLiteral(product.getLabel())));
        result.append(this.createTriplePO(RDFS.prefixed("comment"), this.createLiteral(product.getComment())));
        if (this.forwardChaining) {
            for (ProductType pt = product.getProductType(); pt != null; pt = pt.getParent()) {
                result.append(this.createTriplePO(RDF.prefixed("type"), pt.getPrefixed()));
            }
        } else {
            result.append(this.createTriplePO(RDF.prefixed("type"), product.getProductType().getPrefixed()));
        }
        Integer[] ppn = product.getProductPropertyNumeric();
        int i = 0;
        int j = 1;
        while (i < ppn.length) {
            Integer value = ppn[i];
            if (value != null) {
                result.append(this.createTriplePO(BSBM.getProductPropertyNumericPrefix(j), this.createDataTypeLiteral(value.toString(), XSD.prefixed("integer"))));
            }
            ++i;
            ++j;
        }
        String[] ppt = product.getProductPropertyTextual();
        int i2 = 0;
        int j2 = 1;
        while (i2 < ppt.length) {
            String value = ppt[i2];
            if (value != null) {
                result.append(this.createTriplePO(BSBM.getProductPropertyTextualPrefix(j2), this.createDataTypeLiteral(value, XSD.prefixed("string"))));
            }
            ++i2;
            ++j2;
        }
        for (Integer value : product.getFeatures()) {
            result.append(this.createTriplePO(BSBM.prefixed("productFeature"), ProductFeature.getPrefixed(value)));
        }
        result.append(this.createTriplePOEnd(BSBM.prefixed("producer"), Producer.getPrefixed(product.getProducer())));
        return result.toString();
    }

    private String convertPerson(Person person, ObjectBundle bundle) {
        StringBuffer result = new StringBuffer();
        result.append("  ");
        result.append(Person.getPrefixed(person.getNr(), bundle.getPublisherNum()));
        result.append("\n");
        result.append(this.createTriplePO(RDF.prefixed("type"), FOAF.prefixed("Person")));
        result.append(this.createTriplePO(FOAF.prefixed("name"), this.createLiteral(person.getName())));
        result.append(this.createTriplePO(FOAF.prefixed("mbox_sha1sum"), this.createLiteral(person.getMbox_sha1sum())));
        result.append(this.createTriplePOEnd(BSBM.prefixed("country"), this.createURIref(ISO3166.find(person.getCountryCode()))));
        return result.toString();
    }

    private String convertProducer(Producer producer) {
        StringBuffer result = new StringBuffer();
        result.append("  ");
        result.append(Producer.getPrefixed(producer.getNr()));
        result.append("\n");
        result.append(this.createTriplePO(RDF.prefixed("type"), BSBM.prefixed("Producer")));
        result.append(this.createTriplePO(RDFS.prefixed("label"), this.createLiteral(producer.getLabel())));
        result.append(this.createTriplePO(RDFS.prefixed("comment"), this.createLiteral(producer.getComment())));
        result.append(this.createTriplePO(FOAF.prefixed("homepage"), this.createURIref(producer.getHomepage())));
        result.append(this.createTriplePOEnd(BSBM.prefixed("country"), this.createURIref(ISO3166.find(producer.getCountryCode()))));
        return result.toString();
    }

    private String convertProductFeature(ProductFeature pf) {
        StringBuffer result = new StringBuffer();
        result.append("  ");
        result.append(ProductFeature.getPrefixed(pf.getNr()));
        result.append("\n");
        result.append(this.createTriplePO(RDF.prefixed("type"), BSBM.prefixed("ProductFeature")));
        result.append(this.createTriplePO(RDFS.prefixed("label"), this.createLiteral(pf.getLabel())));
        result.append(this.createTriplePOEnd(RDFS.prefixed("comment"), this.createLiteral(pf.getComment())));
        return result.toString();
    }

    private String convertVendor(Vendor vendor) {
        StringBuffer result = new StringBuffer();
        result.append("  ");
        result.append(Vendor.getPrefixed(vendor.getNr()));
        result.append("\n");
        result.append(this.createTriplePO(RDF.prefixed("type"), BSBM.prefixed("Vendor")));
        result.append(this.createTriplePO(RDFS.prefixed("label"), this.createLiteral(vendor.getLabel())));
        result.append(this.createTriplePO(RDFS.prefixed("comment"), this.createLiteral(vendor.getComment())));
        result.append(this.createTriplePO(FOAF.prefixed("homepage"), this.createURIref(vendor.getHomepage())));
        result.append(this.createTriplePOEnd(BSBM.prefixed("country"), this.createURIref(ISO3166.find(vendor.getCountryCode()))));
        return result.toString();
    }

    private String convertReview(Review review, ObjectBundle bundle) {
        StringBuffer result = new StringBuffer();
        result.append("  ");
        result.append(Review.getPrefixed(review.getNr(), bundle.getPublisherNum()));
        result.append("\n");
        result.append(this.createTriplePO(RDF.prefixed("type"), BSBM.prefixed("Review")));
        result.append(this.createTriplePO(BSBM.prefixed("reviewFor"), Product.getPrefixed(review.getProduct(), review.getProducerOfProduct())));
        result.append(this.createTriplePO(REV.prefixed("reviewer"), Person.getPrefixed(review.getPerson(), review.getPublisher())));
        result.append(this.createTriplePO(DC.prefixed("title"), this.createLiteral(review.getTitle())));
        result.append(this.createTriplePO(REV.prefixed("text"), this.createLanguageLiteral(review.getText(), ISO3166.language[review.getLanguage()])));
        Integer[] ratings = review.getRatings();
        int i = 0;
        int j = 1;
        while (i < ratings.length) {
            Integer value = ratings[i];
            if (value != null) {
                result.append(this.createTriplePO(BSBM.getRatingPrefix(j), this.createDataTypeLiteral(value.toString(), XSD.prefixed("integer"))));
            }
            ++i;
            ++j;
        }
        GregorianCalendar reviewDate = new GregorianCalendar();
        reviewDate.setTimeInMillis(review.getReviewDate());
        String reviewDateString = DateGenerator.formatDateTime(reviewDate);
        result.append(this.createTriplePOEnd(BSBM.prefixed("reviewDate"), this.createDataTypeLiteral(reviewDateString, XSD.prefixed("dateTime"))));
        return result.toString();
    }

    private String createLiteral(String value) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(value);
        result.append("\"");
        return result.toString();
    }

    private String createDataTypeLiteral(String value, String datatypeURI) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(value);
        result.append("\"^^");
        result.append(datatypeURI);
        return result.toString();
    }

    private String createLanguageLiteral(String text, String languageCode) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(text);
        result.append("\"@");
        result.append(languageCode);
        return result.toString();
    }

    private String createTriple(String subject, String predicate, String object) {
        StringBuffer result = new StringBuffer();
        result.append(subject);
        result.append(" ");
        result.append(predicate);
        result.append(" ");
        result.append(object);
        result.append(" .\n");
        ++this.nrTriples;
        return result.toString();
    }

    private String createTriplePO(String predicate, String object) {
        StringBuffer result = new StringBuffer();
        result.append("    ");
        result.append(predicate);
        result.append(" ");
        result.append(object);
        result.append(" ;\n");
        ++this.nrTriples;
        return result.toString();
    }

    private String createTriplePOEnd(String predicate, String object) {
        StringBuffer result = new StringBuffer();
        result.append("    ");
        result.append(predicate);
        result.append(" ");
        result.append(object);
        result.append(" .\n");
        ++this.nrTriples;
        return result.toString();
    }

    private String createURIref(String uri) {
        StringBuffer result = new StringBuffer();
        result.append("<");
        result.append(uri);
        result.append(">");
        return result.toString();
    }

    @Override
    public void serialize() {
        try {
            this.provenanceGraphWriter.append("}\n");
            this.provenanceGraphWriter.flush();
            this.provenanceGraphWriter.close();
            this.dataFileWriter.flush();
            this.dataFileWriter.close();
            this.prefixFileWriter.append("\n");
            FileReader data = new FileReader(this.dataFile);
            char[] buf = new char[100];
            int len = 0;
            while ((len = data.read(buf)) != -1) {
                this.prefixFileWriter.write(buf, 0, len);
            }
            FileReader prov = new FileReader(this.provenanceFile);
            buf = new char[100];
            len = 0;
            while ((len = prov.read(buf)) != -1) {
                this.prefixFileWriter.write(buf, 0, len);
            }
            this.prefixFileWriter.flush();
            this.prefixFileWriter.close();
            data.close();
            prov.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    @Override
    public Long triplesGenerated() {
        return this.nrTriples;
    }
}

