/*
 * Decompiled with CFR 0.152.
 */
package benchmark.serializer;

import benchmark.generator.DateGenerator;
import benchmark.generator.Generator;
import benchmark.model.BSBMResource;
import benchmark.model.Offer;
import benchmark.model.Person;
import benchmark.model.Producer;
import benchmark.model.Product;
import benchmark.model.ProductFeature;
import benchmark.model.ProductType;
import benchmark.model.RatingSite;
import benchmark.model.Review;
import benchmark.model.Vendor;
import benchmark.serializer.ObjectBundle;
import benchmark.serializer.Serializer;
import benchmark.vocabulary.BSBM;
import benchmark.vocabulary.DC;
import benchmark.vocabulary.FOAF;
import benchmark.vocabulary.ISO3166;
import benchmark.vocabulary.RDF;
import benchmark.vocabulary.RDFS;
import benchmark.vocabulary.REV;
import benchmark.vocabulary.XSD;
import java.io.FileWriter;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Iterator;

public class Turtle
implements Serializer {
    private FileWriter[] dataFileWriter;
    private boolean forwardChaining;
    private long nrTriples;
    private boolean haveToGeneratePrefixes = true;
    int currentWriter = 0;

    public Turtle(String file, boolean forwardChaining) {
        this(file, forwardChaining, 1);
    }

    public Turtle(String file, boolean forwardChaining, int nrOfOutputFiles) {
        int i;
        int nrOfDigits = (int)Math.log10(nrOfOutputFiles) + 1;
        String formatString = "%0" + nrOfDigits + "d";
        try {
            this.dataFileWriter = new FileWriter[nrOfOutputFiles];
            if (nrOfOutputFiles == 1) {
                this.dataFileWriter[0] = new FileWriter(file + ".ttl");
            } else {
                for (i = 1; i <= nrOfOutputFiles; ++i) {
                    this.dataFileWriter[i - 1] = new FileWriter(file + String.format(formatString, i) + ".ttl");
                }
            }
        }
        catch (IOException e) {
            System.err.println("Could not open File for writing.");
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        try {
            for (i = 0; i < nrOfOutputFiles; ++i) {
                this.dataFileWriter[i].append(this.getNamespaces());
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        this.forwardChaining = forwardChaining;
        this.nrTriples = 0L;
        TurtleShutdown sd = new TurtleShutdown(this);
        Runtime.getRuntime().addShutdownHook(sd);
    }

    private String getNamespaces() {
        StringBuffer result = new StringBuffer();
        result.append(this.createPrefixLine("rdf:", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
        result.append(this.createPrefixLine("rdfs:", "http://www.w3.org/2000/01/rdf-schema#"));
        result.append(this.createPrefixLine("foaf:", "http://xmlns.com/foaf/0.1/"));
        result.append(this.createPrefixLine("dc:", "http://purl.org/dc/elements/1.1/"));
        result.append(this.createPrefixLine("xsd:", "http://www.w3.org/2001/XMLSchema#"));
        result.append(this.createPrefixLine("rev:", "http://purl.org/stuff/rev#"));
        result.append(this.createPrefixLine(BSBM.PREFIX, BSBM.NS));
        result.append(this.createPrefixLine(BSBM.INST_PREFIX, BSBM.INST_NS));
        return result.toString();
    }

    private String createPrefixLine(String prefix, String namespace) {
        StringBuffer result = new StringBuffer();
        result.append("@prefix ");
        result.append(prefix);
        result.append(" ");
        result.append(this.createURIref(namespace));
        result.append(" .\n");
        return result.toString();
    }

    private void generatePrefixes() {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 1; i < Generator.producerOfProduct.size(); ++i) {
            sb.append("@prefix dataFromProducer");
            sb.append(i);
            sb.append(": <http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/instances/dataFromProducer");
            sb.append(i);
            sb.append("/> .\n");
        }
        for (i = 1; i < Generator.vendorOfOffer.size(); ++i) {
            sb.append("@prefix dataFromVendor");
            sb.append(i);
            sb.append(": <http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/instances/dataFromVendor");
            sb.append(i);
            sb.append("/> .\n");
        }
        for (i = 1; i < Generator.ratingsiteOfReview.size(); ++i) {
            sb.append("@prefix dataFromRatingSite");
            sb.append(i);
            sb.append(": <http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/instances/dataFromRatingSite");
            sb.append(i);
            sb.append("/> .\n");
        }
        sb.append("\n");
        try {
            String tempString = sb.toString();
            for (int i2 = 0; i2 < this.dataFileWriter.length; ++i2) {
                this.dataFileWriter[i2].append(tempString);
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void gatherData(ObjectBundle bundle) {
        if (this.haveToGeneratePrefixes) {
            this.generatePrefixes();
            this.haveToGeneratePrefixes = false;
        }
        Iterator<BSBMResource> it = bundle.iterator();
        try {
            while (it.hasNext()) {
                BSBMResource obj = it.next();
                if (obj instanceof ProductType) {
                    this.dataFileWriter[this.currentWriter].append(this.convertProductType((ProductType)obj));
                } else if (obj instanceof Offer) {
                    this.dataFileWriter[this.currentWriter].append(this.convertOffer((Offer)obj));
                } else if (obj instanceof Product) {
                    this.dataFileWriter[this.currentWriter].append(this.convertProduct((Product)obj));
                } else if (obj instanceof Person) {
                    this.dataFileWriter[this.currentWriter].append(this.convertPerson((Person)obj, bundle));
                } else if (obj instanceof Producer) {
                    this.dataFileWriter[this.currentWriter].append(this.convertProducer((Producer)obj));
                } else if (obj instanceof ProductFeature) {
                    this.dataFileWriter[this.currentWriter].append(this.convertProductFeature((ProductFeature)obj));
                } else if (obj instanceof Vendor) {
                    this.dataFileWriter[this.currentWriter].append(this.convertVendor((Vendor)obj));
                } else if (obj instanceof Review) {
                    this.dataFileWriter[this.currentWriter].append(this.convertReview((Review)obj, bundle));
                }
                this.currentWriter = (this.currentWriter + 1) % this.dataFileWriter.length;
            }
        }
        catch (IOException e) {
            System.err.println("Could not write into File!");
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    private String convertProductType(ProductType pType) {
        StringBuffer result = new StringBuffer();
        result.append(pType.getPrefixed());
        result.append("\n");
        result.append(this.createTriplePO(RDF.prefixed("type"), BSBM.prefixed("ProductType")));
        result.append(this.createTriplePO(RDFS.prefixed("label"), this.createLiteral(pType.getLabel())));
        if (pType.getParent() != null) {
            String parentURIREF = BSBM.INST_PREFIX + "ProductType" + pType.getParent().getNr();
            result.append(this.createTriplePO(RDFS.prefixed("subClassOf"), parentURIREF));
        }
        result.append(this.createTriplePO(RDFS.prefixed("comment"), this.createLiteral(pType.getComment())));
        result.append(this.createTriplePO(DC.prefixed("publisher"), this.createURIref(BSBM.getStandardizationInstitution(pType.getPublisher()))));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(pType.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.createTriplePOEnd(DC.prefixed("date"), this.createDataTypeLiteral(dateString, XSD.prefixed("date"))));
        return result.toString();
    }

    private String convertOffer(Offer offer) {
        StringBuffer result = new StringBuffer();
        result.append(offer.getPrefixed());
        result.append("\n");
        result.append(this.createTriplePO(RDF.prefixed("type"), BSBM.prefixed("Offer")));
        int productNr = offer.getProduct();
        int producerNr = Generator.getProducerOfProduct(productNr);
        result.append(this.createTriplePO(BSBM.prefixed("product"), Product.getPrefixed(productNr, producerNr)));
        result.append(this.createTriplePO(BSBM.prefixed("vendor"), Vendor.getPrefixed(offer.getVendor())));
        result.append(this.createTriplePO(BSBM.prefixed("price"), this.createDataTypeLiteral(offer.getPriceString(), BSBM.prefixed("USD"))));
        GregorianCalendar validFrom = new GregorianCalendar();
        validFrom.setTimeInMillis(offer.getValidFrom());
        String validFromString = DateGenerator.formatDateTime(validFrom);
        result.append(this.createTriplePO(BSBM.prefixed("validFrom"), this.createDataTypeLiteral(validFromString, XSD.prefixed("dateTime"))));
        GregorianCalendar validTo = new GregorianCalendar();
        validTo.setTimeInMillis(offer.getValidTo());
        String validToString = DateGenerator.formatDateTime(validTo);
        result.append(this.createTriplePO(BSBM.prefixed("validTo"), this.createDataTypeLiteral(validToString, XSD.prefixed("dateTime"))));
        result.append(this.createTriplePO(BSBM.prefixed("deliveryDays"), this.createDataTypeLiteral(offer.getDeliveryDays().toString(), XSD.prefixed("integer"))));
        result.append(this.createTriplePO(BSBM.prefixed("offerWebpage"), this.createURIref(offer.getOfferWebpage())));
        result.append(this.createTriplePO(DC.prefixed("publisher"), Vendor.getPrefixed(offer.getPublisher())));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(offer.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.createTriplePOEnd(DC.prefixed("date"), this.createDataTypeLiteral(dateString, XSD.prefixed("date"))));
        return result.toString();
    }

    private String convertProduct(Product product) {
        StringBuffer result = new StringBuffer();
        result.append(Product.getPrefixed(product.getNr(), product.getProducer()));
        result.append("\n");
        result.append(this.createTriplePO(RDF.prefixed("type"), BSBM.prefixed("Product")));
        result.append(this.createTriplePO(RDFS.prefixed("label"), this.createLiteral(product.getLabel())));
        result.append(this.createTriplePO(RDFS.prefixed("comment"), this.createLiteral(product.getComment())));
        if (this.forwardChaining) {
            for (ProductType pt = product.getProductType(); pt != null; pt = pt.getParent()) {
                result.append(this.createTriplePO(RDF.prefixed("type"), pt.getPrefixed()));
            }
        } else {
            result.append(this.createTriplePO(RDF.prefixed("type"), product.getProductType().getPrefixed()));
        }
        Integer[] ppn = product.getProductPropertyNumeric();
        int i = 0;
        int j = 1;
        while (i < ppn.length) {
            Integer value = ppn[i];
            if (value != null) {
                result.append(this.createTriplePO(BSBM.getProductPropertyNumericPrefix(j), this.createDataTypeLiteral(value.toString(), XSD.prefixed("integer"))));
            }
            ++i;
            ++j;
        }
        String[] ppt = product.getProductPropertyTextual();
        int i2 = 0;
        int j2 = 1;
        while (i2 < ppt.length) {
            String value = ppt[i2];
            if (value != null) {
                result.append(this.createTriplePO(BSBM.getProductPropertyTextualPrefix(j2), this.createDataTypeLiteral(value, XSD.prefixed("string"))));
            }
            ++i2;
            ++j2;
        }
        for (Integer value : product.getFeatures()) {
            result.append(this.createTriplePO(BSBM.prefixed("productFeature"), ProductFeature.getPrefixed(value)));
        }
        result.append(this.createTriplePO(BSBM.prefixed("producer"), Producer.getPrefixed(product.getProducer())));
        result.append(this.createTriplePO(DC.prefixed("publisher"), Producer.getPrefixed(product.getPublisher())));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(product.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.createTriplePOEnd(DC.prefixed("date"), this.createDataTypeLiteral(dateString, XSD.prefixed("date"))));
        return result.toString();
    }

    private String convertPerson(Person person, ObjectBundle bundle) {
        StringBuffer result = new StringBuffer();
        result.append(Person.getPrefixed(person.getNr(), bundle.getPublisherNum()));
        result.append("\n");
        result.append(this.createTriplePO(RDF.prefixed("type"), FOAF.prefixed("Person")));
        result.append(this.createTriplePO(FOAF.prefixed("name"), this.createLiteral(person.getName())));
        result.append(this.createTriplePO(FOAF.prefixed("mbox_sha1sum"), this.createLiteral(person.getMbox_sha1sum())));
        result.append(this.createTriplePO(BSBM.prefixed("country"), this.createURIref(ISO3166.find(person.getCountryCode()))));
        result.append(this.createTriplePO(DC.prefixed("publisher"), RatingSite.getPrefixed(person.getPublisher())));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(person.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.createTriplePOEnd(DC.prefixed("date"), this.createDataTypeLiteral(dateString, XSD.prefixed("date"))));
        return result.toString();
    }

    private String convertProducer(Producer producer) {
        StringBuffer result = new StringBuffer();
        result.append(Producer.getPrefixed(producer.getNr()));
        result.append("\n");
        result.append(this.createTriplePO(RDF.prefixed("type"), BSBM.prefixed("Producer")));
        result.append(this.createTriplePO(RDFS.prefixed("label"), this.createLiteral(producer.getLabel())));
        result.append(this.createTriplePO(RDFS.prefixed("comment"), this.createLiteral(producer.getComment())));
        result.append(this.createTriplePO(FOAF.prefixed("homepage"), this.createURIref(producer.getHomepage())));
        result.append(this.createTriplePO(BSBM.prefixed("country"), this.createURIref(ISO3166.find(producer.getCountryCode()))));
        result.append(this.createTriplePO(DC.prefixed("publisher"), Producer.getPrefixed(producer.getPublisher())));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(producer.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.createTriplePOEnd(DC.prefixed("date"), this.createDataTypeLiteral(dateString, XSD.prefixed("date"))));
        return result.toString();
    }

    private String convertProductFeature(ProductFeature pf) {
        StringBuffer result = new StringBuffer();
        result.append(ProductFeature.getPrefixed(pf.getNr()));
        result.append("\n");
        result.append(this.createTriplePO(RDF.prefixed("type"), BSBM.prefixed("ProductFeature")));
        result.append(this.createTriplePO(RDFS.prefixed("label"), this.createLiteral(pf.getLabel())));
        result.append(this.createTriplePO(RDFS.prefixed("comment"), this.createLiteral(pf.getComment())));
        result.append(this.createTriplePO(DC.prefixed("publisher"), this.createURIref(BSBM.getStandardizationInstitution(pf.getPublisher()))));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(pf.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.createTriplePOEnd(DC.prefixed("date"), this.createDataTypeLiteral(dateString, XSD.prefixed("date"))));
        return result.toString();
    }

    private String convertVendor(Vendor vendor) {
        StringBuffer result = new StringBuffer();
        result.append(Vendor.getPrefixed(vendor.getNr()));
        result.append("\n");
        result.append(this.createTriplePO(RDF.prefixed("type"), BSBM.prefixed("Vendor")));
        result.append(this.createTriplePO(RDFS.prefixed("label"), this.createLiteral(vendor.getLabel())));
        result.append(this.createTriplePO(RDFS.prefixed("comment"), this.createLiteral(vendor.getComment())));
        result.append(this.createTriplePO(FOAF.prefixed("homepage"), this.createURIref(vendor.getHomepage())));
        result.append(this.createTriplePO(BSBM.prefixed("country"), this.createURIref(ISO3166.find(vendor.getCountryCode()))));
        result.append(this.createTriplePO(DC.prefixed("publisher"), Vendor.getPrefixed(vendor.getPublisher())));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(vendor.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.createTriplePOEnd(DC.prefixed("date"), this.createDataTypeLiteral(dateString, XSD.prefixed("date"))));
        return result.toString();
    }

    private String convertReview(Review review, ObjectBundle bundle) {
        StringBuffer result = new StringBuffer();
        result.append(Review.getPrefixed(review.getNr(), bundle.getPublisherNum()));
        result.append("\n");
        result.append(this.createTriplePO(RDF.prefixed("type"), BSBM.prefixed("Review")));
        result.append(this.createTriplePO(BSBM.prefixed("reviewFor"), Product.getPrefixed(review.getProduct(), review.getProducerOfProduct())));
        result.append(this.createTriplePO(REV.prefixed("reviewer"), Person.getPrefixed(review.getPerson(), review.getPublisher())));
        result.append(this.createTriplePO(DC.prefixed("title"), this.createLiteral(review.getTitle())));
        result.append(this.createTriplePO(REV.prefixed("text"), this.createLanguageLiteral(review.getText(), ISO3166.language[review.getLanguage()])));
        Integer[] ratings = review.getRatings();
        int i = 0;
        int j = 1;
        while (i < ratings.length) {
            Integer value = ratings[i];
            if (value != null) {
                result.append(this.createTriplePO(BSBM.getRatingPrefix(j), this.createDataTypeLiteral(value.toString(), XSD.prefixed("integer"))));
            }
            ++i;
            ++j;
        }
        GregorianCalendar reviewDate = new GregorianCalendar();
        reviewDate.setTimeInMillis(review.getReviewDate());
        String reviewDateString = DateGenerator.formatDateTime(reviewDate);
        result.append(this.createTriplePO(BSBM.prefixed("reviewDate"), this.createDataTypeLiteral(reviewDateString, XSD.prefixed("dateTime"))));
        result.append(this.createTriplePO(DC.prefixed("publisher"), RatingSite.getPrefixed(review.getPublisher())));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(review.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.createTriplePOEnd(DC.prefixed("date"), this.createDataTypeLiteral(dateString, XSD.prefixed("date"))));
        return result.toString();
    }

    private String createLiteral(String value) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(value);
        result.append("\"");
        return result.toString();
    }

    private String createDataTypeLiteral(String value, String datatypeURI) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(value);
        result.append("\"^^");
        result.append(datatypeURI);
        return result.toString();
    }

    private String createLanguageLiteral(String text, String languageCode) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(text);
        result.append("\"@");
        result.append(languageCode);
        return result.toString();
    }

    private String createTriplePO(String predicate, String object) {
        StringBuffer result = new StringBuffer();
        result.append("    ");
        result.append(predicate);
        result.append(" ");
        result.append(object);
        result.append(" ;\n");
        ++this.nrTriples;
        return result.toString();
    }

    private String createTriplePOEnd(String predicate, String object) {
        StringBuffer result = new StringBuffer();
        result.append("    ");
        result.append(predicate);
        result.append(" ");
        result.append(object);
        result.append(" .\n");
        ++this.nrTriples;
        return result.toString();
    }

    private String createURIref(String uri) {
        StringBuffer result = new StringBuffer();
        result.append("<");
        result.append(uri);
        result.append(">");
        return result.toString();
    }

    @Override
    public void serialize() {
        try {
            for (int i = 0; i < this.dataFileWriter.length; ++i) {
                this.dataFileWriter[i].flush();
                this.dataFileWriter[i].close();
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    @Override
    public Long triplesGenerated() {
        return this.nrTriples;
    }

    class TurtleShutdown
    extends Thread {
        Turtle serializer;

        TurtleShutdown(Turtle t) {
            this.serializer = t;
        }

        @Override
        public void run() {
            for (int i = 0; i < Turtle.this.dataFileWriter.length; ++i) {
                try {
                    this.serializer.dataFileWriter[i].flush();
                    this.serializer.dataFileWriter[i].close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

