/*
 * Decompiled with CFR 0.152.
 */
package benchmark.serializer;

import benchmark.generator.DateGenerator;
import benchmark.generator.Generator;
import benchmark.model.BSBMResource;
import benchmark.model.Offer;
import benchmark.model.Person;
import benchmark.model.Producer;
import benchmark.model.Product;
import benchmark.model.ProductFeature;
import benchmark.model.ProductType;
import benchmark.model.Review;
import benchmark.model.Vendor;
import benchmark.serializer.ObjectBundle;
import benchmark.serializer.Serializer;
import benchmark.vocabulary.ISO3166;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Iterator;

public class VirtSerializer
implements Serializer {
    private File outputDir;
    private boolean forwardChaining;
    private long nrTriples;
    private SQLTables tables;
    private static final int insertNumber = 1;

    public VirtSerializer(String directory, boolean forwardChaining) {
        this.outputDir = new File(directory);
        this.outputDir.mkdirs();
        this.forwardChaining = forwardChaining;
        this.nrTriples = 0L;
        this.initTables();
    }

    @Override
    public void gatherData(ObjectBundle bundle) {
        Iterator<BSBMResource> it = bundle.iterator();
        try {
            while (it.hasNext()) {
                BSBMResource obj = it.next();
                if (obj instanceof ProductType) {
                    this.convertProductType((ProductType)obj);
                    continue;
                }
                if (obj instanceof Offer) {
                    this.convertOffer((Offer)obj);
                    continue;
                }
                if (obj instanceof Product) {
                    this.convertProduct((Product)obj);
                    continue;
                }
                if (obj instanceof Person) {
                    this.convertPerson((Person)obj);
                    continue;
                }
                if (obj instanceof Producer) {
                    this.convertProducer((Producer)obj);
                    continue;
                }
                if (obj instanceof ProductFeature) {
                    this.convertProductFeature((ProductFeature)obj);
                    continue;
                }
                if (obj instanceof Vendor) {
                    this.convertVendor((Vendor)obj);
                    continue;
                }
                if (!(obj instanceof Review)) continue;
                this.convertReview((Review)obj);
            }
        }
        catch (IOException e) {
            System.err.println("Could not write into File!");
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    private void convertProductType(ProductType pType) throws IOException {
        StringBuffer values = this.getBuffer(this.tables.productTypeInsertCounter++, "ProductType");
        values.append("(");
        values.append(pType.getNr());
        values.append(",");
        values.append("'");
        values.append(pType.getLabel());
        values.append("',");
        values.append("'");
        values.append(pType.getComment());
        values.append("',");
        if (pType.getParent() != null) {
            values.append(pType.getParent().getNr());
            values.append(",");
        } else {
            values.append("null,");
        }
        values.append(pType.getPublisher());
        values.append(",");
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(pType.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        values.append("cast ('");
        values.append(dateString);
        values.append("' as date))");
        if (this.tables.productTypeInsertCounter >= 1) {
            this.tables.productTypeInsertCounter = 0;
            values.append(";\n");
        }
        this.tables.productTypeDump.append(values);
    }

    private void convertOffer(Offer offer) throws IOException {
        StringBuffer values = this.getBuffer(this.tables.offerInsertCounter++, "Offer");
        values.append("(");
        values.append(offer.getNr());
        values.append(",");
        values.append(offer.getProduct());
        values.append(",");
        values.append(Generator.getProducerOfProduct(offer.getProduct()));
        values.append(",");
        values.append(offer.getVendor());
        values.append(",");
        values.append(offer.getPriceString());
        values.append(",");
        GregorianCalendar validFrom = new GregorianCalendar();
        validFrom.setTimeInMillis(offer.getValidFrom());
        String validFromString = DateGenerator.formatDate(validFrom);
        values.append("cast ('" + validFromString + "' as dateTime),");
        GregorianCalendar validTo = new GregorianCalendar();
        validTo.setTimeInMillis(offer.getValidTo());
        String validToString = DateGenerator.formatDate(validTo);
        values.append("cast ('" + validToString + "' as dateTime),");
        values.append(offer.getDeliveryDays());
        values.append(",");
        values.append("'" + offer.getOfferWebpage() + "',");
        values.append(offer.getPublisher());
        values.append(",");
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(offer.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        values.append("cast ('");
        values.append(dateString);
        values.append("' as date))");
        if (this.tables.offerInsertCounter >= 1) {
            this.tables.offerInsertCounter = 0;
            values.append(";\n");
        }
        this.tables.offerDump.append(values);
    }

    private void convertProduct(Product product) throws IOException {
        Object value;
        StringBuffer values = this.getBuffer(this.tables.productInsertCounter++, "Product");
        values.append("(");
        values.append(product.getNr());
        values.append(",");
        values.append("'");
        values.append(product.getLabel());
        values.append("',");
        values.append("'");
        values.append(product.getComment());
        values.append("',");
        values.append(product.getProducer());
        values.append(",");
        if (this.forwardChaining) {
            for (ProductType pt = product.getProductType(); pt != null; pt = pt.getParent()) {
                StringBuffer valuesPTP = this.getBuffer(this.tables.productTypeProductInsertCounter++, "ProductTypeProduct");
                valuesPTP.append("(" + product.getNr() + ",");
                valuesPTP.append(Integer.valueOf(pt.getNr()).toString());
                valuesPTP.append(")");
                if (this.tables.productTypeProductInsertCounter >= 1) {
                    this.tables.productTypeProductInsertCounter = 0;
                    valuesPTP.append(";\n");
                }
                this.tables.productTypeProductDump.append(valuesPTP);
            }
        } else {
            StringBuffer valuesPTP = this.getBuffer(this.tables.productTypeProductInsertCounter++, "ProductTypeProduct");
            valuesPTP.append("(" + product.getNr() + ",");
            valuesPTP.append(Integer.valueOf(product.getProductType().getNr()).toString());
            valuesPTP.append(")");
            if (this.tables.productTypeProductInsertCounter >= 1) {
                this.tables.productTypeProductInsertCounter = 0;
                valuesPTP.append(";\n");
            }
            this.tables.productTypeProductDump.append(valuesPTP);
        }
        Integer[] ppn = product.getProductPropertyNumeric();
        Integer i = 0;
        Integer j = 1;
        while (i < ppn.length) {
            Integer value2 = ppn[i];
            if (value2 != null) {
                values.append(value2.toString() + ",");
            } else {
                values.append("null,");
            }
            value2 = i;
            Integer n = i = Integer.valueOf(i + 1);
            value2 = j;
            n = j = Integer.valueOf(j + 1);
        }
        String[] ppt = product.getProductPropertyTextual();
        Integer i2 = 0;
        Integer j2 = 1;
        while (i2 < ppt.length) {
            value = ppt[i2];
            if (value != null) {
                values.append("'" + (String)value + "',");
            } else {
                values.append("null,");
            }
            value = i2;
            Integer n = i2 = Integer.valueOf(i2 + 1);
            value = j2;
            n = j2 = Integer.valueOf(j2 + 1);
        }
        Iterator<Integer> pf = product.getFeatures().iterator();
        while (pf.hasNext()) {
            StringBuffer valuesPFP = this.getBuffer(this.tables.productFeatureProductInsertCounter++, "ProductFeatureProduct");
            valuesPFP.append("(");
            value = pf.next();
            valuesPFP.append(product.getNr());
            valuesPFP.append("," + value);
            valuesPFP.append(")");
            if (this.tables.productFeatureProductInsertCounter >= 1) {
                this.tables.productFeatureProductInsertCounter = 0;
                valuesPFP.append(";\n");
            }
            this.tables.productFeatureProductDump.append(valuesPFP);
        }
        values.append(Integer.valueOf(product.getProducer()).toString());
        values.append(",");
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(product.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        values.append("cast ('" + dateString + "' as date))");
        if (this.tables.productInsertCounter >= 1) {
            this.tables.productInsertCounter = 0;
            values.append(";\n");
        }
        this.tables.productDump.append(values);
    }

    private void convertPerson(Person person) throws IOException {
        StringBuffer values = this.getBuffer(this.tables.personInsertCounter++, "Person");
        values.append("(");
        values.append(person.getNr());
        values.append(",");
        values.append("'");
        values.append(person.getName());
        values.append("',");
        values.append("'");
        values.append(person.getMbox_sha1sum());
        values.append("',");
        values.append("'");
        values.append(person.getCountryCode());
        values.append("',");
        values.append(person.getPublisher());
        values.append(",");
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(person.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        values.append("cast ('" + dateString + "' as date))");
        if (this.tables.personInsertCounter >= 1) {
            this.tables.personInsertCounter = 0;
            values.append(";\n");
        }
        this.tables.personDump.append(values);
    }

    private void convertProducer(Producer producer) throws IOException {
        StringBuffer values = this.getBuffer(this.tables.producerInsertCounter++, "Producer");
        values.append("(");
        values.append(producer.getNr());
        values.append(",");
        values.append("'");
        values.append(producer.getLabel());
        values.append("',");
        values.append("'");
        values.append(producer.getComment());
        values.append("',");
        values.append("'");
        values.append(producer.getHomepage());
        values.append("',");
        values.append("'");
        values.append(producer.getCountryCode());
        values.append("',");
        values.append(producer.getPublisher());
        values.append(",");
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(producer.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        values.append("cast ('" + dateString + "' as date))");
        if (this.tables.producerInsertCounter >= 1) {
            this.tables.producerInsertCounter = 0;
            values.append(";\n");
        }
        this.tables.producerDump.append(values);
    }

    private void convertProductFeature(ProductFeature pf) throws IOException {
        StringBuffer values = this.getBuffer(this.tables.productFeatureInsertCounter++, "ProductFeature");
        values.append("(");
        values.append(pf.getNr());
        values.append(",");
        values.append("'");
        values.append(pf.getLabel());
        values.append("',");
        values.append("'");
        values.append(pf.getComment());
        values.append("',");
        values.append(pf.getPublisher());
        values.append(",");
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(pf.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        values.append("cast ('");
        values.append(dateString);
        values.append("' as date))");
        if (this.tables.productFeatureInsertCounter >= 1) {
            this.tables.productFeatureInsertCounter = 0;
            values.append(";\n");
        }
        this.tables.productFeatureDump.append(values);
    }

    private void convertVendor(Vendor vendor) throws IOException {
        StringBuffer values = this.getBuffer(this.tables.vendorInsertCounter++, "Vendor");
        values.append("(");
        values.append(vendor.getNr());
        values.append(",");
        values.append("'");
        values.append(vendor.getLabel());
        values.append("',");
        values.append("'");
        values.append(vendor.getComment());
        values.append("',");
        values.append("'");
        values.append(vendor.getHomepage());
        values.append("',");
        values.append("'");
        values.append(vendor.getCountryCode());
        values.append("',");
        values.append(vendor.getPublisher());
        values.append(",");
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(vendor.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        values.append("cast ('" + dateString + "' as date))");
        if (this.tables.vendorInsertCounter >= 1) {
            this.tables.vendorInsertCounter = 0;
            values.append(";\n");
        }
        this.tables.vendorDump.append(values);
    }

    private void convertReview(Review review) throws IOException {
        StringBuffer values = this.getBuffer(this.tables.reviewInsertCounter++, "Review");
        values.append("(");
        values.append(review.getNr());
        values.append(",");
        values.append(review.getProduct());
        values.append(",");
        values.append(review.getProducerOfProduct());
        values.append(",");
        values.append(review.getPerson());
        values.append(",");
        GregorianCalendar reviewDate = new GregorianCalendar();
        reviewDate.setTimeInMillis(review.getReviewDate());
        String reviewDateString = DateGenerator.formatDate(reviewDate);
        values.append("cast ('" + reviewDateString + "' as dateTime),");
        values.append("'");
        values.append(review.getTitle());
        values.append("',");
        values.append("'");
        values.append(review.getText());
        values.append("',");
        values.append("'");
        values.append(ISO3166.language[review.getLanguage()]);
        values.append("',");
        Integer[] ratings = review.getRatings();
        for (int i = 0; i < ratings.length; ++i) {
            Integer value = ratings[i];
            values.append(value);
            values.append(",");
        }
        values.append(review.getPublisher());
        values.append(",");
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(review.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        values.append("cast ('" + dateString + "' as date))");
        if (this.tables.reviewInsertCounter >= 1) {
            this.tables.reviewInsertCounter = 0;
            values.append(";\n");
        }
        this.tables.reviewDump.append(values);
    }

    @Override
    public void serialize() {
        try {
            this.tables.productTypeDump.flush();
            this.tables.productTypeDump.close();
            this.tables.productFeatureDump.flush();
            this.tables.productFeatureDump.close();
            this.tables.producerDump.flush();
            this.tables.producerDump.close();
            this.tables.productDump.flush();
            this.tables.productDump.close();
            this.tables.productTypeProductDump.flush();
            this.tables.productTypeProductDump.close();
            this.tables.productFeatureProductDump.flush();
            this.tables.productFeatureProductDump.close();
            this.tables.vendorDump.flush();
            this.tables.vendorDump.close();
            this.tables.offerDump.flush();
            this.tables.offerDump.close();
            this.tables.personDump.flush();
            this.tables.personDump.close();
            this.tables.reviewDump.flush();
            this.tables.reviewDump.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    @Override
    public Long triplesGenerated() {
        return this.nrTriples;
    }

    private void initTables() {
        this.tables = new SQLTables();
        this.tables.offerInsertCounter = 0;
        this.tables.vendorInsertCounter = 0;
        this.tables.productFeatureInsertCounter = 0;
        this.tables.productInsertCounter = 0;
        this.tables.producerInsertCounter = 0;
        this.tables.productTypeProductInsertCounter = 0;
        this.tables.personInsertCounter = 0;
        this.tables.productTypeInsertCounter = 0;
        this.tables.reviewInsertCounter = 0;
        this.tables.productFeatureProductInsertCounter = 0;
        try {
            this.tables.offerDump = new FileWriter(new File(this.outputDir, "08Offer.sql"));
            this.tables.vendorDump = new FileWriter(new File(this.outputDir, "07Vendor.sql"));
            this.tables.productFeatureDump = new FileWriter(new File(this.outputDir, "01ProductFeature.sql"));
            this.tables.productDump = new FileWriter(new File(this.outputDir, "04Product.sql"));
            this.tables.producerDump = new FileWriter(new File(this.outputDir, "03Producer.sql"));
            this.tables.productTypeProductDump = new FileWriter(new File(this.outputDir, "05ProductTypeProduct.sql"));
            this.tables.personDump = new FileWriter(new File(this.outputDir, "09Person.sql"));
            this.tables.productTypeDump = new FileWriter(new File(this.outputDir, "02ProductType.sql"));
            this.tables.reviewDump = new FileWriter(new File(this.outputDir, "10Review.sql"));
            this.tables.productFeatureProductDump = new FileWriter(new File(this.outputDir, "06ProductFeatureProduct.sql"));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private StringBuffer getBuffer(int counter, String tableName) {
        StringBuffer sb = new StringBuffer();
        if (counter == 0) {
            sb.append("INSERT INTO " + tableName + " VALUES ");
        } else {
            sb.append(",");
        }
        return sb;
    }

    private static class SQLTables {
        FileWriter offerDump;
        FileWriter vendorDump;
        FileWriter productFeatureDump;
        FileWriter productDump;
        FileWriter producerDump;
        FileWriter productTypeProductDump;
        FileWriter personDump;
        FileWriter productTypeDump;
        FileWriter reviewDump;
        FileWriter productFeatureProductDump;
        int offerInsertCounter;
        int vendorInsertCounter;
        int productFeatureInsertCounter;
        int productInsertCounter;
        int producerInsertCounter;
        int productTypeProductInsertCounter;
        int personInsertCounter;
        int productTypeInsertCounter;
        int reviewInsertCounter;
        int productFeatureProductInsertCounter;

        SQLTables() {
        }
    }
}

