/*
 * Decompiled with CFR 0.152.
 */
package benchmark.serializer;

import benchmark.generator.DateGenerator;
import benchmark.model.BSBMResource;
import benchmark.model.Offer;
import benchmark.model.Person;
import benchmark.model.Producer;
import benchmark.model.Product;
import benchmark.model.ProductFeature;
import benchmark.model.ProductType;
import benchmark.model.Review;
import benchmark.model.Vendor;
import benchmark.serializer.ObjectBundle;
import benchmark.serializer.Serializer;
import benchmark.vocabulary.ISO3166;
import java.io.FileWriter;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Iterator;

public class XMLSerializer
implements Serializer {
    private FileWriter fileWriter;
    private boolean forwardChaining;
    private long nrTriples;
    private static final String spacePrefix = "  ";

    public XMLSerializer(String file, boolean forwardChaining) {
        try {
            this.fileWriter = new FileWriter(file);
        }
        catch (IOException e) {
            System.err.println("Could not open File for writing.");
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        this.forwardChaining = forwardChaining;
        this.nrTriples = 0L;
        this.writeHeaderData();
    }

    private void writeHeaderData() {
        try {
            this.fileWriter.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?>");
            this.fileWriter.append(this.startTag(0, "bsbm_data"));
            this.fileWriter.append(this.startTag(1, "resources"));
        }
        catch (IOException e) {
            System.err.println("Could not write into File!");
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    private void writeFooterData() {
        try {
            this.fileWriter.append(this.endTag(1, "resources"));
            this.fileWriter.append(this.endTag(0, "bsbm_data"));
        }
        catch (IOException e) {
            System.err.println("Could not write into File!");
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    private String getPublisherTypeString(ObjectBundle bundle) {
        String publisher = bundle.getPublisher().toLowerCase();
        if (publisher.contains("standardizationinstitution")) {
            return "dataFromStandardizationInstitution";
        }
        if (publisher.contains("vendor")) {
            return "dataFromVendor";
        }
        if (publisher.contains("producer")) {
            return "dataFromProducer";
        }
        if (publisher.contains("ratingsite")) {
            return "dataFromRatingSite";
        }
        return null;
    }

    @Override
    public void gatherData(ObjectBundle bundle) {
        Iterator<BSBMResource> it = bundle.iterator();
        String publisherType = this.getPublisherTypeString(bundle);
        if (publisherType == null) {
            System.err.println("Unknown publisher type");
            System.exit(-1);
        }
        try {
            this.fileWriter.append(this.startTagWA(2, publisherType, "id", new Integer(bundle.getPublisherNum()).toString()));
            while (it.hasNext()) {
                BSBMResource obj = it.next();
                if (obj instanceof ProductType) {
                    this.fileWriter.append(this.convertProductType((ProductType)obj));
                    continue;
                }
                if (obj instanceof Offer) {
                    this.fileWriter.append(this.convertOffer((Offer)obj));
                    continue;
                }
                if (obj instanceof Product) {
                    this.fileWriter.append(this.convertProduct((Product)obj));
                    continue;
                }
                if (obj instanceof Person) {
                    this.fileWriter.append(this.convertPerson((Person)obj));
                    continue;
                }
                if (obj instanceof Producer) {
                    this.fileWriter.append(this.convertProducer((Producer)obj));
                    continue;
                }
                if (obj instanceof ProductFeature) {
                    this.fileWriter.append(this.convertProductFeature((ProductFeature)obj));
                    continue;
                }
                if (obj instanceof Vendor) {
                    this.fileWriter.append(this.convertVendor((Vendor)obj));
                    continue;
                }
                if (!(obj instanceof Review)) continue;
                this.fileWriter.append(this.convertReview((Review)obj));
            }
            this.fileWriter.append(this.endTag(2, publisherType));
        }
        catch (IOException e) {
            System.err.println("Could not write into File!");
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    private String convertProductType(ProductType pType) {
        StringBuffer result = new StringBuffer();
        result.append(this.startTagWA(3, "ProductType", "id", new Integer(pType.getNr()).toString()));
        result.append(this.leafTag(4, "label", pType.getLabel()));
        result.append(this.leafTag(4, "comment", pType.getComment()));
        if (pType.getParent() != null) {
            Integer parent = pType.getParent().getNr();
            result.append(this.leafTag(4, "subClassOf", parent.toString()));
        }
        result.append(this.leafTag(4, "publisher", "1"));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(pType.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.leafTag(4, "publishDate", dateString));
        result.append(this.endTag(3, "ProductType"));
        return result.toString();
    }

    private String convertOffer(Offer offer) {
        StringBuffer result = new StringBuffer();
        result.append(this.startTagWA(3, "Offer", "id", new Integer(offer.getNr()).toString()));
        result.append(this.leafTag(4, "product", offer.getProduct().toString()));
        result.append(this.leafTag(4, "vendor", Integer.valueOf(offer.getVendor()).toString()));
        result.append(this.leafTag(4, "price", offer.getPriceString()));
        GregorianCalendar validFrom = new GregorianCalendar();
        validFrom.setTimeInMillis(offer.getValidFrom());
        String validFromString = DateGenerator.formatDate(validFrom);
        result.append(this.leafTag(4, "validFrom", validFromString));
        GregorianCalendar validTo = new GregorianCalendar();
        validTo.setTimeInMillis(offer.getValidTo());
        String validToString = DateGenerator.formatDate(validTo);
        result.append(this.leafTag(4, "validFrom", validToString));
        result.append(this.leafTag(4, "deliveryDays", offer.getDeliveryDays().toString()));
        result.append(this.leafTag(4, "offerWebpage", offer.getOfferWebpage()));
        result.append(this.leafTag(4, "publisher", Integer.valueOf(offer.getVendor()).toString()));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(offer.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.leafTag(4, "publishDate", dateString));
        result.append(this.endTag(3, "Offer"));
        return result.toString();
    }

    private String convertProduct(Product product) {
        StringBuffer result = new StringBuffer();
        result.append(this.startTagWA(3, "Product", "id", new Integer(product.getNr()).toString()));
        result.append(this.leafTag(4, "label", product.getLabel()));
        result.append(this.leafTag(4, "comment", product.getComment()));
        if (this.forwardChaining) {
            for (ProductType pt = product.getProductType(); pt != null; pt = pt.getParent()) {
                result.append(this.leafTag(4, "type", new Integer(pt.getNr()).toString()));
            }
        } else {
            result.append(this.leafTag(4, "type", new Integer(product.getProductType().getNr()).toString()));
        }
        result.append(this.leafTag(4, "producer", new Integer(product.getProducer()).toString()));
        Integer[] ppn = product.getProductPropertyNumeric();
        Integer i = 0;
        Integer j = 1;
        while (i < ppn.length) {
            Integer value = ppn[i];
            if (value != null) {
                result.append(this.leafTagWA(4, "ProductPropertyNumeric", value.toString(), "nr", i.toString()));
            }
            value = i;
            Integer n = i = Integer.valueOf(i + 1);
            value = j;
            n = j = Integer.valueOf(j + 1);
        }
        String[] ppt = product.getProductPropertyTextual();
        Integer i2 = 0;
        Integer j2 = 1;
        while (i2 < ppt.length) {
            Object value = ppt[i2];
            if (value != null) {
                result.append(this.leafTagWA(4, "ProductPropertyTextual", (String)value, "nr", i2.toString()));
            }
            value = i2;
            Integer n = i2 = Integer.valueOf(i2 + 1);
            value = j2;
            n = j2 = Integer.valueOf(j2 + 1);
        }
        for (Integer value : product.getFeatures()) {
            result.append(this.leafTag(4, "ProductFeature", value.toString()));
        }
        result.append(this.leafTag(4, "publisher", new Integer(product.getProducer()).toString()));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(product.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.leafTag(4, "publishDate", dateString));
        result.append(this.endTag(3, "Product"));
        return result.toString();
    }

    private String convertPerson(Person person) {
        StringBuffer result = new StringBuffer();
        result.append(this.startTagWA(3, "Person", "id", new Integer(person.getNr()).toString()));
        result.append(this.leafTag(4, "name", person.getName()));
        result.append(this.leafTag(4, "mbox_sha1sum", person.getMbox_sha1sum()));
        result.append(this.leafTag(4, "country", person.getCountryCode()));
        result.append(this.leafTag(4, "publisher", person.getPublisher().toString()));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(person.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.leafTag(4, "publishDate", dateString));
        result.append(this.endTag(3, "Person"));
        return result.toString();
    }

    private String convertProducer(Producer producer) {
        StringBuffer result = new StringBuffer();
        result.append(this.startTagWA(3, "Producer", "id", new Integer(producer.getNr()).toString()));
        result.append(this.leafTag(4, "label", producer.getLabel()));
        result.append(this.leafTag(4, "comment", producer.getComment()));
        result.append(this.leafTag(4, "homepage", producer.getHomepage()));
        result.append(this.leafTag(4, "country", producer.getCountryCode()));
        result.append(this.leafTag(4, "publisher", new Integer(producer.getNr()).toString()));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(producer.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.leafTag(4, "publishDate", dateString));
        result.append(this.endTag(3, "Producer"));
        return result.toString();
    }

    private String convertProductFeature(ProductFeature pf) {
        StringBuffer result = new StringBuffer();
        result.append(this.startTagWA(3, "ProductFeature", "id", new Integer(pf.getNr()).toString()));
        result.append(this.leafTag(4, "label", pf.getLabel()));
        result.append(this.leafTag(4, "comment", pf.getComment()));
        result.append(this.leafTag(4, "publisher", pf.getPublisher().toString()));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(pf.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.leafTag(4, "publishDate", dateString));
        result.append(this.endTag(3, "ProductFeature"));
        return result.toString();
    }

    private String convertVendor(Vendor vendor) {
        StringBuffer result = new StringBuffer();
        result.append(this.startTagWA(3, "Vendor", "id", new Integer(vendor.getNr()).toString()));
        result.append(this.leafTag(4, "label", vendor.getLabel()));
        result.append(this.leafTag(4, "comment", vendor.getComment()));
        result.append(this.leafTag(4, "homepage", vendor.getHomepage()));
        result.append(this.leafTag(4, "country", vendor.getCountryCode()));
        result.append(this.leafTag(4, "publisher", new Integer(vendor.getNr()).toString()));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(vendor.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.leafTag(4, "publishDate", dateString));
        result.append(this.endTag(3, "Vendor"));
        return result.toString();
    }

    private String convertReview(Review review) {
        StringBuffer result = new StringBuffer();
        result.append(this.startTagWA(3, "Review", "id", new Integer(review.getNr()).toString()));
        result.append(this.leafTag(4, "reviewfor", review.getProduct().toString()));
        result.append(this.leafTag(4, "reviewer", new Integer(review.getPerson()).toString()));
        GregorianCalendar reviewDate = new GregorianCalendar();
        reviewDate.setTimeInMillis(review.getReviewDate());
        String reviewDateString = DateGenerator.formatDate(reviewDate);
        result.append(this.leafTag(4, "reviewDate", reviewDateString));
        result.append(this.leafTag(4, "title", review.getTitle()));
        result.append(this.leafTagWA(4, "text", review.getText(), "lang", ISO3166.language[review.getLanguage()]));
        Integer[] ratings = review.getRatings();
        Integer i = 0;
        Integer j = 1;
        while (i < ratings.length) {
            Integer value = ratings[i];
            if (value != null) {
                result.append(this.leafTagWA(4, "rating", value.toString(), "nr", j.toString()));
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            n = j;
            n2 = j = Integer.valueOf(j + 1);
        }
        result.append(this.leafTag(4, "publisher", review.getPublisher().toString()));
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(review.getPublishDate());
        String dateString = DateGenerator.formatDate(date);
        result.append(this.leafTag(4, "publishDate", dateString));
        result.append(this.endTag(3, "Review"));
        return result.toString();
    }

    private String endTag(int indentationSteps, String tag) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indentationSteps; ++i) {
            sb.append(spacePrefix);
        }
        sb.append("</");
        sb.append(tag);
        sb.append(">\n");
        return sb.toString();
    }

    private String startTag(int indentationSteps, String tag) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indentationSteps; ++i) {
            sb.append(spacePrefix);
        }
        sb.append("<");
        sb.append(tag);
        sb.append(">\n");
        return sb.toString();
    }

    private String startTagWA(int indentationSteps, String tag, String attribute, String attributeContent) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indentationSteps; ++i) {
            sb.append(spacePrefix);
        }
        sb.append("<");
        sb.append(tag);
        sb.append(" ");
        sb.append(attribute);
        sb.append("=\"");
        sb.append(attributeContent);
        sb.append("\">\n");
        return sb.toString();
    }

    private String leafTag(int indentationSteps, String tag, String content) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indentationSteps; ++i) {
            sb.append(spacePrefix);
        }
        sb.append("<");
        sb.append(tag);
        sb.append(">");
        sb.append(content);
        sb.append("</");
        sb.append(tag);
        sb.append(">\n");
        return sb.toString();
    }

    private String leafTagWA(int indentationSteps, String tag, String content, String attribute, String attributeContent) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indentationSteps; ++i) {
            sb.append(spacePrefix);
        }
        sb.append("<");
        sb.append(tag);
        sb.append(" ");
        sb.append(attribute);
        sb.append("=\"");
        sb.append(attributeContent);
        sb.append("\">");
        sb.append(content);
        sb.append("</");
        sb.append(tag);
        sb.append(">\n");
        return sb.toString();
    }

    @Override
    public void serialize() {
        try {
            this.writeFooterData();
            this.fileWriter.flush();
            this.fileWriter.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    @Override
    public Long triplesGenerated() {
        return this.nrTriples;
    }
}

