/*
 * Decompiled with CFR 0.152.
 */
package benchmark.testdriver;

import benchmark.generator.Generator;
import benchmark.generator.RandomBucket;
import benchmark.generator.ValueGenerator;
import benchmark.model.ProductType;
import benchmark.testdriver.Query;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public abstract class AbstractParameterPool {
    protected ValueGenerator valueGen;
    protected ValueGenerator valueGen2;
    protected RandomBucket countryGen;
    protected GregorianCalendar currentDate;
    protected String currentDateString;
    protected ProductType[] productTypeLeaves;
    protected HashMap<String, Integer> wordHash;
    protected String[] wordList;
    protected Integer[] producerOfProduct;
    protected Integer[] vendorOfOffer;
    protected Integer[] ratingsiteOfReview;
    protected Integer productCount;
    protected Integer reviewCount;
    protected Integer offerCount;
    protected int productTypeCount;
    protected List<Integer> maxProductTypePerLevel;
    protected Integer scalefactor;

    public abstract Object[] getParametersForQuery(Query var1);

    public Integer getScalefactor() {
        return this.scalefactor;
    }

    protected void init(File resourceDir, long seed) {
        Random seedGen = new Random(seed);
        this.valueGen = new ValueGenerator(seedGen.nextLong());
        this.countryGen = Generator.createCountryGenerator(seedGen.nextLong());
        this.valueGen2 = new ValueGenerator(seedGen.nextLong());
        this.readProductTypeHierarchy(resourceDir);
        File pp = this.readProductProducerData(resourceDir);
        this.readOfferAndVendorData(resourceDir, pp);
        this.readReviewSiteData(resourceDir);
        this.readDateAndLabelWords(resourceDir);
    }

    private void readDateAndLabelWords(File resourceDir) {
        File cdlw = new File(resourceDir, "cdlw.dat");
        try {
            HashMap x;
            ObjectInputStream currentDateAndLabelWordsInput = new ObjectInputStream(new FileInputStream(cdlw));
            this.productCount = currentDateAndLabelWordsInput.readInt();
            this.reviewCount = currentDateAndLabelWordsInput.readInt();
            this.offerCount = currentDateAndLabelWordsInput.readInt();
            this.currentDate = (GregorianCalendar)currentDateAndLabelWordsInput.readObject();
            this.currentDateString = this.formatDateString(this.currentDate);
            this.wordHash = x = (HashMap)currentDateAndLabelWordsInput.readObject();
            this.wordList = this.wordHash.keySet().toArray(new String[0]);
        }
        catch (IOException e) {
            System.err.println("Could not open or process file " + cdlw.getAbsolutePath());
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
        }
    }

    private void readReviewSiteData(File resourceDir) {
        File rr = new File(resourceDir, "rr.dat");
        try {
            ObjectInputStream reviewRatingsiteInput = new ObjectInputStream(new FileInputStream(rr));
            this.ratingsiteOfReview = (Integer[])reviewRatingsiteInput.readObject();
        }
        catch (IOException e) {
            System.err.println("Could not open or process file " + rr.getAbsolutePath());
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
        }
    }

    private void readOfferAndVendorData(File resourceDir, File pp) {
        File vo = new File(resourceDir, "vo.dat");
        try {
            ObjectInputStream offerVendorInput = new ObjectInputStream(new FileInputStream(vo));
            this.vendorOfOffer = (Integer[])offerVendorInput.readObject();
        }
        catch (IOException e) {
            System.err.println("Could not open or process file " + pp.getAbsolutePath());
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
        }
    }

    private File readProductProducerData(File resourceDir) {
        File pp = new File(resourceDir, "pp.dat");
        try {
            ObjectInputStream productProducerInput = new ObjectInputStream(new FileInputStream(pp));
            this.producerOfProduct = (Integer[])productProducerInput.readObject();
            this.scalefactor = this.producerOfProduct[this.producerOfProduct.length - 1];
        }
        catch (IOException e) {
            System.err.println("Could not open or process file " + pp.getAbsolutePath());
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
        }
        return pp;
    }

    private void readProductTypeHierarchy(File resourceDir) {
        File pth = new File(resourceDir, "pth.dat");
        try {
            ObjectInputStream productTypeInput = new ObjectInputStream(new FileInputStream(pth));
            this.productTypeLeaves = (ProductType[])productTypeInput.readObject();
            this.productTypeCount = productTypeInput.readInt();
            this.maxProductTypePerLevel = (List)productTypeInput.readObject();
        }
        catch (IOException e) {
            System.err.println("Could not open or process file " + pth.getAbsolutePath());
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
        }
    }

    protected abstract String formatDateString(GregorianCalendar var1);

    protected Integer getRandomProductNr() {
        Integer productNr = this.valueGen.randomInt(1, this.productCount);
        return productNr;
    }

    protected Integer getProducerOfProduct(Integer productNr) {
        Integer producerNr = Arrays.binarySearch((Object[])this.producerOfProduct, productNr);
        if (producerNr < 0) {
            producerNr = -producerNr.intValue() - 1;
        }
        return producerNr;
    }

    protected Integer getVendorOfOffer(Integer offerNr) {
        Integer vendorNr = Arrays.binarySearch((Object[])this.vendorOfOffer, offerNr);
        if (vendorNr < 0) {
            vendorNr = -vendorNr.intValue() - 1;
        }
        return vendorNr;
    }

    protected Integer getRatingsiteOfReviewer(Integer reviewNr) {
        Integer ratingSiteNr = Arrays.binarySearch((Object[])this.ratingsiteOfReview, reviewNr);
        if (ratingSiteNr < 0) {
            ratingSiteNr = -ratingSiteNr.intValue() - 1;
        }
        return ratingSiteNr;
    }

    protected Integer getProductPropertyNumeric() {
        return this.valueGen.randomInt(1, 500);
    }

    protected String getRandomWord() {
        Integer index = this.valueGen.randomInt(0, this.wordList.length - 1);
        return this.wordList[index];
    }
}

