/*
 * Decompiled with CFR 0.152.
 */
package benchmark.testdriver;

import benchmark.testdriver.AbstractParameterPool;
import benchmark.testdriver.ClientThread;
import benchmark.testdriver.CompiledQueryMix;
import benchmark.testdriver.PreCalcParameterPool;
import benchmark.testdriver.QueryMix;
import benchmark.testdriver.SPARQLConnection;
import benchmark.testdriver.SQLConnection;
import benchmark.testdriver.ServerConnection;
import benchmark.testdriver.TestDriver;

public class ClientManager {
    private int activeThreadsInWarmup = 0;
    private int activeThreadsInRun = 0;
    private boolean warmupPhase;
    private boolean runPhase;
    private int nrThreads;
    private int nrWarmup;
    private QueryMix queryMix;
    private PreCalcParameterPool pool;
    protected boolean[] ignoreQueries;
    private ClientThread[] clients;
    private TestDriver parent;

    ClientManager(AbstractParameterPool pool, TestDriver parent) {
        this.parent = parent;
        this.nrWarmup = parent.warmups;
        this.nrThreads = parent.nrThreads;
        this.queryMix = parent.queryMix;
        this.ignoreQueries = parent.ignoreQueries;
        this.pool = new PreCalcParameterPool(parent.parameterPool, this.nrWarmup);
        this.pool.calcQueryMixes(this.queryMix, parent.nrRuns + this.nrWarmup);
        this.queryMix.init();
    }

    public void createClients() {
        this.clients = new ClientThread[this.nrThreads];
        for (int i = 0; i < this.nrThreads; ++i) {
            ServerConnection sConn = this.parent.doSQL ? new SQLConnection(this.parent.sparqlEndpoint, this.parent.timeout, this.parent.driverClassName) : (this.parent.sparqlUpdateEndpoint == null ? new SPARQLConnection(this.parent.sparqlEndpoint, this.parent.defaultGraph, this.parent.timeout) : new SPARQLConnection(this.parent.sparqlEndpoint, this.parent.sparqlUpdateEndpoint, this.parent.defaultGraph, this.parent.timeout));
            this.clients[i] = new ClientThread(this.pool, sConn, this.ignoreQueries.length, this, i + 1);
        }
        System.out.println("Clients created.");
        System.out.flush();
    }

    public void startWarmup() {
        this.warmupPhase = true;
        this.activeThreadsInWarmup = this.nrThreads;
        for (int i = 0; i < this.nrThreads; ++i) {
            this.clients[i].start();
        }
        while (this.activeThreadsInWarmup > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                System.err.println("Got interrupted. Exit.");
                return;
            }
        }
        System.out.println("Warmup phase ended...\n");
        this.warmupPhase = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRun() {
        Long start;
        System.out.println("Starting actual run...");
        this.activeThreadsInRun = this.nrThreads;
        PreCalcParameterPool preCalcParameterPool = this.pool;
        synchronized (preCalcParameterPool) {
            this.runPhase = true;
            this.pool.setRunPhase();
            start = System.nanoTime();
        }
        while (this.activeThreadsInRun > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                System.err.println("Got interrupted. Exit.");
                return;
            }
        }
        Long stop = System.nanoTime();
        Double totalRunTimeInSeconds = (double)(stop - start) / 1.0E9;
        this.queryMix.setMultiThreadRuntime(totalRunTimeInSeconds);
        System.out.println("Benchmark run completed in " + totalRunTimeInSeconds + "s");
    }

    public synchronized void finishWarmup(ClientThread client) {
        client.getQueryMix().init();
        --this.activeThreadsInWarmup;
    }

    public synchronized void finishRun(ClientThread client) {
        CompiledQueryMix qMix = client.getQueryMix();
        if (qMix.getQueryMixRuns() > 0) {
            this.queryMix.addCompiledQueryMix(qMix);
        }
        --this.activeThreadsInRun;
    }

    public boolean isWarmupPhase() {
        return this.warmupPhase;
    }

    public boolean isRunPhase() {
        return this.runPhase;
    }
}

