/*
 * Decompiled with CFR 0.152.
 */
package benchmark.testdriver;

import benchmark.testdriver.ClientManager;
import benchmark.testdriver.CompiledQuery;
import benchmark.testdriver.CompiledQueryMix;
import benchmark.testdriver.PreCalcParameterPool;
import benchmark.testdriver.ServerConnection;
import java.util.Locale;

public class ClientThread
extends Thread {
    private PreCalcParameterPool pool;
    private ServerConnection conn;
    private CompiledQueryMix queryMix;
    private ClientManager manager;
    private boolean finishedWarmup;
    private int maxQuery;
    private int nr;

    ClientThread(PreCalcParameterPool pool, ServerConnection conn, int maxQuery, ClientManager parent, int clientNr) {
        this.pool = pool;
        this.conn = conn;
        this.maxQuery = maxQuery;
        this.manager = parent;
        this.finishedWarmup = false;
        this.nr = clientNr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.queryMix = new CompiledQueryMix(this.maxQuery);
        while (!Thread.interrupted()) {
            boolean inRun;
            boolean inWarmup;
            boolean gotNew;
            ClientManager clientManager = this.manager;
            synchronized (clientManager) {
                gotNew = this.pool.getNextQueryMix(this.queryMix);
                inWarmup = this.manager.isWarmupPhase();
                inRun = this.manager.isRunPhase();
            }
            if (ClientThread.interrupted()) {
                System.err.println("Thread interrupted. Quitting...");
                return;
            }
            if (!gotNew) {
                try {
                    if (inWarmup) {
                        if (!this.finishedWarmup) {
                            this.manager.finishWarmup(this);
                            this.finishedWarmup = true;
                        }
                        ClientThread.sleep(20L);
                        continue;
                    }
                    if (!inRun) {
                        ClientThread.sleep(20L);
                        continue;
                    }
                    this.manager.finishRun(this);
                    return;
                }
                catch (InterruptedException e) {
                    System.err.println("Thread interrupted. Quitting...");
                    this.conn.close();
                    return;
                }
            }
            Long startTime = System.nanoTime();
            while (this.queryMix.hasNext().booleanValue()) {
                CompiledQuery next = this.queryMix.getNext();
                if (next == null || this.manager.ignoreQueries[next.getNr() - 1]) {
                    this.queryMix.setCurrent(0, -1.0);
                    continue;
                }
                this.conn.executeQuery(next, this.queryMix);
            }
            System.out.println("Thread " + this.nr + ": query mix " + this.queryMix.getRun() + ": " + String.format(Locale.US, "%.2f", this.queryMix.getQueryMixRuntime() * 1000.0) + "ms, total: " + String.format(Locale.US, "%.2f", (double)(System.nanoTime() - startTime) / 1000000.0) + "ms");
            this.queryMix.finishRun();
        }
    }

    public CompiledQueryMix getQueryMix() {
        return this.queryMix;
    }
}

