/*
 * Decompiled with CFR 0.152.
 */
package benchmark.testdriver;

import benchmark.testdriver.CompiledQuery;

public class CompiledQueryMix {
    protected CompiledQuery[] queryMix;
    int queryNr;
    private double[] aqet;
    private double[] qmin;
    private double[] qmax;
    private double[] avgResults;
    private double[] aqetg;
    private int[] minResults;
    private int[] maxResults;
    private int[] runsPerQuery;
    private int[] timeoutsPerQuery;
    private int run;
    private int currentQueryIndex;
    private int queryMixRuns;
    private double queryMixRuntime;
    private double minQueryMixRuntime;
    private double maxQueryMixRuntime;
    private double queryMixGeoMean;
    private double totalRuntime;

    public CompiledQueryMix(CompiledQuery[] queryMix, int maxQueryNr) {
        this.queryNr = maxQueryNr;
        this.queryMix = queryMix;
        this.init();
    }

    public CompiledQueryMix(int maxQueryNr) {
        this.queryNr = maxQueryNr;
        this.init();
    }

    public void setNewCompiledQueryMix(CompiledQuery[] queryMix) {
        this.queryMix = queryMix;
    }

    public void init(CompiledQuery[] queryMix) {
        this.queryMix = queryMix;
        this.init();
    }

    public void init() {
        int i;
        this.aqet = new double[this.queryNr];
        this.qmin = new double[this.queryNr];
        this.qmax = new double[this.queryNr];
        this.avgResults = new double[this.queryNr];
        this.aqetg = new double[this.queryNr];
        this.minResults = new int[this.queryNr];
        this.maxResults = new int[this.queryNr];
        this.runsPerQuery = new int[this.queryNr];
        this.timeoutsPerQuery = new int[this.queryNr];
        this.currentQueryIndex = 0;
        this.queryMixRuns = 0;
        this.queryMixRuntime = 0.0;
        this.totalRuntime = 0.0;
        this.minQueryMixRuntime = Double.MAX_VALUE;
        this.maxQueryMixRuntime = Double.MIN_VALUE;
        this.queryMixGeoMean = 0.0;
        this.run = 0;
        for (i = 0; i < this.qmax.length; ++i) {
            this.qmax[i] = Double.MIN_VALUE;
            this.maxResults[i] = Integer.MIN_VALUE;
        }
        for (i = 0; i < this.qmin.length; ++i) {
            this.qmin[i] = Double.MAX_VALUE;
            this.minResults[i] = Integer.MAX_VALUE;
        }
    }

    public void setRun(int run) {
        this.run = run;
    }

    public void finishRun() {
        this.currentQueryIndex = 0;
        if (this.run >= 0) {
            ++this.queryMixRuns;
            if (this.queryMixRuntime < this.minQueryMixRuntime) {
                this.minQueryMixRuntime = this.queryMixRuntime;
            }
            if (this.queryMixRuntime > this.maxQueryMixRuntime) {
                this.maxQueryMixRuntime = this.queryMixRuntime;
            }
            this.queryMixGeoMean += Math.log10(this.queryMixRuntime);
            this.totalRuntime += this.queryMixRuntime;
        }
        this.queryMixRuntime = 0.0;
        this.queryMix = null;
    }

    public CompiledQuery getNext() {
        return this.queryMix[this.currentQueryIndex];
    }

    public Boolean hasNext() {
        return this.currentQueryIndex < this.queryMix.length;
    }

    public void reportTimeOut() {
        int queryNr;
        int n = queryNr = this.queryMix[this.currentQueryIndex].getNr() - 1;
        this.timeoutsPerQuery[n] = this.timeoutsPerQuery[n] + 1;
    }

    public void setCurrent(int numberResults, Double timeInSeconds) {
        if (this.run >= 0 && timeInSeconds >= 0.0) {
            int queryNr;
            int n = queryNr = this.queryMix[this.currentQueryIndex].getNr() - 1;
            int n2 = this.runsPerQuery[n];
            this.runsPerQuery[n] = n2 + 1;
            int nrRuns = n2;
            this.aqet[queryNr] = (this.aqet[queryNr] * (double)nrRuns + timeInSeconds) / (double)(nrRuns + 1);
            this.avgResults[queryNr] = (this.avgResults[queryNr] * (double)nrRuns + (double)numberResults) / (double)(nrRuns + 1);
            int n3 = queryNr;
            this.aqetg[n3] = this.aqetg[n3] + Math.log10(timeInSeconds);
            if (timeInSeconds < this.qmin[queryNr]) {
                this.qmin[queryNr] = timeInSeconds;
            }
            if (timeInSeconds > this.qmax[queryNr]) {
                this.qmax[queryNr] = timeInSeconds;
            }
            if (numberResults < this.minResults[queryNr]) {
                this.minResults[queryNr] = numberResults;
            }
            if (numberResults > this.maxResults[queryNr]) {
                this.maxResults[queryNr] = numberResults;
            }
            this.queryMixRuntime += timeInSeconds.doubleValue();
        }
        ++this.currentQueryIndex;
    }

    public double[] getAqet() {
        return this.aqet;
    }

    public double[] getQmin() {
        return this.qmin;
    }

    public double[] getQmax() {
        return this.qmax;
    }

    public int[] getRunsPerQuery() {
        return this.runsPerQuery;
    }

    public int getQueryMixRuns() {
        return this.queryMixRuns;
    }

    public double getQmph() {
        return 3600.0 / (this.totalRuntime / (double)this.queryMixRuns);
    }

    public double getQueryMixRuntime() {
        return this.queryMixRuntime;
    }

    public double getTotalRuntime() {
        return this.totalRuntime;
    }

    public double getCQET() {
        return this.totalRuntime / (double)this.queryMixRuns;
    }

    public double getMinQueryMixRuntime() {
        return this.minQueryMixRuntime;
    }

    public double getMaxQueryMixRuntime() {
        return this.maxQueryMixRuntime;
    }

    public void setQueryMixRuntime(double queryMixRuntime) {
        this.queryMixRuntime = queryMixRuntime;
    }

    public int getRun() {
        return this.run;
    }

    public double[] getAvgResults() {
        return this.avgResults;
    }

    public int[] getMinResults() {
        return this.minResults;
    }

    public int[] getMaxResults() {
        return this.maxResults;
    }

    public double[] getGeoMean() {
        double[] temp = new double[this.aqetg.length];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = Math.pow(10.0, this.aqetg[i] / (double)this.runsPerQuery[i]);
        }
        return temp;
    }

    public double getQueryMixGeometricMean() {
        return Math.pow(10.0, this.queryMixGeoMean / (double)this.queryMixRuns);
    }

    public double getQueryMixGeoMean() {
        return this.queryMixGeoMean;
    }

    public double[] getAqetg() {
        return this.aqetg;
    }

    public int[] getTimeoutsPerQuery() {
        return this.timeoutsPerQuery;
    }
}

