/*
 * Decompiled with CFR 0.152.
 */
package benchmark.testdriver;

import benchmark.generator.DateGenerator;
import benchmark.model.Offer;
import benchmark.model.Producer;
import benchmark.model.Product;
import benchmark.model.ProductFeature;
import benchmark.model.ProductType;
import benchmark.model.Review;
import benchmark.testdriver.AbstractParameterPool;
import benchmark.testdriver.ParameterGenerator;
import benchmark.testdriver.Query;
import benchmark.vocabulary.ISO3166;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

public class LocalSPARQLParameterPool
extends AbstractParameterPool {
    private BufferedReader updateFileReader = null;
    private GregorianCalendar publishDateMin = new GregorianCalendar(2007, 5, 20);

    public LocalSPARQLParameterPool(File resourceDirectory, Long seed) {
        this.init(resourceDirectory, seed);
    }

    public LocalSPARQLParameterPool(File resourceDirectory, Long seed, File updateDatasetFile) {
        this.init(resourceDirectory, seed);
        try {
            this.updateFileReader = new BufferedReader(new FileReader(updateDatasetFile));
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not open update dataset file: " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public Object[] getParametersForQuery(Query query) {
        Byte[] parameterTypes = query.getParameterTypes();
        Object[] parameters = new Object[parameterTypes.length];
        ArrayList<Integer> productFeatureIndices = new ArrayList<Integer>();
        ProductType pt = null;
        GregorianCalendar randomDate = null;
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] == 3) {
                pt = ParameterGenerator.getRandomProductType(this.productTypeLeaves, this.valueGen);
                parameters[i] = pt.toString();
                continue;
            }
            if (parameterTypes[i] == 2) {
                productFeatureIndices.add(i);
                continue;
            }
            if (parameterTypes[i] == 1) {
                parameters[i] = this.getProductPropertyNumeric();
                continue;
            }
            if (parameterTypes[i] == 6) {
                parameters[i] = this.getRandomProductURI();
                continue;
            }
            if (parameterTypes[i] == 4) {
                parameters[i] = this.currentDateString;
                continue;
            }
            if (parameterTypes[i] == 8) {
                parameters[i] = "<" + ISO3166.find((String)this.countryGen.getRandom()) + ">";
                continue;
            }
            if (parameterTypes[i] == 7) {
                parameters[i] = this.getRandomReviewURI();
                continue;
            }
            if (parameterTypes[i] == 5) {
                parameters[i] = this.getRandomWord();
                continue;
            }
            if (parameterTypes[i] == 9) {
                parameters[i] = this.getRandomOfferURI();
                continue;
            }
            if (parameterTypes[i] == 11) {
                parameters[i] = this.getUpdateTransactionData();
                continue;
            }
            if (parameterTypes[i] == 10) {
                if (randomDate == null) {
                    randomDate = ParameterGenerator.getRandomDate(this.publishDateMin, this.valueGen, 309);
                }
                int monthNr = (Integer)query.getAdditionalParameterInfo(i);
                parameters[i] = ParameterGenerator.getConsecutiveMonth(randomDate, monthNr);
                continue;
            }
            if (parameterTypes[i] == 12) {
                parameters[i] = this.getRandomProducerURI();
                continue;
            }
            if (parameterTypes[i] == 13) {
                Integer[] rangeModifiers = (Integer[])query.getAdditionalParameterInfo(i);
                int ptnr = ParameterGenerator.getRandomProductTypeNrFromRange(this.maxProductTypePerLevel, rangeModifiers, this.valueGen, this.valueGen2);
                parameters[i] = ProductType.getURIRef(ptnr);
                continue;
            }
            parameters[i] = null;
        }
        if (productFeatureIndices.size() > 0 && pt == null) {
            System.err.println("Error in parameter generation: Asked for product features without product type.");
            System.exit(-1);
        }
        String[] productFeatures = this.getRandomProductFeatures(pt, productFeatureIndices.size());
        for (int i = 0; i < productFeatureIndices.size(); ++i) {
            parameters[((Integer)productFeatureIndices.get((int)i)).intValue()] = productFeatures[i];
        }
        return parameters;
    }

    private String[] getRandomProductFeatures(ProductType pt, Integer number) {
        String[] productFeatures = new String[number.intValue()];
        List<Integer> pfs = ParameterGenerator.getRandomProductFeatures(pt, number);
        for (int i = 0; i < number; ++i) {
            Integer index = this.valueGen.randomInt(0, pfs.size() - 1);
            productFeatures[i] = ProductFeature.getURIref(pfs.get(index));
            pfs.remove(index);
        }
        return productFeatures;
    }

    private String getRandomProductURI() {
        Integer productNr = this.getRandomProductNr();
        Integer producerNr = this.getProducerOfProduct(productNr);
        return Product.getURIref(productNr, producerNr);
    }

    private String getRandomOfferURI() {
        Integer offerNr = this.valueGen.randomInt(1, this.offerCount);
        Integer vendorNr = this.getVendorOfOffer(offerNr);
        return Offer.getURIref(offerNr, vendorNr);
    }

    private String getRandomReviewURI() {
        Integer reviewNr = this.valueGen.randomInt(1, this.reviewCount);
        Integer ratingSiteNr = this.getRatingsiteOfReviewer(reviewNr);
        return Review.getURIref(reviewNr, ratingSiteNr);
    }

    private String getRandomProducerURI() {
        Integer producerNr = this.valueGen.randomInt(1, this.producerOfProduct.length - 1);
        return Producer.getURIref(producerNr);
    }

    private String getUpdateTransactionData() {
        StringBuilder s = new StringBuilder();
        String line = null;
        if (this.updateFileReader == null) {
            System.err.println("Error: No update dataset file specified! Use -udataset option of the test driver with a generated update dataset file as argument.");
            System.exit(-1);
        }
        try {
            while ((line = this.updateFileReader.readLine()) != null && !line.equals("#__SEP__")) {
                s.append(line);
                s.append("\n");
            }
        }
        catch (IOException e) {
            System.err.println("Error reading update data from file: " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
        return s.toString();
    }

    @Override
    protected String formatDateString(GregorianCalendar date) {
        return "\"" + DateGenerator.formatDateTime(date) + "\"^^<" + "http://www.w3.org/2001/XMLSchema#dateTime" + ">";
    }
}

