/*
 * Decompiled with CFR 0.152.
 */
package benchmark.testdriver;

import benchmark.testdriver.TestDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;

public class NetQuery {
    HttpURLConnection conn;
    Long start;
    Long end;
    String queryString;

    protected NetQuery(String serviceURL, String query, byte queryType, String defaultGraph, int timeout) {
        String urlString = null;
        try {
            char delim;
            this.queryString = query;
            char c = delim = serviceURL.indexOf(63) == -1 ? (char)'?' : '&';
            if (queryType == 4) {
                urlString = serviceURL;
            } else {
                urlString = serviceURL + delim + "query=" + URLEncoder.encode(query, "UTF-8");
                delim = '&';
                if (defaultGraph != null) {
                    urlString = urlString + delim + "default-graph-uri=" + defaultGraph;
                }
            }
            URL url = new URL(urlString);
            this.conn = (HttpURLConnection)url.openConnection();
            this.configureConnection(query, queryType, timeout, defaultGraph);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.toString());
            e.printStackTrace();
            System.exit(-1);
        }
        catch (MalformedURLException e) {
            System.err.println(e.toString() + " for URL: " + urlString);
            System.err.println(serviceURL);
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IOException e) {
            System.err.println(e.toString());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void configureConnection(String query, byte queryType, int timeout, String defaultGraph) throws ProtocolException, IOException {
        if (queryType == 4) {
            this.conn.setRequestMethod("POST");
        } else {
            this.conn.setRequestMethod("GET");
        }
        this.conn.setDefaultUseCaches(false);
        this.conn.setDoOutput(true);
        this.conn.setUseCaches(false);
        this.conn.setReadTimeout(timeout);
        if (queryType == 2 || queryType == 3) {
            this.conn.setRequestProperty("Accept", "application/rdf+xml");
        } else {
            this.conn.setRequestProperty("Accept", "application/sparql-results+xml");
        }
        if (queryType == 4) {
            this.conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStream out = this.conn.getOutputStream();
            String queryParamName = TestDriver.sparqlUpdateQueryParameter + "=";
            out.write(queryParamName.getBytes());
            out.write(URLEncoder.encode(query, "UTF-8").getBytes());
            if (defaultGraph != null) {
                out.write("&default-graph-uri=".getBytes());
                out.write(defaultGraph.getBytes());
            }
            out.flush();
        }
    }

    protected InputStream exec() {
        try {
            this.conn.connect();
        }
        catch (IOException e) {
            System.err.println("Could not connect to SPARQL Service.");
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            this.start = System.nanoTime();
            int rc = this.conn.getResponseCode();
            if (rc < 200 || rc >= 300) {
                System.err.println("Query execution: Received error code " + rc + " from server");
                System.err.println("Error message: " + this.conn.getResponseMessage() + "\n\nFor query: \n");
                System.err.println(this.queryString + "\n");
            }
            return this.conn.getInputStream();
        }
        catch (SocketTimeoutException e) {
            return null;
        }
        catch (IOException e) {
            System.err.println("Query execution error:");
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    protected double getExecutionTimeInSeconds() {
        this.end = System.nanoTime();
        Long interval = this.end - this.start;
        Thread.yield();
        return interval.doubleValue() / 1.0E9;
    }

    protected void close() {
        this.conn.disconnect();
        this.conn = null;
    }
}

