/*
 * Decompiled with CFR 0.152.
 */
package benchmark.testdriver;

import benchmark.testdriver.AbstractParameterPool;
import benchmark.testdriver.CompiledQuery;
import benchmark.testdriver.CompiledQueryMix;
import benchmark.testdriver.Query;
import benchmark.testdriver.QueryMix;

public class PreCalcParameterPool {
    AbstractParameterPool parameterPool;
    private CompiledQuery[][] queryMixes;
    private int queryMixNr;
    private int warmups;
    private boolean warmupPhase;
    private boolean runPhase;

    PreCalcParameterPool(AbstractParameterPool parameterPool, int warmups) {
        this.parameterPool = parameterPool;
        this.warmups = warmups;
        this.warmupPhase = true;
        this.runPhase = false;
        this.queryMixNr = 0;
    }

    public void calcQueryMixes(QueryMix queryMix, int times) {
        System.out.print("Generating queries...");
        System.out.flush();
        this.queryMixes = new CompiledQuery[times][queryMix.queryMix.length];
        for (int nrRun = 0; nrRun < times; ++nrRun) {
            queryMix.setRun(nrRun);
            int i = 0;
            while (queryMix.hasNext().booleanValue()) {
                Query next = queryMix.getNext();
                if (nrRun < this.warmups && next.getQueryType() == 4) {
                    this.queryMixes[nrRun][i++] = null;
                    queryMix.setCurrent(0, -1.0);
                    continue;
                }
                Object[] queryParameters = this.parameterPool.getParametersForQuery(next);
                next.setParameters(queryParameters);
                this.queryMixes[nrRun][i++] = new CompiledQuery(next.getQueryString(), next.getQueryType(), next.getNr());
                queryMix.setCurrent(0, -1.0);
            }
            queryMix.finishRun();
        }
        System.out.println("done");
    }

    public synchronized CompiledQuery[] getNextQueryMix() {
        if (this.queryMixNr == this.warmups) {
            this.warmupPhase = false;
        }
        if (!this.warmupPhase && !this.runPhase) {
            return null;
        }
        if (this.queryMixNr >= this.queryMixes.length) {
            return null;
        }
        return this.queryMixes[this.queryMixNr++];
    }

    public synchronized boolean getNextQueryMix(CompiledQueryMix queryMix) {
        if (this.queryMixNr == this.warmups) {
            this.warmupPhase = false;
        }
        if (!this.warmupPhase && !this.runPhase) {
            return false;
        }
        if (this.queryMixNr >= this.queryMixes.length) {
            return false;
        }
        queryMix.setRun(this.queryMixNr - this.warmups);
        queryMix.setNewCompiledQueryMix(this.queryMixes[this.queryMixNr++]);
        return true;
    }

    public boolean isWarmupPhase() {
        return this.warmupPhase;
    }

    public void setRunPhase() {
        this.runPhase = true;
    }

    public boolean isRunPhase() {
        return this.runPhase;
    }
}

