/*
 * Decompiled with CFR 0.152.
 */
package benchmark.testdriver;

import benchmark.testdriver.QueryMix;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class Query {
    private int nr;
    private Object[] parameters;
    private Integer[] parameterFills;
    private Byte[] parameterTypes;
    private Object[] additionalParameterInfo;
    private Vector<String> queryStrings;
    private Byte queryType;
    private QueryMix queryMix;
    private String parameterChar;
    private String[] rowNames;
    private static Map<String, Byte> parameterMapping = new HashMap<String, Byte>();
    public static final byte PRODUCT_PROPERTY_NUMERIC = 1;
    public static final byte PRODUCT_FEATURE_URI = 2;
    public static final byte PRODUCT_TYPE_URI = 3;
    public static final byte CURRENT_DATE = 4;
    public static final byte WORD_FROM_DICTIONARY1 = 5;
    public static final byte PRODUCT_URI = 6;
    public static final byte REVIEW_URI = 7;
    public static final byte COUNTRY_URI = 8;
    public static final byte OFFER_URI = 9;
    public static final byte CONSECUTIVE_MONTH = 10;
    public static final byte UPDATE_TRANSACTION_DATA = 11;
    public static final byte PRODUCER_URI = 12;
    public static final byte PRODUCT_TYPE_RANGE = 13;
    public static final byte SELECT_TYPE = 1;
    public static final byte DESCRIBE_TYPE = 2;
    public static final byte CONSTRUCT_TYPE = 3;
    public static final byte UPDATE_TYPE = 4;

    public Query(String queryString, String parameterDescription, String c) {
        this.parameterChar = c;
        this.init(queryString, parameterDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query(File queryFile, File parameterDescriptionFile, String c) {
        this.parameterChar = c;
        String queryString = "";
        String parameterDescriptionString = "";
        BufferedReader descriptionReader = null;
        BufferedReader queryReader = null;
        try {
            String line;
            queryReader = new BufferedReader(new InputStreamReader(new FileInputStream(queryFile)));
            StringBuffer sb = new StringBuffer();
            while ((line = queryReader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            queryString = sb.toString();
            descriptionReader = new BufferedReader(new InputStreamReader(new FileInputStream(parameterDescriptionFile)));
            sb = new StringBuffer();
            while ((line = descriptionReader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            parameterDescriptionString = sb.toString();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        finally {
            try {
                if (descriptionReader != null) {
                    descriptionReader.close();
                }
                if (queryReader != null) {
                    queryReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.init(queryString, parameterDescriptionString);
    }

    private void init(String queryString, String parameterDescription) {
        this.queryStrings = this.processQueryString(queryString);
        this.queryType = 1;
        if (this.queryStrings == null) {
            System.err.println("Error in Query");
            System.exit(-1);
        }
        this.processParameters(queryString, parameterDescription);
        this.parameters = new Object[this.parameterTypes.length];
    }

    private void processParameters(String queryString, String parameterDescription) {
        Vector<Byte> parameterT = new Vector<Byte>();
        Vector<Object> additionalP = new Vector<Object>();
        StringTokenizer paramTokenizer = new StringTokenizer(parameterDescription);
        HashMap<String, Integer> mapping = new HashMap<String, Integer>();
        Integer index = 0;
        while (paramTokenizer.hasMoreTokens()) {
            String line = paramTokenizer.nextToken();
            if (!line.contains("=")) continue;
            int offset = line.indexOf("=");
            String parameter = line.substring(0, offset);
            String paramType = line.substring(++offset);
            if (parameter.toLowerCase().equals("querytype")) {
                byte qType = this.getQueryType(paramType);
                if (qType == 0) {
                    System.err.println("Invalid query type chosen. Using default: Select");
                    continue;
                }
                this.queryType = qType;
                continue;
            }
            String addPI = null;
            if (paramType.contains("_")) {
                String[] paramSplit = paramType.split("_", 2);
                paramType = paramSplit[0];
                addPI = paramSplit[1];
            }
            Byte byteType = this.getParamType(paramType);
            Object additionParameterInfo = null;
            if (addPI != null) {
                additionParameterInfo = this.getAdditionParameterInfo(byteType, addPI);
            }
            if (byteType == 0) {
                System.err.println("Unknown Type: " + paramType);
                System.exit(-1);
            }
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            mapping.put(parameter, n);
            additionalP.add(additionParameterInfo);
            parameterT.add(byteType);
        }
        this.parameterTypes = new Byte[parameterT.size()];
        this.additionalParameterInfo = new Object[parameterT.size()];
        for (int i = 0; i < parameterT.size(); ++i) {
            this.parameterTypes[i] = (Byte)parameterT.elementAt(i);
            this.additionalParameterInfo[i] = additionalP.elementAt(i);
        }
        Vector paramFills = new Vector();
        int index1 = 0;
        int index2 = -1;
        while (queryString.indexOf(this.parameterChar, index2 + 1) != -1) {
            index1 = queryString.indexOf(this.parameterChar, index2 + 1);
            index2 = queryString.indexOf(this.parameterChar, index1 + 1);
            String parameter = queryString.substring(index1 + 1, index2);
            paramFills.add(mapping.get(parameter));
        }
        this.parameterFills = new Integer[paramFills.size()];
        for (int i = 0; i < paramFills.size(); ++i) {
            this.parameterFills[i] = (Integer)paramFills.elementAt(i);
        }
    }

    private Object getAdditionParameterInfo(byte type, String additionalInfo) {
        Integer[] returnValue = additionalInfo;
        if (type == 10) {
            try {
                returnValue = Integer.parseInt(additionalInfo);
            }
            catch (NumberFormatException e) {
                System.err.println("Illegal parameter for ConsecutiveMonth: " + additionalInfo);
                System.exit(-1);
            }
        } else if (type == 13) {
            try {
                Integer[] params = new Integer[3];
                String[] splitString = additionalInfo.split("_");
                if (splitString.length < 2 || splitString.length > 3) {
                    System.err.println("Illegal parameters for ProductTypeRange: " + additionalInfo);
                    System.exit(-1);
                }
                params[0] = Integer.parseInt(splitString[0]);
                params[1] = Integer.parseInt(splitString[1]);
                params[2] = splitString.length == 3 && splitString[2].equals("lvleq") ? Integer.valueOf(1) : Integer.valueOf(0);
                returnValue = params;
            }
            catch (NumberFormatException e) {
                System.err.println("Illegal parameters for ProductTypeRange: " + additionalInfo);
                System.exit(-1);
            }
        }
        return returnValue;
    }

    private byte getParamType(String stringType) {
        Byte param = parameterMapping.get(stringType);
        if (param != null) {
            return param;
        }
        return 0;
    }

    private byte getQueryType(String stringType) {
        if (stringType.toLowerCase().equals("select")) {
            return 1;
        }
        if (stringType.toLowerCase().equals("describe")) {
            return 2;
        }
        if (stringType.toLowerCase().equals("construct")) {
            return 3;
        }
        if (stringType.toLowerCase().equals("update")) {
            return 4;
        }
        return 0;
    }

    private Vector<String> processQueryString(String queryString) {
        Vector<String> queryStrings = new Vector<String>();
        int index1 = 0;
        int index2 = -1;
        while (queryString.contains(this.parameterChar)) {
            index1 = queryString.indexOf(this.parameterChar, index2 + 1);
            if (index1 == -1) {
                ++index2;
                break;
            }
            queryStrings.add(queryString.substring(index2 + 1, index1));
            index2 = queryString.indexOf(this.parameterChar, index1 + 1);
            if (index2 != -1) continue;
            return null;
        }
        if (index2 == -1) {
            ++index2;
        }
        queryStrings.add(queryString.substring(index2));
        return queryStrings;
    }

    public void setParameters(Object[] param) {
        if (this.parameters.length == param.length) {
            this.parameters = param;
        } else {
            System.err.println("Invalid parameter count.");
            System.exit(-1);
        }
    }

    public String getQueryString() {
        StringBuilder s = new StringBuilder();
        s.append(this.queryStrings.get(0));
        for (int i = 1; i < this.queryStrings.size(); ++i) {
            s.append(this.parameters[this.parameterFills[i - 1]]);
            s.append(this.queryStrings.get(i));
        }
        return s.toString();
    }

    public Byte[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Object getAdditionalParameterInfo(int indexOfParameter) {
        return this.additionalParameterInfo[indexOfParameter];
    }

    public int getNr() {
        return this.nr;
    }

    public void setNr(int nr) {
        this.nr = nr;
    }

    public Byte getQueryType() {
        return this.queryType;
    }

    public QueryMix getQueryMix() {
        return this.queryMix;
    }

    public void setQueryMix(QueryMix queryMix) {
        this.queryMix = queryMix;
    }

    public String[] getRowNames() {
        return this.rowNames;
    }

    public void setRowNames(String[] rowNames) {
        this.rowNames = rowNames;
    }

    static {
        parameterMapping.put("ProductPropertyNumericValue", (byte)1);
        parameterMapping.put("ProductFeatureURI", (byte)2);
        parameterMapping.put("ProductTypeURI", (byte)3);
        parameterMapping.put("CurrentDate", (byte)4);
        parameterMapping.put("Dictionary1", (byte)5);
        parameterMapping.put("ProductURI", (byte)6);
        parameterMapping.put("ReviewURI", (byte)7);
        parameterMapping.put("CountryURI", (byte)8);
        parameterMapping.put("OfferURI", (byte)9);
        parameterMapping.put("ConsecutiveMonth", (byte)10);
        parameterMapping.put("UpdateTransactionData", (byte)11);
        parameterMapping.put("ProducerURI", (byte)12);
        parameterMapping.put("ProductTypeRangeURI", (byte)13);
    }
}

