/*
 * Decompiled with CFR 0.152.
 */
package benchmark.testdriver;

import benchmark.testdriver.CompiledQueryMix;
import benchmark.testdriver.Query;

public class QueryMix {
    private Query[] queries;
    protected Integer[] queryMix;
    private double[] aqet;
    private double[] qmin;
    private double[] qmax;
    private double[] avgResults;
    private double[] aqetg;
    private int[] minResults;
    private int[] maxResults;
    private int[] runsPerQuery;
    private int[] timeoutsPerQuery;
    private int run;
    private int currentQueryIndex;
    private int queryMixRuns;
    private double queryMixRuntime;
    private double minQueryMixRuntime;
    private double maxQueryMixRuntime;
    private double queryMixGeoMean;
    private double totalRuntime;
    private double multiThreadRuntime;

    public double getMultiThreadRuntime() {
        return this.multiThreadRuntime;
    }

    public void setMultiThreadRuntime(double multiThreadRuntime) {
        this.multiThreadRuntime = multiThreadRuntime;
    }

    public QueryMix(Query[] queries, Integer[] queryMix) {
        int i;
        this.queries = queries;
        this.queryMix = queryMix;
        for (i = 0; i < queries.length; ++i) {
            if (queries[i] == null) continue;
            queries[i].setNr(i + 1);
            queries[i].setQueryMix(this);
        }
        i = 0;
        while (i < queryMix.length) {
            Integer[] integerArray = queryMix;
            int n = i++;
            Integer n2 = integerArray[n];
            Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] - 1);
        }
        this.init();
    }

    public void init() {
        int i;
        this.aqet = new double[this.queries.length];
        this.qmin = new double[this.queries.length];
        this.qmax = new double[this.queries.length];
        this.avgResults = new double[this.queries.length];
        this.aqetg = new double[this.queries.length];
        this.minResults = new int[this.queries.length];
        this.maxResults = new int[this.queries.length];
        this.runsPerQuery = new int[this.queries.length];
        this.timeoutsPerQuery = new int[this.queries.length];
        this.currentQueryIndex = 0;
        this.queryMixRuns = 0;
        this.queryMixRuntime = 0.0;
        this.totalRuntime = 0.0;
        this.minQueryMixRuntime = Double.MAX_VALUE;
        this.maxQueryMixRuntime = Double.MIN_VALUE;
        this.queryMixGeoMean = 0.0;
        this.run = 0;
        for (i = 0; i < this.qmax.length; ++i) {
            this.qmax[i] = Double.MIN_VALUE;
            this.maxResults[i] = Integer.MIN_VALUE;
        }
        for (i = 0; i < this.qmin.length; ++i) {
            this.qmin[i] = Double.MAX_VALUE;
            this.minResults[i] = Integer.MAX_VALUE;
        }
    }

    public synchronized void addCompiledQueryMix(CompiledQueryMix cqMix) {
        int[] cRunsPerQuery = cqMix.getRunsPerQuery();
        double[] cAqet = cqMix.getAqet();
        double[] cAvgResults = cqMix.getAvgResults();
        double[] cAqetg = cqMix.getAqetg();
        double[] cQmin = cqMix.getQmin();
        double[] cQmax = cqMix.getQmax();
        int[] cMinResults = cqMix.getMinResults();
        int[] cMaxResults = cqMix.getMaxResults();
        int[] cTimeouts = cqMix.getTimeoutsPerQuery();
        double cTotalRuntime = cqMix.getTotalRuntime();
        double cMinQueryMixRuntime = cqMix.getMinQueryMixRuntime();
        double cMaxQueryMixRuntime = cqMix.getMaxQueryMixRuntime();
        double cQueryMixGeoMean = cqMix.getQueryMixGeoMean();
        int cQueryMixRuns = cqMix.getQueryMixRuns();
        for (int i = 0; i < this.queries.length; ++i) {
            if (cRunsPerQuery[i] <= 0) continue;
            int cNrRuns = cRunsPerQuery[i];
            this.aqet[i] = (this.aqet[i] * (double)this.runsPerQuery[i] + cAqet[i] * (double)cNrRuns) / (double)(this.runsPerQuery[i] + cNrRuns);
            int n = i;
            this.aqetg[n] = this.aqetg[n] + cAqetg[i];
            this.avgResults[i] = (this.avgResults[i] * (double)this.runsPerQuery[i] + cAvgResults[i] * (double)cNrRuns) / (double)(this.runsPerQuery[i] + cNrRuns);
            int n2 = i;
            this.timeoutsPerQuery[n2] = this.timeoutsPerQuery[n2] + cTimeouts[i];
            if (cQmin[i] < this.qmin[i]) {
                this.qmin[i] = cQmin[i];
            }
            if (cQmax[i] > this.qmax[i]) {
                this.qmax[i] = cQmax[i];
            }
            if (cMinResults[i] < this.minResults[i]) {
                this.minResults[i] = cMinResults[i];
            }
            if (cMaxResults[i] > this.maxResults[i]) {
                this.maxResults[i] = cMaxResults[i];
            }
            int n3 = i;
            this.runsPerQuery[n3] = this.runsPerQuery[n3] + cNrRuns;
        }
        this.totalRuntime += cTotalRuntime;
        this.queryMixGeoMean += cQueryMixGeoMean;
        this.queryMixRuns += cQueryMixRuns;
        if (cMinQueryMixRuntime < this.minQueryMixRuntime) {
            this.minQueryMixRuntime = cMinQueryMixRuntime;
        }
        if (cMaxQueryMixRuntime > this.maxQueryMixRuntime) {
            this.maxQueryMixRuntime = cMaxQueryMixRuntime;
        }
    }

    public void setRun(int run) {
        this.run = run;
    }

    public void finishRun() {
        this.currentQueryIndex = 0;
        if (this.run >= 0) {
            ++this.queryMixRuns;
            if (this.queryMixRuntime < this.minQueryMixRuntime) {
                this.minQueryMixRuntime = this.queryMixRuntime;
            }
            if (this.queryMixRuntime > this.maxQueryMixRuntime) {
                this.maxQueryMixRuntime = this.queryMixRuntime;
            }
            this.queryMixGeoMean += Math.log10(this.queryMixRuntime);
            this.totalRuntime += this.queryMixRuntime;
        }
        this.queryMixRuntime = 0.0;
    }

    public void reportTimeOut() {
        if (this.run >= 0) {
            int queryNr;
            int n = queryNr = this.queryMix[this.currentQueryIndex].intValue();
            this.timeoutsPerQuery[n] = this.timeoutsPerQuery[n] + 1;
        }
    }

    public Query getNext() {
        return this.queries[this.queryMix[this.currentQueryIndex]];
    }

    public Boolean hasNext() {
        return this.currentQueryIndex < this.queryMix.length;
    }

    public void setCurrent(int numberResults, Double timeInSeconds) {
        if (this.run >= 0 && timeInSeconds >= 0.0) {
            int queryNr;
            int n = queryNr = this.queryMix[this.currentQueryIndex].intValue();
            int n2 = this.runsPerQuery[n];
            this.runsPerQuery[n] = n2 + 1;
            int nrRuns = n2;
            this.aqet[queryNr] = (this.aqet[queryNr] * (double)nrRuns + timeInSeconds) / (double)(nrRuns + 1);
            this.avgResults[queryNr] = (this.avgResults[queryNr] * (double)nrRuns + (double)numberResults) / (double)(nrRuns + 1);
            int n3 = queryNr;
            this.aqetg[n3] = this.aqetg[n3] + Math.log10(timeInSeconds);
            if (timeInSeconds < this.qmin[queryNr]) {
                this.qmin[queryNr] = timeInSeconds;
            }
            if (timeInSeconds > this.qmax[queryNr]) {
                this.qmax[queryNr] = timeInSeconds;
            }
            if (numberResults < this.minResults[queryNr]) {
                this.minResults[queryNr] = numberResults;
            }
            if (numberResults > this.maxResults[queryNr]) {
                this.maxResults[queryNr] = numberResults;
            }
            this.queryMixRuntime += timeInSeconds.doubleValue();
        }
        ++this.currentQueryIndex;
    }

    public Query[] getQueries() {
        return this.queries;
    }

    public Integer[] getQueryMix() {
        return this.queryMix;
    }

    public double[] getAqet() {
        return this.aqet;
    }

    public double[] getQmin() {
        return this.qmin;
    }

    public double[] getQmax() {
        return this.qmax;
    }

    public int[] getRunsPerQuery() {
        return this.runsPerQuery;
    }

    public int getQueryMixRuns() {
        return this.queryMixRuns;
    }

    public double getQmph() {
        return 3600.0 / (this.totalRuntime / (double)this.queryMixRuns);
    }

    public double getMultiThreadQmpH() {
        return 3600.0 / (this.multiThreadRuntime / (double)this.queryMixRuns);
    }

    public double getQueryMixRuntime() {
        return this.queryMixRuntime;
    }

    public double getTotalRuntime() {
        return this.totalRuntime;
    }

    public double getCQET() {
        return this.totalRuntime / (double)this.queryMixRuns;
    }

    public double getMinQueryMixRuntime() {
        return this.minQueryMixRuntime;
    }

    public double getMaxQueryMixRuntime() {
        return this.maxQueryMixRuntime;
    }

    public void setQueryMixRuntime(double queryMixRuntime) {
        this.queryMixRuntime = queryMixRuntime;
    }

    public int getRun() {
        return this.run;
    }

    public double[] getAvgResults() {
        return this.avgResults;
    }

    public int[] getMinResults() {
        return this.minResults;
    }

    public int[] getMaxResults() {
        return this.maxResults;
    }

    public double[] getGeoMean() {
        double[] temp = new double[this.aqetg.length];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = Math.pow(10.0, this.aqetg[i] / (double)this.runsPerQuery[i]);
        }
        return temp;
    }

    public double getQueryMixGeometricMean() {
        return Math.pow(10.0, this.queryMixGeoMean / (double)this.queryMixRuns);
    }

    public int[] getTimeoutsPerQuery() {
        return this.timeoutsPerQuery;
    }
}

