/*
 * Decompiled with CFR 0.152.
 */
package benchmark.testdriver;

import benchmark.qualification.QueryResult;
import benchmark.testdriver.CompiledQuery;
import benchmark.testdriver.CompiledQueryMix;
import benchmark.testdriver.NetQuery;
import benchmark.testdriver.Query;
import benchmark.testdriver.QueryMix;
import benchmark.testdriver.ServerConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SPARQLConnection
implements ServerConnection {
    private String serviceURL;
    private String updateServiceURL;
    private String defaultGraph;
    private static Logger logger = Logger.getLogger(SPARQLConnection.class);
    private int timeout;

    public SPARQLConnection(String serviceURL, String defaultGraph, int timeout) {
        this.serviceURL = serviceURL;
        this.defaultGraph = defaultGraph;
        this.timeout = timeout;
    }

    public SPARQLConnection(String serviceURL, String updateServiceURL, String defaultGraph, int timeout) {
        this.updateServiceURL = updateServiceURL;
        this.serviceURL = serviceURL;
        this.defaultGraph = defaultGraph;
        this.timeout = timeout;
    }

    @Override
    public void executeQuery(Query query, byte queryType) {
        this.executeQuery(query.getQueryString(), queryType, query.getNr(), query.getQueryMix());
    }

    private void executeQuery(String queryString, byte queryType, int queryNr, QueryMix queryMix) {
        NetQuery qe = queryType == 4 ? new NetQuery(this.updateServiceURL, queryString, queryType, this.defaultGraph, this.timeout) : new NetQuery(this.serviceURL, queryString, queryType, this.defaultGraph, this.timeout);
        int queryMixRun = queryMix.getRun() + 1;
        InputStream is = qe.exec();
        if (is == null) {
            double t = (double)this.timeout / 1000.0;
            System.out.println("Query " + queryNr + ": " + t + " seconds timeout!");
            queryMix.reportTimeOut();
            queryMix.setCurrent(0, t);
            qe.close();
            return;
        }
        int resultCount = 0;
        try {
            resultCount = queryType == 1 ? this.countResults(is) : this.countBytes(is);
        }
        catch (SocketTimeoutException e) {
            double t = (double)this.timeout / 1000.0;
            System.out.println("Query " + queryNr + ": " + t + " seconds timeout!");
            queryMix.reportTimeOut();
            queryMix.setCurrent(0, t);
            qe.close();
            return;
        }
        double timeInSeconds = qe.getExecutionTimeInSeconds();
        if (logger.isEnabledFor((Priority)Level.ALL) && queryMixRun > 0) {
            this.logResultInfo(queryNr, queryMixRun, timeInSeconds, queryString, queryType, resultCount);
        }
        queryMix.setCurrent(resultCount, timeInSeconds);
        qe.close();
    }

    @Override
    public void executeQuery(CompiledQuery query, CompiledQueryMix queryMix) {
        double timeInSeconds;
        String queryString = query.getQueryString();
        byte queryType = query.getQueryType();
        int queryNr = query.getNr();
        NetQuery qe = query.getQueryType() == 4 ? new NetQuery(this.updateServiceURL, queryString, queryType, this.defaultGraph, this.timeout) : new NetQuery(this.serviceURL, queryString, queryType, this.defaultGraph, this.timeout);
        int queryMixRun = queryMix.getRun() + 1;
        InputStream is = qe.exec();
        if (is == null) {
            double t = (double)this.timeout / 1000.0;
            System.out.println("Query " + queryNr + ": " + t + " seconds timeout!");
            queryMix.reportTimeOut();
            queryMix.setCurrent(0, t);
            qe.close();
            return;
        }
        int resultCount = 0;
        try {
            resultCount = queryType == 1 ? this.countResults(is) : this.countBytes(is);
            timeInSeconds = qe.getExecutionTimeInSeconds();
        }
        catch (SocketTimeoutException e) {
            double t = (double)this.timeout / 1000.0;
            System.out.println("Query " + queryNr + ": " + t + " seconds timeout!");
            queryMix.reportTimeOut();
            queryMix.setCurrent(0, t);
            qe.close();
            return;
        }
        if (logger.isEnabledFor((Priority)Level.ALL) && queryMixRun > 0) {
            this.logResultInfo(queryNr, queryMixRun, timeInSeconds, queryString, queryType, resultCount);
        }
        queryMix.setCurrent(resultCount, timeInSeconds);
        qe.close();
    }

    private int countBytes(InputStream is) {
        int nrBytes = 0;
        byte[] buf = new byte[10000];
        int len = 0;
        try {
            while ((len = is.read(buf)) != -1) {
                nrBytes += len;
            }
        }
        catch (IOException e) {
            System.err.println("Could not read result from input stream");
        }
        return nrBytes;
    }

    private void logResultInfo(int queryNr, int queryMixRun, double timeInSeconds, String queryString, byte queryType, int resultCount) {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("\n\n\tQuery " + queryNr + " of run " + queryMixRun + " has been executed ");
        sb.append("in " + String.format("%.6f", timeInSeconds) + " seconds.\n");
        sb.append("\n\tQuery string:\n\n");
        sb.append(queryString);
        sb.append("\n\n");
        if (queryType == 2) {
            sb.append("\tQuery(Describe) result (" + resultCount + " Bytes): \n\n");
        } else if (queryType == 3) {
            sb.append("\tQuery(Construct) result (" + resultCount + " Bytes): \n\n");
        } else {
            sb.append("\tQuery results (" + resultCount + " results): \n\n");
        }
        sb.append("\n__________________________________________________________________________________\n");
        logger.log((Priority)Level.ALL, (Object)sb.toString());
    }

    private int countResults(InputStream s) throws SocketTimeoutException {
        ResultHandler handler = new ResultHandler();
        int count = 0;
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(s, (DefaultHandler)handler);
            count = handler.getCount();
        }
        catch (SocketTimeoutException e) {
            throw new SocketTimeoutException();
        }
        catch (Exception e) {
            System.err.println("SAX Error");
            e.printStackTrace();
            return -1;
        }
        return count;
    }

    @Override
    public void close() {
    }

    @Override
    public QueryResult executeValidation(Query query, byte queryType) {
        String queryString = query.getQueryString();
        int queryNr = query.getNr();
        String[] rowNames = query.getRowNames();
        boolean sorted = queryString.toLowerCase().contains("order by");
        QueryResult queryResult = null;
        NetQuery qe = queryType == 4 ? new NetQuery(this.updateServiceURL, queryString, queryType, this.defaultGraph, 0) : new NetQuery(this.serviceURL, queryString, queryType, this.defaultGraph, 0);
        InputStream is = qe.exec();
        if (queryType != 4) {
            Document doc = this.getXMLDocument(is);
            XMLOutputter outputter = new XMLOutputter();
            this.logResultInfo(query, outputter.outputString(doc));
            if (queryType == 1) {
                queryResult = this.gatherResultInfoForSelectQuery(queryString, queryNr, sorted, doc, rowNames);
            }
        } else {
            this.logResultInfo(query, "");
        }
        if (queryResult != null) {
            queryResult.setRun(query.getQueryMix().getRun());
        }
        return queryResult;
    }

    private void logResultInfo(Query query, String queryResult) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n\n\tQuery " + query.getNr() + " of run " + (query.getQueryMix().getQueryMixRuns() + 1) + ":\n");
        sb.append("\n\tQuery string:\n\n");
        sb.append(query.getQueryString());
        sb.append("\n\n\tResult:\n\n");
        sb.append(queryResult);
        sb.append("\n\n__________________________________________________________________________________\n");
        logger.log((Priority)Level.ALL, (Object)sb.toString());
    }

    private Document getXMLDocument(InputStream is) {
        SAXBuilder builder = new SAXBuilder();
        builder.setValidation(false);
        builder.setIgnoringElementContentWhitespace(true);
        Document doc = null;
        try {
            doc = builder.build(is);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return doc;
    }

    private QueryResult gatherResultInfoForSelectQuery(String queryString, int queryNr, boolean sorted, Document doc, String[] rows) {
        Element root = doc.getRootElement();
        Element child = root.getChild("head", Namespace.getNamespace((String)"http://www.w3.org/2005/sparql-results#"));
        List headChildren = child.getChildren("variable", Namespace.getNamespace((String)"http://www.w3.org/2005/sparql-results#"));
        Iterator it = headChildren.iterator();
        ArrayList<String> headList = new ArrayList<String>();
        while (it.hasNext()) {
            headList.add(((Element)it.next()).getAttributeValue("name"));
        }
        List resultChildren = root.getChild("results", Namespace.getNamespace((String)"http://www.w3.org/2005/sparql-results#")).getChildren("result", Namespace.getNamespace((String)"http://www.w3.org/2005/sparql-results#"));
        int nrResults = resultChildren.size();
        QueryResult queryResult = new QueryResult(queryNr, queryString, nrResults, sorted, headList);
        for (Element resultElement : resultChildren) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < rows.length; ++i) {
                List bindings = resultElement.getChildren("binding", Namespace.getNamespace((String)"http://www.w3.org/2005/sparql-results#"));
                String rowName = rows[i];
                for (int j = 0; j < bindings.size(); ++j) {
                    Element binding = (Element)bindings.get(j);
                    if (!binding.getAttributeValue("name").equals(rowName)) continue;
                    if (result.length() == 0) {
                        result.append(rowName + ": " + ((Element)binding.getChildren().get(0)).getTextNormalize());
                        continue;
                    }
                    result.append("\n" + rowName + ": " + ((Element)binding.getChildren().get(0)).getTextNormalize());
                }
            }
            queryResult.addResult(result.toString());
        }
        return queryResult;
    }

    private static class ResultHandler
    extends DefaultHandler {
        private int count = 0;

        ResultHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
            if (qName.equals("result")) {
                ++this.count;
            }
        }

        public int getCount() {
            return this.count;
        }
    }
}

