/*
 * Decompiled with CFR 0.152.
 */
package benchmark.testdriver;

import benchmark.qualification.QueryResult;
import benchmark.testdriver.CompiledQuery;
import benchmark.testdriver.CompiledQueryMix;
import benchmark.testdriver.Query;
import benchmark.testdriver.QueryMix;
import benchmark.testdriver.ServerConnection;
import benchmark.testdriver.TestDriverDefaultValues;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SQLConnection
implements ServerConnection {
    private Statement statement;
    private Connection conn;
    private static Logger logger = Logger.getLogger(SQLConnection.class);

    public SQLConnection(String serviceURL, int timeout, String driverClassName) {
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            this.conn = DriverManager.getConnection(serviceURL);
            this.statement = this.conn.createStatement();
            this.statement.setQueryTimeout(timeout / 1000);
            this.statement.setFetchSize(TestDriverDefaultValues.fetchSize);
        }
        catch (SQLException e) {
            while (e != null) {
                e.printStackTrace();
                e = e.getNextException();
            }
            System.exit(-1);
        }
    }

    @Override
    public void executeQuery(Query query, byte queryType) {
        this.executeQuery(query.getQueryString(), queryType, query.getNr(), query.getQueryMix());
    }

    private void executeQuery(String queryString, byte queryType, int queryNr, QueryMix queryMix) {
        try {
            long start = System.nanoTime();
            ResultSet results = this.statement.executeQuery(queryString);
            int resultCount = 0;
            while (results.next()) {
                ++resultCount;
            }
            Long stop = System.nanoTime();
            Long interval = stop - start;
            double timeInSeconds = interval.doubleValue() / 1.0E9;
            int queryMixRun = queryMix.getRun() + 1;
            if (logger.isEnabledFor((Priority)Level.ALL) && queryType != 3 && queryMixRun > 0) {
                this.logResultInfo(queryNr, queryMixRun, timeInSeconds, queryString, queryType, 0, resultCount);
            }
            queryMix.setCurrent(resultCount, timeInSeconds);
            results.close();
        }
        catch (SQLException e) {
            while (e != null) {
                e.printStackTrace();
                e = e.getNextException();
            }
            System.err.println("\n\nError for Query " + queryNr + ":\n\n" + queryString);
            System.exit(-1);
        }
    }

    @Override
    public void executeQuery(CompiledQuery query, CompiledQueryMix queryMix) {
        String queryString = query.getQueryString();
        byte queryType = query.getQueryType();
        int queryNr = query.getNr();
        try {
            long start = System.nanoTime();
            ResultSet results = this.statement.executeQuery(queryString);
            int resultCount = 0;
            while (results.next()) {
                ++resultCount;
            }
            Long stop = System.nanoTime();
            Long interval = stop - start;
            double timeInSeconds = interval.doubleValue() / 1.0E9;
            int queryMixRun = queryMix.getRun() + 1;
            if (logger.isEnabledFor((Priority)Level.ALL) && queryType != 3 && queryMixRun > 0) {
                this.logResultInfo(queryNr, queryMixRun, timeInSeconds, queryString, queryType, 0, resultCount);
            }
            queryMix.setCurrent(resultCount, timeInSeconds);
            results.close();
        }
        catch (SQLException e) {
            while (e != null) {
                e.printStackTrace();
                e = e.getNextException();
            }
            System.err.println("\n\nError for Query " + queryNr + ":\n\n" + queryString);
            System.exit(-1);
        }
    }

    private void logResultInfo(int queryNr, int queryMixRun, double timeInSeconds, String queryString, byte queryType, int resultSizeInBytes, int resultCount) {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("\n\n\tQuery " + queryNr + " of run " + queryMixRun + " has been executed ");
        sb.append("in " + String.format("%.6f", timeInSeconds) + " seconds.\n");
        sb.append("\n\tQuery string:\n\n");
        sb.append(queryString);
        sb.append("\n\n");
        if (queryType == 2) {
            sb.append("\tQuery(Describe) result (" + resultSizeInBytes + " Bytes): \n\n");
        } else {
            sb.append("\tQuery results (" + resultCount + " results): \n\n");
        }
        sb.append("\n__________________________________________________________________________________\n");
        logger.log((Priority)Level.ALL, (Object)sb.toString());
    }

    @Override
    public void close() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public QueryResult executeValidation(Query query, byte queryType) {
        return null;
    }
}

