/*
 * Decompiled with CFR 0.152.
 */
package benchmark.testdriver;

import benchmark.generator.DateGenerator;
import benchmark.model.ProductType;
import benchmark.testdriver.AbstractParameterPool;
import benchmark.testdriver.ParameterGenerator;
import benchmark.testdriver.Query;
import java.io.File;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

public class SQLParameterPool
extends AbstractParameterPool {
    public SQLParameterPool(File resourceDirectory, Long seed) {
        this.init(resourceDirectory, seed);
    }

    @Override
    public Object[] getParametersForQuery(Query query) {
        Byte[] parameterTypes = query.getParameterTypes();
        Object[] parameters = new Object[parameterTypes.length];
        ArrayList<Integer> productFeatureIndices = new ArrayList<Integer>();
        ProductType pt = null;
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] == 3) {
                pt = this.getRandomProductType();
                parameters[i] = pt.getNr();
                continue;
            }
            if (parameterTypes[i] == 2) {
                productFeatureIndices.add(i);
                continue;
            }
            parameters[i] = parameterTypes[i] == 1 ? this.getProductPropertyNumeric() : (parameterTypes[i] == 6 ? this.getRandomProductURI() : (parameterTypes[i] == 4 ? this.currentDateString : (parameterTypes[i] == 8 ? this.countryGen.getRandom() : (parameterTypes[i] == 7 ? this.getRandomReviewURI() : (parameterTypes[i] == 5 ? this.getRandomWord() : (parameterTypes[i] == 9 ? this.getRandomOfferURI() : null))))));
        }
        if (productFeatureIndices.size() > 0 && pt == null) {
            System.err.println("Error in parameter generation: Asked for product features without product type.");
            System.exit(-1);
        }
        Integer[] productFeatures = this.getRandomProductFeatures(pt, productFeatureIndices.size());
        for (int i = 0; i < productFeatureIndices.size(); ++i) {
            parameters[((Integer)productFeatureIndices.get((int)i)).intValue()] = productFeatures[i];
        }
        return parameters;
    }

    private Integer[] getRandomProductFeatures(ProductType pt, Integer number) {
        Integer[] productFeatures = new Integer[number.intValue()];
        List<Integer> pfs = ParameterGenerator.getRandomProductFeatures(pt, number);
        for (int i = 0; i < number; ++i) {
            Integer index = this.valueGen.randomInt(0, pfs.size() - 1);
            productFeatures[i] = pfs.get(index);
            pfs.remove(index);
        }
        return productFeatures;
    }

    private ProductType getRandomProductType() {
        Integer index = this.valueGen.randomInt(0, this.productTypeLeaves.length - 1);
        return this.productTypeLeaves[index];
    }

    private Integer getRandomProductURI() {
        return this.valueGen.randomInt(1, this.productCount);
    }

    private Integer getRandomOfferURI() {
        return this.valueGen.randomInt(1, this.offerCount);
    }

    private Integer getRandomReviewURI() {
        return this.valueGen.randomInt(1, this.reviewCount);
    }

    @Override
    protected String formatDateString(GregorianCalendar date) {
        return DateGenerator.formatDate(this.currentDate);
    }
}

