/*
 * Decompiled with CFR 0.152.
 */
package benchmark.testdriver;

import benchmark.qualification.QueryResult;
import benchmark.testdriver.AbstractParameterPool;
import benchmark.testdriver.ClientManager;
import benchmark.testdriver.LocalSPARQLParameterPool;
import benchmark.testdriver.Query;
import benchmark.testdriver.QueryMix;
import benchmark.testdriver.SPARQLConnection;
import benchmark.testdriver.SQLConnection;
import benchmark.testdriver.SQLParameterPool;
import benchmark.testdriver.ServerConnection;
import benchmark.testdriver.TestDriverDefaultValues;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.xml.DOMConfigurator;

public class TestDriver {
    protected QueryMix queryMix;
    protected int warmups = TestDriverDefaultValues.warmups;
    protected AbstractParameterPool parameterPool;
    protected ServerConnection server;
    protected File usecaseFile = TestDriverDefaultValues.usecaseFile;
    protected int nrRuns = TestDriverDefaultValues.nrRuns;
    protected long seed = TestDriverDefaultValues.seed;
    protected String sparqlEndpoint = null;
    protected String sparqlUpdateEndpoint = null;
    protected static String sparqlUpdateQueryParameter = TestDriverDefaultValues.updateQueryParameter;
    protected String defaultGraph = TestDriverDefaultValues.defaultGraph;
    protected String resourceDir = TestDriverDefaultValues.resourceDir;
    protected String xmlResultFile = TestDriverDefaultValues.xmlResultFile;
    protected static Logger logger = Logger.getLogger(TestDriver.class);
    protected String updateFile = null;
    protected boolean[] ignoreQueries;
    protected boolean doSQL = false;
    protected boolean multithreading = false;
    protected int nrThreads;
    protected int timeout = TestDriverDefaultValues.timeoutInMs;
    protected String driverClassName = TestDriverDefaultValues.driverClassName;
    protected boolean qualification = TestDriverDefaultValues.qualification;
    protected String qualificationFile = TestDriverDefaultValues.qualificationFile;
    protected int qmsPerPeriod = TestDriverDefaultValues.qmsPerPeriod;
    protected double percentDifference = TestDriverDefaultValues.percentDifference;
    protected int nrOfPeriods = TestDriverDefaultValues.nrOfPeriods;
    protected boolean rampup = false;

    public TestDriver(String[] args) {
        this.processProgramParameters(args);
        System.out.print("Reading Test Driver data...");
        System.out.flush();
        this.parameterPool = this.doSQL ? new SQLParameterPool(new File(this.resourceDir), this.seed) : (this.updateFile == null ? new LocalSPARQLParameterPool(new File(this.resourceDir), this.seed) : new LocalSPARQLParameterPool(new File(this.resourceDir), this.seed, new File(this.updateFile)));
        System.out.println("done");
        if (this.sparqlEndpoint != null && !this.multithreading) {
            this.server = this.doSQL ? new SQLConnection(this.sparqlEndpoint, this.timeout, this.driverClassName) : new SPARQLConnection(this.sparqlEndpoint, this.sparqlUpdateEndpoint, this.defaultGraph, this.timeout);
        } else if (!this.multithreading) {
            this.printUsageInfos();
            System.exit(-1);
        }
        TestDriverShutdown tds = new TestDriverShutdown(this);
        Runtime.getRuntime().addShutdownHook(tds);
    }

    private List<String> getUseCaseQuerymixes() {
        ArrayList<String> files = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.usecaseFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] querymixInfo = line.split("=");
                if (querymixInfo.length != 2) {
                    System.err.println("Invalid entry in use case file " + this.usecaseFile + ":\n");
                    System.err.println(line);
                    System.exit(-1);
                }
                if (!querymixInfo[0].toLowerCase().equals("querymix")) continue;
                files.add(querymixInfo[1]);
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        return files;
    }

    private List<Integer[]> getQuerymixRuns(List<String> querymixDirs) {
        ArrayList<Integer[]> runs = new ArrayList<Integer[]>();
        for (String querymixDir : querymixDirs) {
            runs.add(this.getQueryMixInfo(new File(querymixDir, "querymix.txt")));
        }
        return runs;
    }

    private List<Integer> getMaxQueryNrs(List<Integer[]> querymixRuns) {
        ArrayList<Integer> maxNrs = new ArrayList<Integer>();
        for (Integer[] run : querymixRuns) {
            Integer maxQueryNr = 0;
            for (int i = 0; i < run.length; ++i) {
                if (run[i] == null || run[i] <= maxQueryNr) continue;
                maxQueryNr = run[i];
            }
            maxNrs.add(maxQueryNr);
        }
        return maxNrs;
    }

    private List<boolean[]> getIgnoredQueries(List<String> querymixDirs, List<Integer> maxQueryNrs) {
        ArrayList<boolean[]> ignoredQueries = new ArrayList<boolean[]>();
        Iterator<String> queryMixDirIterator = querymixDirs.iterator();
        Iterator<Integer> maxQueryNrIterator = maxQueryNrs.iterator();
        while (queryMixDirIterator.hasNext()) {
            File ignoreFile = new File(queryMixDirIterator.next(), "ignoreQueries.txt");
            int maxQueryNr = maxQueryNrIterator.next();
            boolean[] ignoreQueries = new boolean[maxQueryNr];
            if (!ignoreFile.exists()) {
                for (int i = 0; i < ignoreQueries.length; ++i) {
                    ignoreQueries[i] = false;
                }
            } else {
                ignoreQueries = this.getIgnoreQueryInfo(ignoreFile, maxQueryNr);
            }
            ignoredQueries.add(ignoreQueries);
        }
        return ignoredQueries;
    }

    private List<Query[]> getQueries(List<String> querymixDirs, List<Integer[]> queryRuns, List<Integer> maxQueryNrs) {
        ArrayList<Query[]> allQueries = new ArrayList<Query[]>();
        Iterator<String> queryMixDirIterator = querymixDirs.iterator();
        Iterator<Integer[]> queryRunIterator = queryRuns.iterator();
        Iterator<Integer> maxQueryNrIterator = maxQueryNrs.iterator();
        while (queryMixDirIterator.hasNext()) {
            Integer[] queryRun = queryRunIterator.next();
            String queryDir = queryMixDirIterator.next();
            Query[] queries = new Query[maxQueryNrIterator.next().intValue()];
            for (int i = 0; i < queryRun.length; ++i) {
                Integer qnr;
                if (queryRun[i] == null || queries[(qnr = queryRun[i]) - 1] != null) continue;
                File queryFile = new File(queryDir, "query" + qnr + ".txt");
                File queryDescFile = new File(queryDir, "query" + qnr + "desc.txt");
                queries[qnr.intValue() - 1] = this.doSQL ? new Query(queryFile, queryDescFile, "@") : new Query(queryFile, queryDescFile, "%");
                if (!this.qualification) continue;
                File queryValidFile = new File(queryDir, "query" + qnr + "valid.txt");
                String[] rowNames = this.getRowNames(queryValidFile);
                queries[qnr - 1].setRowNames(rowNames);
            }
            allQueries.add(queries);
        }
        return allQueries;
    }

    public void init() {
        Query[] queries = null;
        Integer[] queryRun = null;
        List<String> querymixDirs = this.getUseCaseQuerymixes();
        List<Integer[]> queryRuns = this.getQuerymixRuns(querymixDirs);
        List<Integer> maxQueryPerRun = this.getMaxQueryNrs(queryRuns);
        List<boolean[]> ignoreQueries = this.getIgnoredQueries(querymixDirs, maxQueryPerRun);
        List<Query[]> queriesOfQuerymixes = this.getQueries(querymixDirs, queryRuns, maxQueryPerRun);
        queries = this.setupQueries(maxQueryPerRun, queriesOfQuerymixes);
        this.ignoreQueries = this.setupIgnoreQueries(maxQueryPerRun, ignoreQueries);
        queryRun = this.setupQueryRun(maxQueryPerRun, queryRuns);
        this.queryMix = new QueryMix(queries, queryRun);
    }

    private Integer[] setupQueryRun(List<Integer> maxQueryPerRun, List<Integer[]> queryRuns) {
        int nrOfQueriesInRun = 0;
        for (Integer[] qr : queryRuns) {
            nrOfQueriesInRun += qr.length;
        }
        Integer[] queryRun = new Integer[nrOfQueriesInRun];
        int indexOffset = 0;
        int queryOffset = 0;
        Iterator<Integer> maxQueryNrIterator = maxQueryPerRun.iterator();
        for (Integer[] qr : queryRuns) {
            int queryIndex = 0;
            for (Integer queryNr : qr) {
                queryRun[indexOffset + queryIndex] = queryNr + queryOffset;
                ++queryIndex;
            }
            indexOffset += qr.length;
            queryOffset += maxQueryNrIterator.next().intValue();
        }
        return queryRun;
    }

    private boolean[] setupIgnoreQueries(List<Integer> maxQueryPerRun, List<boolean[]> ignoreQueriesOfQuerymixes) {
        int nrOfQueries = 0;
        for (int i : maxQueryPerRun) {
            nrOfQueries += i;
        }
        boolean[] ignoreQueries = new boolean[nrOfQueries];
        int queryOffset = 0;
        Iterator<Integer> maxQueryNrIterator = maxQueryPerRun.iterator();
        for (boolean[] iqs : ignoreQueriesOfQuerymixes) {
            int queryIndex = 0;
            boolean[] arr$ = iqs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                boolean igQuery;
                ignoreQueries[queryOffset + queryIndex] = igQuery = arr$[i$];
                ++queryIndex;
            }
            queryOffset += maxQueryNrIterator.next().intValue();
        }
        return ignoreQueries;
    }

    private Query[] setupQueries(List<Integer> maxQueryPerRun, List<Query[]> queriesOfQuerymixes) {
        int nrOfQueries = 0;
        for (int i : maxQueryPerRun) {
            nrOfQueries += i;
        }
        Query[] queries = new Query[nrOfQueries];
        for (int i = 0; i < queries.length; ++i) {
            queries[i] = null;
        }
        int queryOffset = 0;
        Iterator<Integer> maxQueryNrIterator = maxQueryPerRun.iterator();
        for (Query[] qs : queriesOfQuerymixes) {
            int queryIndex = 0;
            Query[] arr$ = qs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Query query;
                queries[queryOffset + queryIndex] = query = arr$[i$];
                ++queryIndex;
            }
            queryOffset += maxQueryNrIterator.next().intValue();
        }
        return queries;
    }

    private String[] getRowNames(File file) {
        ArrayList<String> rowNames = new ArrayList<String>();
        try {
            BufferedReader rowReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            StringBuffer data = new StringBuffer();
            String line = null;
            while ((line = rowReader.readLine()) != null) {
                if (line.equals("")) continue;
                data.append(line);
                data.append(" ");
            }
            StringTokenizer st = new StringTokenizer(data.toString());
            while (st.hasMoreTokens()) {
                rowNames.add(st.nextToken());
            }
            rowReader.close();
        }
        catch (IOException e) {
            System.err.println("Error processing query qualification-info file: " + file.getAbsolutePath());
            System.exit(-1);
        }
        return rowNames.toArray(new String[1]);
    }

    private Integer[] getQueryMixInfo(File file) {
        System.out.println("Reading query mix file: " + file);
        ArrayList<Integer> qm = new ArrayList<Integer>();
        try {
            BufferedReader qmReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            StringBuffer data = new StringBuffer();
            String line = null;
            while ((line = qmReader.readLine()) != null) {
                if (line.equals("")) continue;
                data.append(line);
                data.append(" ");
            }
            StringTokenizer st = new StringTokenizer(data.toString());
            while (st.hasMoreTokens()) {
                qm.add(Integer.parseInt(st.nextToken()));
            }
            qmReader.close();
        }
        catch (IOException e) {
            System.err.println("Error processing query mix file: " + file);
            System.exit(-1);
        }
        return qm.toArray(new Integer[1]);
    }

    private boolean[] getIgnoreQueryInfo(File file, int maxQueryNumber) {
        System.out.println("Reading query ignore file: " + file);
        boolean[] ignoreQueries = new boolean[maxQueryNumber];
        for (int i = 0; i < maxQueryNumber; ++i) {
            ignoreQueries[i] = false;
        }
        try {
            BufferedReader qmReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            StringBuffer data = new StringBuffer();
            String line = null;
            while ((line = qmReader.readLine()) != null) {
                if (line.equals("")) continue;
                data.append(line);
                data.append(" ");
            }
            StringTokenizer st = new StringTokenizer(data.toString());
            while (st.hasMoreTokens()) {
                Integer queryNr = Integer.parseInt(st.nextToken());
                if (queryNr <= 0 || queryNr > maxQueryNumber) continue;
                ignoreQueries[queryNr.intValue() - 1] = true;
            }
            qmReader.close();
        }
        catch (IOException e) {
            System.err.println("Error processing query ignore file: " + file);
            System.exit(-1);
        }
        return ignoreQueries;
    }

    public void run() {
        int qmsPerPeriod = TestDriverDefaultValues.qmsPerPeriod;
        int qmsCounter = 0;
        int periodCounter = 0;
        double periodRuntime = 0.0;
        BufferedWriter measurementFile = null;
        try {
            measurementFile = new BufferedWriter(new FileWriter("steadystate.tsv"));
        }
        catch (IOException e) {
            System.err.println("Could not create file steadystate.tsv!");
            System.exit(-1);
        }
        for (int nrRun = -this.warmups; nrRun < this.nrRuns; ++nrRun) {
            long startTime = System.currentTimeMillis();
            this.queryMix.setRun(nrRun);
            while (this.queryMix.hasNext().booleanValue()) {
                Query next = this.queryMix.getNext();
                if (nrRun < 0 && next.getQueryType() == 4) {
                    this.queryMix.setCurrent(0, -1.0);
                    continue;
                }
                Object[] queryParameters = this.parameterPool.getParametersForQuery(next);
                next.setParameters(queryParameters);
                if (this.ignoreQueries[next.getNr() - 1]) {
                    this.queryMix.setCurrent(0, -1.0);
                    continue;
                }
                this.server.executeQuery(next, next.getQueryType());
            }
            if (nrRun >= 0) {
                ++qmsCounter;
                periodRuntime += this.queryMix.getQueryMixRuntime();
            }
            if (qmsCounter == qmsPerPeriod) {
                ++periodCounter;
                try {
                    measurementFile.append(periodCounter + "\t" + periodRuntime + "\n");
                    measurementFile.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
                periodRuntime = 0.0;
                qmsCounter = 0;
            }
            System.out.println(nrRun + ": " + String.format(Locale.US, "%.2f", this.queryMix.getQueryMixRuntime() * 1000.0) + "ms, total: " + (System.currentTimeMillis() - startTime) + "ms");
            this.queryMix.finishRun();
        }
        logger.log((Priority)Level.ALL, (Object)this.printResults(true));
        try {
            FileWriter resultWriter = new FileWriter(this.xmlResultFile);
            resultWriter.append(this.printXMLResults(true));
            resultWriter.flush();
            resultWriter.close();
            measurementFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void runQualification() {
        File file = new File(this.qualificationFile);
        System.out.println("Creating qualification file: " + file.getAbsolutePath() + "\n");
        try {
            file.createNewFile();
            ObjectOutputStream objectOutput = new ObjectOutputStream(new FileOutputStream(file, false));
            objectOutput.writeInt(this.queryMix.getQueries().length);
            objectOutput.writeLong(this.seed);
            objectOutput.writeInt(this.parameterPool.getScalefactor());
            objectOutput.writeInt(this.nrRuns);
            objectOutput.writeObject(this.queryMix.getQueryMix());
            objectOutput.writeObject(this.ignoreQueries);
            for (int nrRun = 0; nrRun < this.nrRuns; ++nrRun) {
                this.queryMix.setRun(nrRun + 1);
                System.out.print("Run: " + (nrRun + 1));
                while (this.queryMix.hasNext().booleanValue()) {
                    Query next = this.queryMix.getNext();
                    Object[] queryParameters = this.parameterPool.getParametersForQuery(next);
                    next.setParameters(queryParameters);
                    if (this.ignoreQueries[next.getNr() - 1]) {
                        this.queryMix.setCurrent(0, -1.0);
                    } else {
                        QueryResult queryResult = this.server.executeValidation(next, next.getQueryType());
                        if (queryResult != null) {
                            objectOutput.writeObject(queryResult);
                        }
                        this.queryMix.setCurrent(0, -1.0);
                    }
                    System.out.print(".");
                }
                this.queryMix.finishRun();
                System.out.println("done");
            }
            objectOutput.flush();
            objectOutput.close();
            System.out.println("\nQualification file created!");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void runRampup() {
        System.out.println("Starting Ramp-up. Writing measurement data to rampup.tsv");
        BufferedWriter measurementFile = null;
        try {
            measurementFile = new BufferedWriter(new FileWriter("rampup.tsv"));
        }
        catch (IOException e) {
            System.err.println("Could not create file rampup.tsv!");
            System.exit(-1);
        }
        int periodNr = 0;
        LinkedList<Double> periods = new LinkedList<Double>();
        double totalRuntime = 0.0;
        boolean unsteady = true;
        double minimumPeriod = Double.MAX_VALUE;
        while (unsteady) {
            ++periodNr;
            double runtime = 0.0;
            for (int nrRun = 1; nrRun <= this.qmsPerPeriod; ++nrRun) {
                this.queryMix.setRun(nrRun);
                while (this.queryMix.hasNext().booleanValue()) {
                    Query next = this.queryMix.getNext();
                    if (next.getQueryType() == 4) {
                        this.queryMix.setCurrent(0, -1.0);
                        continue;
                    }
                    Object[] queryParameters = this.parameterPool.getParametersForQuery(next);
                    next.setParameters(queryParameters);
                    if (this.ignoreQueries[next.getNr() - 1]) {
                        this.queryMix.setCurrent(0, -1.0);
                        continue;
                    }
                    this.server.executeQuery(next, next.getQueryType());
                }
                runtime += this.queryMix.getQueryMixRuntime();
                System.out.println("Period " + periodNr + " Run: " + nrRun + ": " + String.format(Locale.US, "%.3f", this.queryMix.getQueryMixRuntime() * 1000.0) + "ms");
                this.queryMix.finishRun();
            }
            try {
                measurementFile.append(periodNr + "\t" + runtime + "\n");
                measurementFile.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(-1);
            }
            totalRuntime += runtime;
            if (periodNr <= this.nrOfPeriods) {
                periods.addLast(runtime);
            } else {
                periods.addLast(runtime);
                periods.removeFirst();
                if (periods.size() != this.nrOfPeriods) {
                    throw new AssertionError();
                }
                double min = Double.MAX_VALUE;
                double max = Double.MIN_VALUE;
                Iterator i$ = periods.iterator();
                while (i$.hasNext()) {
                    double pVal = (Double)i$.next();
                    if (pVal < min) {
                        min = pVal;
                    }
                    if (pVal > max) {
                        max = pVal;
                    }
                    if (!(pVal <= minimumPeriod)) continue;
                    minimumPeriod = pVal;
                    max = Double.MAX_VALUE;
                    break;
                }
                if ((max - min) / min < this.percentDifference) {
                    unsteady = false;
                }
            }
            double all5 = 0.0;
            Iterator i$ = periods.iterator();
            while (i$.hasNext()) {
                double pVal = (Double)i$.next();
                all5 += pVal;
            }
            System.out.println("Total execution time for period " + periodNr + "/last " + (periodNr < this.nrOfPeriods ? periodNr : this.nrOfPeriods) + " periods: " + String.format(Locale.US, "%.3f", runtime * 1000.0) + "ms/" + String.format(Locale.US, "%.3f", all5 * 1000.0) + "ms\n");
        }
        try {
            measurementFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Steady state reached after " + periodNr + " measurement periods/" + String.format(Locale.US, "%.3f", totalRuntime) + "s");
        this.server.close();
    }

    public void runMT() {
        ClientManager manager = new ClientManager(this.parameterPool, this);
        manager.createClients();
        manager.startWarmup();
        manager.startRun();
        logger.log((Priority)Level.ALL, (Object)this.printResults(true));
        try {
            FileWriter resultWriter = new FileWriter(this.xmlResultFile);
            resultWriter.append(this.printXMLResults(true));
            resultWriter.flush();
            resultWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void processProgramParameters(String[] args) {
        int i = 0;
        while (i < args.length) {
            try {
                if (args[i].equals("-runs")) {
                    this.nrRuns = Integer.parseInt(args[i++ + 1]);
                } else if (args[i].equals("-idir")) {
                    this.resourceDir = args[i++ + 1];
                } else if (args[i].equals("-w")) {
                    this.warmups = Integer.parseInt(args[i++ + 1]);
                } else if (args[i].equals("-o")) {
                    this.xmlResultFile = args[i++ + 1];
                } else if (args[i].equals("-dg")) {
                    this.defaultGraph = args[i++ + 1];
                } else if (args[i].equals("-sql")) {
                    this.doSQL = true;
                } else if (args[i].equals("-mt")) {
                    if (this.rampup) {
                        throw new Exception("Incompatible options: -mt and -rampup");
                    }
                    this.multithreading = true;
                    this.nrThreads = Integer.parseInt(args[i++ + 1]);
                } else if (args[i].equals("-seed")) {
                    this.seed = Long.parseLong(args[i++ + 1]);
                } else if (args[i].equals("-t")) {
                    this.timeout = Integer.parseInt(args[i++ + 1]);
                } else if (args[i].equals("-dbdriver")) {
                    this.driverClassName = args[i++ + 1];
                } else if (args[i].equals("-qf")) {
                    this.qualificationFile = args[i++ + 1];
                } else if (args[i].equals("-q")) {
                    this.qualification = true;
                    this.nrRuns = 15;
                } else if (args[i].equals("-rampup")) {
                    if (this.multithreading) {
                        throw new Exception("Incompatible options: -mt and -rampup");
                    }
                    this.rampup = true;
                } else if (args[i].equals("-u")) {
                    this.sparqlUpdateEndpoint = args[i++ + 1];
                } else if (args[i].equals("-udataset")) {
                    this.updateFile = args[i++ + 1];
                } else if (args[i].equals("-ucf")) {
                    this.usecaseFile = new File(args[i++ + 1]);
                } else if (args[i].equals("-uqp")) {
                    sparqlUpdateQueryParameter = args[i++ + 1];
                } else if (!args[i].startsWith("-")) {
                    this.sparqlEndpoint = args[i];
                } else {
                    if (!args[i].equals("-help")) {
                        System.err.println("Unknown parameter: " + args[i]);
                    }
                    this.printUsageInfos();
                    System.exit(-1);
                }
                ++i;
            }
            catch (Exception e) {
                System.err.println("Invalid arguments:\n");
                e.printStackTrace();
                this.printUsageInfos();
                System.exit(-1);
            }
        }
    }

    public String printResults(boolean all) {
        StringBuffer sb = new StringBuffer(100);
        double singleMultiRatio = 0.0;
        sb.append("Scale factor:           " + this.parameterPool.getScalefactor() + "\n");
        sb.append("Number of warmup runs:  " + this.warmups + "\n");
        if (this.multithreading) {
            sb.append("Number of clients:      " + this.nrThreads + "\n");
        }
        sb.append("Seed:                   " + this.seed + "\n");
        sb.append("Number of query mix runs (without warmups): " + this.queryMix.getQueryMixRuns() + " times\n");
        sb.append("min/max Querymix runtime: " + String.format(Locale.US, "%.4fs", this.queryMix.getMinQueryMixRuntime()) + " / " + String.format(Locale.US, "%.4fs", this.queryMix.getMaxQueryMixRuntime()) + "\n");
        if (this.multithreading) {
            sb.append("Total runtime (sum):    " + String.format(Locale.US, "%.3f", this.queryMix.getTotalRuntime()) + " seconds\n");
            sb.append("Total actual runtime:   " + String.format(Locale.US, "%.3f", this.queryMix.getMultiThreadRuntime()) + " seconds\n");
            singleMultiRatio = this.queryMix.getTotalRuntime() / this.queryMix.getMultiThreadRuntime();
        } else {
            sb.append("Total runtime:          " + String.format(Locale.US, "%.3f", this.queryMix.getTotalRuntime()) + " seconds\n");
        }
        if (this.multithreading) {
            sb.append("QMpH:                   " + String.format(Locale.US, "%.2f", this.queryMix.getMultiThreadQmpH()) + " query mixes per hour\n");
        } else {
            sb.append("QMpH:                   " + String.format(Locale.US, "%.2f", this.queryMix.getQmph()) + " query mixes per hour\n");
        }
        sb.append("CQET:                   " + String.format(Locale.US, "%.5f", this.queryMix.getCQET()) + " seconds average runtime of query mix\n");
        sb.append("CQET (geom.):           " + String.format(Locale.US, "%.5f", this.queryMix.getQueryMixGeometricMean()) + " seconds geometric mean runtime of query mix\n");
        if (all) {
            sb.append("\n");
            Query[] queries = this.queryMix.getQueries();
            double[] qmin = this.queryMix.getQmin();
            double[] qmax = this.queryMix.getQmax();
            double[] qavga = this.queryMix.getAqet();
            double[] avgResults = this.queryMix.getAvgResults();
            double[] qavgg = this.queryMix.getGeoMean();
            int[] qTimeout = this.queryMix.getTimeoutsPerQuery();
            int[] minResults = this.queryMix.getMinResults();
            int[] maxResults = this.queryMix.getMaxResults();
            int[] nrq = this.queryMix.getRunsPerQuery();
            for (int i = 0; i < qmin.length; ++i) {
                if (queries[i] == null) continue;
                sb.append("Metrics for Query:      " + (i + 1) + "\n");
                sb.append("Count:                  " + nrq[i] + " times executed in whole run\n");
                sb.append("AQET:                   " + String.format(Locale.US, "%.6f", qavga[i]) + " seconds (arithmetic mean)\n");
                sb.append("AQET(geom.):            " + String.format(Locale.US, "%.6f", qavgg[i]) + " seconds (geometric mean)\n");
                if (this.multithreading) {
                    sb.append("QPS:                    " + String.format(Locale.US, "%.2f", singleMultiRatio / qavga[i]) + " Queries per second\n");
                } else {
                    sb.append("QPS:                    " + String.format(Locale.US, "%.2f", 1.0 / qavga[i]) + " Queries per second\n");
                }
                sb.append("minQET/maxQET:          " + String.format(Locale.US, "%.8fs", qmin[i]) + " / " + String.format(Locale.US, "%.8fs", qmax[i]) + "\n");
                if (queries[i].getQueryType() == 1) {
                    sb.append("Average result count:   " + String.format(Locale.US, "%.2f", avgResults[i]) + "\n");
                    sb.append("min/max result count:   " + minResults[i] + " / " + maxResults[i] + "\n");
                } else {
                    sb.append("Average result (Bytes): " + String.format(Locale.US, "%.2f", avgResults[i]) + "\n");
                    sb.append("min/max result (Bytes): " + minResults[i] + " / " + maxResults[i] + "\n");
                }
                sb.append("Number of timeouts:     " + qTimeout[i] + "\n\n");
            }
        }
        return sb.toString();
    }

    public String printXMLResults(boolean all) {
        StringBuffer sb = new StringBuffer(100);
        double singleMultiRatio = 0.0;
        sb.append("<?xml version=\"1.0\"?>");
        sb.append("<bsbm>\n");
        sb.append("  <querymix>\n");
        sb.append("     <scalefactor>" + this.parameterPool.getScalefactor() + "</scalefactor>\n");
        sb.append("     <warmups>" + this.warmups + "</warmups>\n");
        if (this.multithreading) {
            sb.append("     <nrthreads>" + this.nrThreads + "</nrthreads>\n");
        }
        sb.append("     <seed>" + this.seed + "</seed>\n");
        sb.append("     <querymixruns>" + this.queryMix.getQueryMixRuns() + "</querymixruns>\n");
        sb.append("     <minquerymixruntime>" + String.format(Locale.US, "%.4f", this.queryMix.getMinQueryMixRuntime()) + "</minquerymixruntime>\n");
        sb.append("     <maxquerymixruntime>" + String.format(Locale.US, "%.4f", this.queryMix.getMaxQueryMixRuntime()) + "</maxquerymixruntime>\n");
        if (this.multithreading) {
            sb.append("     <totalruntime>" + String.format(Locale.US, "%.3f", this.queryMix.getTotalRuntime()) + "</totalruntime>\n");
            sb.append("     <actualtotalruntime>" + String.format(Locale.US, "%.3f", this.queryMix.getMultiThreadRuntime()) + "</actualtotalruntime>\n");
            singleMultiRatio = this.queryMix.getTotalRuntime() / this.queryMix.getMultiThreadRuntime();
        } else {
            sb.append("     <totalruntime>" + String.format(Locale.US, "%.3f", this.queryMix.getTotalRuntime()) + "</totalruntime>\n");
            singleMultiRatio = 1.0;
        }
        if (this.multithreading) {
            sb.append("     <qmph>" + String.format(Locale.US, "%.2f", this.queryMix.getMultiThreadQmpH()) + "</qmph>\n");
        } else {
            sb.append("     <qmph>" + String.format(Locale.US, "%.2f", this.queryMix.getQmph()) + "</qmph>\n");
        }
        sb.append("     <cqet>" + String.format(Locale.US, "%.5f", this.queryMix.getCQET()) + "</cqet>\n");
        sb.append("     <cqetg>" + String.format(Locale.US, "%.5f", this.queryMix.getQueryMixGeometricMean()) + "</cqetg>\n");
        sb.append("  </querymix>\n");
        if (all) {
            sb.append("  <queries>\n");
            Query[] queries = this.queryMix.getQueries();
            double[] qmin = this.queryMix.getQmin();
            double[] qmax = this.queryMix.getQmax();
            double[] qavga = this.queryMix.getAqet();
            double[] avgResults = this.queryMix.getAvgResults();
            double[] qavgg = this.queryMix.getGeoMean();
            int[] qTimeout = this.queryMix.getTimeoutsPerQuery();
            int[] minResults = this.queryMix.getMinResults();
            int[] maxResults = this.queryMix.getMaxResults();
            int[] nrq = this.queryMix.getRunsPerQuery();
            for (int i = 0; i < qmin.length; ++i) {
                if (queries[i] != null) {
                    sb.append("    <query nr=\"" + (i + 1) + "\">\n");
                    sb.append("      <executecount>" + nrq[i] + "</executecount>\n");
                    sb.append("      <aqet>" + String.format(Locale.US, "%.6f", qavga[i]) + "</aqet>\n");
                    sb.append("      <aqetg>" + String.format(Locale.US, "%.6f", qavgg[i]) + "</aqetg>\n");
                    sb.append("      <qps>" + String.format(Locale.US, "%.2f", singleMultiRatio / qavga[i]) + "</qps>\n");
                    sb.append("      <minqet>" + String.format(Locale.US, "%.8f", qmin[i]) + "</minqet>\n");
                    sb.append("      <maxqet>" + String.format(Locale.US, "%.8f", qmax[i]) + "</maxqet>\n");
                    sb.append("      <avgresults>" + String.format(Locale.US, "%.2f", avgResults[i]) + "</avgresults>\n");
                    sb.append("      <minresults>" + minResults[i] + "</minresults>\n");
                    sb.append("      <maxresults>" + maxResults[i] + "</maxresults>\n");
                    sb.append("      <timeoutcount>" + qTimeout[i] + "</timeoutcount>\n");
                    sb.append("    </query>\n");
                    continue;
                }
                sb.append("    <query nr=\"" + (i + 1) + "\">\n");
                sb.append("      <executecount>0</executecount>\n");
                sb.append("      <aqet>0.0</aqet>\n");
                sb.append("    </query>\n");
            }
            sb.append("  </queries>\n");
        }
        sb.append("</bsbm>\n");
        return sb.toString();
    }

    protected void printUsageInfos() {
        String output = "Usage: java benchmark.testdriver.TestDriver <options> SPARQL-Endpoint\n\nSPARQL-Endpoint: The URL of the HTTP SPARQL Endpoint\n\nPossible options are:\n\t-runs <number of query mix runs>\n\t\tdefault: " + TestDriverDefaultValues.nrRuns + "\n" + "\t-idir <data input directory>\n" + "\t\tThe input directory for the Test Driver data\n" + "\t\tdefault: " + TestDriverDefaultValues.resourceDir + "\n" + "\t-ucf <use case file name>\n" + "\t\tSpecifies where the use case description file can be found.\n" + "\t\tdefault: " + TestDriverDefaultValues.usecaseFile + "\n" + "\t-w <number of warm up runs before actual measuring>\n" + "\t\tdefault: " + TestDriverDefaultValues.warmups + "\n" + "\t-o <benchmark results output file>\n" + "\t\tdefault: " + TestDriverDefaultValues.xmlResultFile + "\n" + "\t-dg <Default Graph>\n" + "\t\tdefault: " + TestDriverDefaultValues.defaultGraph + "\n" + "\t-sql\n" + "\t\tuse JDBC connection to a RDBMS. Instead of a SPARQL-Endpoint, a JDBC URL has to be supplied.\n" + "\t\tdefault: not set\n" + "\t-mt <Number of clients>\n" + "\t\tRun multiple clients concurrently.\n" + "\t\tdefault: not set\n" + "\t-seed <Long Integer>\n" + "\t\tInit the Test Driver with another seed than the default.\n" + "\t\tdefault: " + TestDriverDefaultValues.seed + "\n" + "\t-t <timeout in ms>\n" + "\t\tTimeouts will be logged for the result report.\n" + "\t\tdefault: " + TestDriverDefaultValues.timeoutInMs + "ms\n" + "\t-dbdriver <DB-Driver Class Name>\n" + "\t\tdefault: " + TestDriverDefaultValues.driverClassName + "\n" + "\t-u <Sparql Update Service Endpoint URL>\n" + "\t\tUse this if you have SPARQL Update queries in your query mix.\n" + "\t-udataset <update dataset file name>\n" + "\t\tSpecified an update file generated by the BSBM dataset generator.\n" + "\t-q\n" + "\t\tTurn on qualification mode instead of doing a test run.\n" + "\t\tdefault: " + TestDriverDefaultValues.qualification + "\n" + "\t-qf <qualification file name>\n" + "\t\tTo change the  filename from its default.\n" + "\t\tdefault: " + TestDriverDefaultValues.qualificationFile + "\n" + "\t-rampup\n" + "\t\tRun ramp-up to reach steady state.\n" + "\t-uqp <update query parameter>\n" + "\t\tThe forms parameter name for the query string.\n" + "\t\tdefault: " + TestDriverDefaultValues.updateQueryParameter + "\n";
        System.out.print(output);
    }

    public static void main(String[] argv) {
        DOMConfigurator.configureAndWatch((String)"log4j.xml", (long)60000L);
        TestDriver testDriver = new TestDriver(argv);
        testDriver.init();
        System.out.println("\nStarting test...\n");
        if (testDriver.multithreading) {
            testDriver.runMT();
            System.out.println("\n" + testDriver.printResults(true));
        } else if (testDriver.qualification) {
            testDriver.runQualification();
        } else if (testDriver.rampup) {
            testDriver.runRampup();
        } else {
            testDriver.run();
            System.out.println("\n" + testDriver.printResults(true));
        }
    }

    static class TestDriverShutdown
    extends Thread {
        TestDriver testdriver;

        TestDriverShutdown(TestDriver t) {
            this.testdriver = t;
        }

        @Override
        public void run() {
            try {
                if (this.testdriver.server != null) {
                    this.testdriver.server.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

