/*
 * Decompiled with CFR 0.152.
 */
package benchmark.tools;

import benchmark.tools.FileFilter;
import benchmark.tools.IntReference;
import benchmark.tools.ResultHandler;
import benchmark.tools.StringLengthComparator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class ResultTransform {
    static StringBuffer sb;
    static FileWriter query_size_of_stores;
    static FileWriter store_size_of_queries;
    static FileWriter size_store_of_queries;
    static FileWriter store_query_of_size;
    static FileWriter overview;
    static String[][][] storesQueriesSizes;
    static String[][] storesSizes;
    static String[][] dimensionArrays;
    private static final String[] queries;
    private static final String[] sizes;
    private static final String queryLink = "http://www4.wiwiss.fu-berlin.de/bizer/BerlinSPARQLBenchmark/spec/index.html#queryTripleQ";
    private static HashMap<String, Integer> sizeMap;
    static String tabledef;
    static String queryParameter;
    static int queryParameterPrecision;
    static String querymixParameter;
    static boolean american;

    public static void main(String[] argv) {
        int i;
        String[] storeNames = new String[argv.length];
        File[] storeDirs = new File[argv.length];
        for (i = 0; i < sizes.length; ++i) {
            sizeMap.put(sizes[i], i);
        }
        ResultTransform.init();
        for (i = 0; i < argv.length; ++i) {
            try {
                storeDirs[i] = new File(argv[i]);
                storeDirs[i].createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(-1);
            }
            storeNames[i] = storeDirs[i].getName();
        }
        ResultTransform.createHtmlFile(query_size_of_stores);
        ResultTransform.createHtmlFile(store_size_of_queries);
        ResultTransform.createHtmlFile(size_store_of_queries);
        ResultTransform.createHtmlFile(store_query_of_size);
        ResultTransform.createHtmlFile(overview);
        storesQueriesSizes = new String[storeNames.length][sizes.length][queries.length];
        storesSizes = new String[storeNames.length][sizes.length];
        dimensionArrays = new String[3][];
        ResultTransform.dimensionArrays[0] = storeNames;
        ResultTransform.dimensionArrays[1] = sizes;
        ResultTransform.dimensionArrays[2] = queries;
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            ResultHandler handler = new ResultHandler();
            for (int x = 0; x < storeNames.length; ++x) {
                File[] files = storeDirs[x].listFiles(new FileFilter());
                if (files == null) {
                    System.err.println("Can't read files from directory: " + storeDirs[x].getAbsolutePath());
                    System.exit(-1);
                }
                for (int i2 = 0; i2 < files.length; ++i2) {
                    File file = files[i2];
                    int sizeIndex = ResultTransform.checkSizeIndex(file.getName());
                    if (sizeIndex == -1) {
                        System.err.println("Error: XML result file names must contain size metrics e.g. store_50k.xml for " + file.getName());
                        continue;
                    }
                    FileInputStream is = new FileInputStream(file);
                    String[] queries = storesQueriesSizes[x][sizeIndex];
                    handler.setArray(queries);
                    saxParser.parse((InputStream)is, (DefaultHandler)handler);
                    ResultTransform.storesSizes[x][sizeIndex] = handler.getQmValue();
                }
            }
        }
        catch (Exception e) {
            System.err.println("SAX Error");
            e.printStackTrace();
        }
        try {
            ResultTransform.create_query_size_of_stores_table(storeNames);
            ResultTransform.create_store_query_of_sizes_table(sizes);
            ResultTransform.create_store_size_of_query_table(queries);
            ResultTransform.create_size_store_of_query_table(queries);
            ResultTransform.create_overview_table();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        ResultTransform.closeHtmlFile(query_size_of_stores);
        ResultTransform.closeHtmlFile(store_size_of_queries);
        ResultTransform.closeHtmlFile(size_store_of_queries);
        ResultTransform.closeHtmlFile(store_query_of_size);
        ResultTransform.closeHtmlFile(overview);
        System.out.println("done");
    }

    private static int checkSizeIndex(String name) {
        String[] sortedSizes = (String[])sizes.clone();
        Arrays.sort(sortedSizes, new StringLengthComparator());
        for (int i = 0; i < sortedSizes.length; ++i) {
            if (!name.toLowerCase().contains(sortedSizes[i].toLowerCase())) continue;
            return sizeMap.get(sortedSizes[i]);
        }
        return -1;
    }

    private static void createHtmlFile(FileWriter fw) {
        try {
            fw.append("<html>\n<head>\n  <title>Benchmark Results</title>\n</head>\n");
            fw.append("<body>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void closeHtmlFile(FileWriter fw) {
        try {
            fw.append("</body></html>");
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String createHtmlTable(String name, int dimX, int dimY, int fixedDim, int fixedValue, boolean overall) {
        StringBuffer sb = new StringBuffer();
        String[] xDimArray = dimensionArrays[dimX];
        String[] yDimArray = dimensionArrays[dimY];
        IntReference x = null;
        IntReference y = null;
        IntReference storeInd = new IntReference(0);
        IntReference queryInd = new IntReference(0);
        IntReference sizeInd = new IntReference(0);
        String queryDim = "";
        if (dimX == 0) {
            x = storeInd;
        } else if (dimX == 1) {
            x = sizeInd;
        } else if (dimX == 2) {
            x = queryInd;
            queryDim = "X";
        }
        if (dimY == 0) {
            y = storeInd;
        } else if (dimY == 1) {
            y = sizeInd;
        } else if (dimY == 2) {
            y = queryInd;
            queryDim = "Y";
        }
        if (fixedDim == 0) {
            storeInd = new IntReference(fixedValue);
        } else if (fixedDim == 1) {
            sizeInd = new IntReference(fixedValue);
        } else if (fixedDim == 2) {
            queryInd = new IntReference(fixedValue);
            queryDim = "Fixed";
        }
        assert (queryDim.equals("")) : "Query dimension not set!";
        if (x == null || y == null) {
            System.err.println("Wrong dimension setting");
            System.exit(-1);
        }
        sb.append("<h4>" + name + "</h4>\n");
        sb.append(tabledef);
        sb.append("<b><tr><th>&nbsp;</th>");
        for (int i = 0; i < xDimArray.length; ++i) {
            sb.append("<th>" + xDimArray[i] + "</th>");
        }
        sb.append("</tr>\n");
        y.setValue(0);
        while (y.getValue() < yDimArray.length) {
            String link = yDimArray[y.getValue()];
            if (queryDim.equals("Y")) {
                link = "<a href=\"http://www4.wiwiss.fu-berlin.de/bizer/BerlinSPARQLBenchmark/spec/index.html#queryTripleQ" + (y.getValue() + 1) + "\">" + yDimArray[y.getValue()] + "</a>";
            }
            sb.append("<tr><td width=\"29%\"><strong>" + link + "</strong></td>");
            x.setValue(0);
            while (x.getValue() < xDimArray.length) {
                String val = overall ? storesSizes[storeInd.getValue()][sizeInd.getValue()] : storesQueriesSizes[storeInd.getValue()][sizeInd.getValue()][queryInd.getValue()];
                if (val != null) {
                    if (val.equals("0.0")) {
                        sb.append("<td>not executed</td>");
                    } else {
                        String formatString = "%." + queryParameterPrecision + "f";
                        if (american) {
                            sb.append("<td>" + String.format(formatString, Double.parseDouble(val)).replace(',', '.') + "</td>");
                        } else {
                            sb.append("<td>" + String.format(formatString, Double.parseDouble(val)).replace('.', ',') + "</td>");
                        }
                    }
                } else {
                    sb.append("<td>no value</td>");
                }
                x.inc();
            }
            sb.append("</tr>\n");
            y.inc();
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    private static void create_query_size_of_stores_table(String[] stores) throws IOException {
        for (int i = 0; i < stores.length; ++i) {
            query_size_of_stores.append(ResultTransform.createHtmlTable(stores[i], 1, 2, 0, i, false));
        }
    }

    private static void create_store_size_of_query_table(String[] queries) throws IOException {
        for (int i = 0; i < queries.length; ++i) {
            store_size_of_queries.append(ResultTransform.createHtmlTable("<b><a href=\"http://www4.wiwiss.fu-berlin.de/bizer/BerlinSPARQLBenchmark/spec/index.html#queryTripleQ" + (i + 1) + "\">" + queries[i] + "</a></b>", 1, 0, 2, i, false));
        }
    }

    private static void create_overview_table() throws IOException {
        overview.append(ResultTransform.createHtmlTable(querymixParameter, 1, 0, 2, 0, true));
        overview.append(ResultTransform.createHtmlTable(querymixParameter, 0, 1, 2, 0, true));
    }

    private static void create_size_store_of_query_table(String[] queries) throws IOException {
        for (int i = 0; i < queries.length; ++i) {
            size_store_of_queries.append(ResultTransform.createHtmlTable("<a href=\"http://www4.wiwiss.fu-berlin.de/bizer/BerlinSPARQLBenchmark/spec/index.html#queryTripleQ" + (i + 1) + "\">" + queries[i] + "</a>", 0, 1, 2, i, false));
        }
    }

    private static void create_store_query_of_sizes_table(String[] sizes) throws IOException {
        for (int i = 0; i < sizes.length; ++i) {
            store_query_of_size.append(ResultTransform.createHtmlTable(sizes[i], 0, 2, 1, i, false));
        }
    }

    private static void init() {
        try {
            query_size_of_stores = new FileWriter("bsbm_query_and_size_tables_of_stores.html");
            store_size_of_queries = new FileWriter("bsbm_store_and_size_tables_of_queries.html");
            size_store_of_queries = new FileWriter("bsbm_size_and_store_tables_of_queries.html");
            store_query_of_size = new FileWriter("bsbm_store_and_query_tables_of_sizes.html");
            overview = new FileWriter("overview.html");
        }
        catch (IOException e) {
            System.err.println("Could not open Input directories!");
            System.exit(-1);
        }
    }

    static {
        queries = new String[]{"Query 1", "Query 2", "Query 3", "Query 4", "Query 5", "Query 6", "Query 7", "Query 8", "Query 9", "Query 10", "Query 11", "Query 12"};
        sizes = new String[]{"100m", "200m"};
        sizeMap = new HashMap();
        tabledef = "<table style=\"text-align: center; width: 60%;\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\">";
        queryParameter = "qps";
        queryParameterPrecision = 1;
        querymixParameter = "qmph";
        american = true;
    }
}

